/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.other;

import com.mojang.blaze3d.matrix.MatrixStack;
import extensions.net.minecraft.world.entity.Entity.PropertyProvider;
import moe.plushie.armourers_workshop.api.client.model.IModel;
import moe.plushie.armourers_workshop.core.client.bake.BakedSkin;
import moe.plushie.armourers_workshop.core.client.bake.SkinBakery;
import moe.plushie.armourers_workshop.core.client.model.MannequinModel;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderContext;
import moe.plushie.armourers_workshop.core.client.render.SkinItemRenderer;
import moe.plushie.armourers_workshop.core.client.skinrender.SkinRenderer;
import moe.plushie.armourers_workshop.core.client.skinrender.SkinRendererManager;
import moe.plushie.armourers_workshop.core.data.ticket.Ticket;
import moe.plushie.armourers_workshop.core.entity.MannequinEntity;
import moe.plushie.armourers_workshop.core.skin.SkinDescriptor;
import moe.plushie.armourers_workshop.utils.ModelHolder;
import moe.plushie.armourers_workshop.utils.math.Rectangle3f;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SkinRenderTesselator
extends SkinRenderContext {
    private final BakedSkin bakedSkin;
    private final MannequinEntity mannequin;
    private final MannequinModel<?> mannequinModel;
    private final SkinRenderer<Entity, IModel> renderer;

    public SkinRenderTesselator(BakedSkin bakedSkin, MannequinEntity mannequin, MannequinModel<?> mannequinModel, SkinRenderer<Entity, IModel> renderer) {
        super(null);
        this.bakedSkin = bakedSkin;
        this.mannequin = mannequin;
        this.mannequinModel = mannequinModel;
        this.renderer = renderer;
    }

    public static SkinRenderTesselator create(SkinDescriptor descriptor, Ticket ticket) {
        BakedSkin bakedSkin = SkinBakery.getInstance().loadSkin(descriptor, ticket);
        if (bakedSkin != null) {
            return SkinRenderTesselator.create(bakedSkin);
        }
        return null;
    }

    public static SkinRenderTesselator create(BakedSkin bakedSkin) {
        MannequinEntity mannequin = SkinItemRenderer.getInstance().getMannequinEntity();
        MannequinModel<?> mannequinModel = SkinItemRenderer.getInstance().getMannequinModel();
        SkinRenderer<Entity, IModel> renderer = SkinRendererManager.getInstance().getRenderer((Entity)mannequin, (Model)mannequinModel, null);
        if (renderer == null || mannequin == null || PropertyProvider.getLevel((Entity)mannequin) == null) {
            return null;
        }
        return new SkinRenderTesselator(bakedSkin, mannequin, mannequinModel, renderer);
    }

    public int draw(MatrixStack poseStack, IRenderTypeBuffer buffers) {
        Object model = ModelHolder.of(this.mannequinModel);
        this.setPose(poseStack);
        this.setBuffers(buffers);
        this.setTransforms((Entity)this.mannequin, this.renderer.getOverrideModel((IModel)model));
        return this.renderer.render((Entity)this.mannequin, (IModel)model, this.bakedSkin, this.getColorScheme(), this);
    }

    public MannequinEntity getMannequin() {
        return this.mannequin;
    }

    public BakedSkin getBakedSkin() {
        return this.bakedSkin;
    }

    public Rectangle3f getBakedRenderBounds() {
        return this.bakedSkin.getRenderBounds((Entity)this.mannequin, (Model)this.mannequinModel, this.getReferenceRotation(), this.getReference());
    }
}

