/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.other;

import moe.plushie.armourers_workshop.api.client.IRenderTypeBuilder;
import moe.plushie.armourers_workshop.api.skin.ISkinCubeType;
import moe.plushie.armourers_workshop.compatibility.AbstractRenderType;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderFormat;
import moe.plushie.armourers_workshop.init.ModTextures;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class SkinRenderType
implements IRenderTypeBuilder {
    public static final RenderType GUI_IMAGE = SkinRenderType._builder(SkinRenderFormat.GUI_IMAGE).transparency(IRenderTypeBuilder.Transparency.TRANSLUCENT).build("aw_gui_image");
    public static final RenderType GUI_HIGHLIGHTED_TEXT = SkinRenderType._builder(SkinRenderFormat.GUI_HIGHLIGHTED_TEXT).transparency(IRenderTypeBuilder.Transparency.TRANSLUCENT).colorLogic(IRenderTypeBuilder.ColorLogic.OR_REVERSE).depthTest(IRenderTypeBuilder.DepthTest.NONE).build("aw_highlighted_text");
    public static final RenderType GUI_COLOR = SkinRenderType._builder(SkinRenderFormat.GUI_COLOR).transparency(IRenderTypeBuilder.Transparency.DEFAULT).build("aw_gui_color");
    public static final RenderType IMAGE_MAGIC = SkinRenderType._texture(ModTextures.CIRCLE).writeMask(IRenderTypeBuilder.WriteMask.COLOR_WRITE).sortOnUpload().build("aw_image_magic");
    public static final RenderType IMAGE_EARTH = SkinRenderType._texture(ModTextures.EARTH).build("aw_image_earth");
    public static final RenderType IMAGE_GUIDE = SkinRenderType._texture(ModTextures.GUIDES).polygonOffset(-1.0f, -10.0f).build("aw_image_guide");
    public static final RenderType IMAGE_MARKER = SkinRenderType._texture2(ModTextures.MARKERS).polygonOffset(-1.0f, -10.0f).cull().build("aw_image_marker");
    public static final RenderType HIGHLIGHTED_LINES = SkinRenderType._line().depthTest(IRenderTypeBuilder.DepthTest.NONE).build("aw_lines");
    public static final RenderType HIGHLIGHTED_ENTITY_LINES = SkinRenderType._entityHighlight(ModTextures.MANNEQUIN_HIGHLIGHT).build("aw_entity_lines");
    public static final RenderType PLAYER_CUTOUT = SkinRenderType.entityCutout(ModTextures.MANNEQUIN_DEFAULT);
    public static final RenderType PLAYER_CUTOUT_NO_CULL = SkinRenderType.entityCutoutNoCull(ModTextures.MANNEQUIN_DEFAULT);
    public static final RenderType PLAYER_TRANSLUCENT = SkinRenderType.entityTranslucentCull(ModTextures.MANNEQUIN_DEFAULT);
    public static final RenderType BLOCK_CUBE = SkinRenderType._block(ModTextures.BLOCK_CUBE).build("aw_block_cube");
    public static final RenderType BLOCK_CUBE_GLASS = SkinRenderType._block(ModTextures.BLOCK_CUBE_GLASS).transparency(IRenderTypeBuilder.Transparency.TRANSLUCENT).sortOnUpload().build("aw_block_cube_glass");
    public static final RenderType BLOCK_CUBE_GLASS_UNSORTED = SkinRenderType._block(ModTextures.BLOCK_CUBE_GLASS).transparency(IRenderTypeBuilder.Transparency.TRANSLUCENT).build("aw_block_cube_glass_unsorted");
    public static final RenderType FACE_SOLID = SkinRenderType._cube(SkinRenderFormat.SKIN_FACE_SOLID).texture(ModTextures.CUBE).build("aw_face_sold");
    public static final RenderType FACE_LIGHTING = SkinRenderType._cube(SkinRenderFormat.SKIN_FACE_LIGHTING).texture(ModTextures.LIGHTING_CUBE).build("aw_lighting_quad_face");
    public static final RenderType FACE_TRANSLUCENT = SkinRenderType._cube(SkinRenderFormat.SKIN_FACE_TRANSLUCENT).texture(ModTextures.CUBE).transparency(IRenderTypeBuilder.Transparency.TRANSLUCENT).target(IRenderTypeBuilder.Target.TRANSLUCENT).build("aw_translucent_quad_face");
    public static final RenderType FACE_LIGHTING_TRANSLUCENT = SkinRenderType._cube(SkinRenderFormat.SKIN_FACE_LIGHTING_TRANSLUCENT).texture(ModTextures.LIGHTING_CUBE).transparency(IRenderTypeBuilder.Transparency.TRANSLUCENT).target(IRenderTypeBuilder.Target.TRANSLUCENT).build("aw_translucent_lighting_quad_face");
    public static final RenderType[] RENDER_ORDERING_FACES = new RenderType[]{FACE_SOLID, FACE_LIGHTING, FACE_TRANSLUCENT, FACE_LIGHTING_TRANSLUCENT};

    public static RenderType by(ISkinCubeType cubeType) {
        if (cubeType.isGlass()) {
            if (cubeType.isGlowing()) {
                return FACE_LIGHTING_TRANSLUCENT;
            }
            return FACE_TRANSLUCENT;
        }
        if (cubeType.isGlowing()) {
            return FACE_LIGHTING;
        }
        return FACE_SOLID;
    }

    public static RenderType lines() {
        return RenderType.func_228659_m_();
    }

    public static RenderType entityCutout(ResourceLocation texture) {
        return SkinRenderType._entity(SkinRenderFormat.ENTITY_CUTOUT, texture).cull().build("aw_player_solid");
    }

    public static RenderType entityCutoutNoCull(ResourceLocation texture) {
        return SkinRenderType._entity(SkinRenderFormat.ENTITY_CUTOUT_NO_CULL, texture).build("aw_player_cutout");
    }

    public static RenderType entityTranslucentCull(ResourceLocation texture) {
        return SkinRenderType._entity(SkinRenderFormat.ENTITY_TRANSLUCENT, texture).cull().transparency(IRenderTypeBuilder.Transparency.TRANSLUCENT).build("aw_player_translucent");
    }

    private static IRenderTypeBuilder _entity(SkinRenderFormat format, ResourceLocation texture) {
        return SkinRenderType._builder(format).texture(texture).polygonOffset(0.0f, 30.0f).overlay().lightmap().sortOnUpload().crumbling().outline();
    }

    private static IRenderTypeBuilder _entityHighlight(ResourceLocation texture) {
        return SkinRenderType._builder(SkinRenderFormat.ENTITY_ALPHA).texture(texture).overlay().lightmap();
    }

    private static IRenderTypeBuilder _cube(SkinRenderFormat format) {
        return SkinRenderType._builder(format);
    }

    private static IRenderTypeBuilder _texture(ResourceLocation texture) {
        return SkinRenderType._builder(SkinRenderFormat.IMAGE).texture(texture).transparency(IRenderTypeBuilder.Transparency.TRANSLUCENT).target(IRenderTypeBuilder.Target.TRANSLUCENT);
    }

    private static IRenderTypeBuilder _texture2(ResourceLocation texture) {
        return SkinRenderType._builder(SkinRenderFormat.BLOCK_CUTOUT).texture(texture).overlay().lightmap();
    }

    private static IRenderTypeBuilder _block(ResourceLocation texture) {
        return SkinRenderType._builder(SkinRenderFormat.BLOCK).texture(texture).overlay().lightmap();
    }

    private static IRenderTypeBuilder _line() {
        return SkinRenderType._builder(SkinRenderFormat.LINE).lineWidth(2.0f).polygonOffset(0.0f, 10.0f);
    }

    private static IRenderTypeBuilder _builder(SkinRenderFormat format) {
        return AbstractRenderType.builder(format);
    }
}

