/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.other;

import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.HashMap;
import moe.plushie.armourers_workshop.api.client.IRenderAttachable;
import moe.plushie.armourers_workshop.compatibility.AbstractShader;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderObjectBuilder;
import moe.plushie.armourers_workshop.core.client.shader.ShaderVertexGroup;
import moe.plushie.armourers_workshop.core.client.shader.ShaderVertexMerger;
import moe.plushie.armourers_workshop.core.client.shader.ShaderVertexObject;
import moe.plushie.armourers_workshop.core.skin.Skin;
import moe.plushie.armourers_workshop.utils.ObjectUtils;
import net.minecraft.client.renderer.Atlases;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class SkinVertexBufferBuilder
extends BufferBuilder
implements IRenderTypeBuffer {
    private static SkinVertexBufferBuilder MERGED_VERTEX_BUILDER;
    protected final Pipeline pipeline = new Pipeline();
    protected final HashMap<Skin, SkinRenderObjectBuilder> cachingBuilders = new HashMap();
    protected final HashMap<RenderType, BufferBuilder> cachingBuilders2 = new HashMap();
    protected final HashMap<Skin, SkinRenderObjectBuilder> pendingBuilders = new HashMap();
    protected final HashMap<RenderType, BufferBuilder> pendingBuilders2 = new HashMap();

    public SkinVertexBufferBuilder() {
        super(256);
    }

    public static SkinVertexBufferBuilder getBuffer(IRenderTypeBuffer buffers) {
        SkinVertexBufferBuilder.attach(buffers, Atlases.func_228782_g_(), SkinVertexBufferBuilder::renderSolid);
        return SkinVertexBufferBuilder.getInstance();
    }

    private static void attach(IRenderTypeBuffer buffers, RenderType renderType, Runnable action) {
        IVertexBuilder ignored = buffers.getBuffer(renderType);
        IRenderAttachable builder = ObjectUtils.safeCast(renderType, IRenderAttachable.class);
        if (builder != null) {
            builder.attachRenderTask(action);
        }
    }

    public static void renderSolid() {
        SkinVertexBufferBuilder.getInstance().flush();
    }

    public static void renderTranslucent() {
        SkinVertexBufferBuilder.getInstance().flush();
    }

    public static SkinVertexBufferBuilder getInstance() {
        if (MERGED_VERTEX_BUILDER == null) {
            MERGED_VERTEX_BUILDER = new SkinVertexBufferBuilder();
        }
        return MERGED_VERTEX_BUILDER;
    }

    public static void clearAllCache() {
        SkinVertexBufferBuilder builder = SkinVertexBufferBuilder.getInstance();
        builder.cachingBuilders.clear();
        builder.cachingBuilders2.clear();
        SkinRenderObjectBuilder.clearAllCache();
    }

    @NotNull
    public IVertexBuilder getBuffer(@NotNull RenderType renderType) {
        BufferBuilder buffer = this.pendingBuilders2.get(renderType);
        if (buffer != null) {
            return buffer;
        }
        buffer = this.cachingBuilders2.computeIfAbsent(renderType, k -> new BufferBuilder(k.func_228662_o_()));
        buffer.func_181668_a(renderType.func_228664_q_(), renderType.func_228663_p_());
        this.pendingBuilders2.put(renderType, buffer);
        return buffer;
    }

    public SkinRenderObjectBuilder getBuffer(@NotNull Skin skin) {
        SkinRenderObjectBuilder bufferBuilder = this.pendingBuilders.get(skin);
        if (bufferBuilder != null) {
            return bufferBuilder;
        }
        bufferBuilder = this.cachingBuilders.computeIfAbsent(skin, SkinRenderObjectBuilder::new);
        this.pendingBuilders.put(skin, bufferBuilder);
        return bufferBuilder;
    }

    public void flush() {
        if (!this.pendingBuilders.isEmpty()) {
            for (SkinRenderObjectBuilder builder : this.pendingBuilders.values()) {
                builder.endBatch(this.pipeline);
            }
            this.pendingBuilders.clear();
            this.pipeline.end();
        }
        if (!this.pendingBuilders2.isEmpty()) {
            this.pendingBuilders2.forEach((key, value) -> key.func_228631_a_(value, 0, 0, 0));
            this.pendingBuilders2.clear();
        }
    }

    public static class Pipeline {
        private final AbstractShader shader = new AbstractShader();
        private final ShaderVertexMerger merger = new ShaderVertexMerger();

        public void add(ShaderVertexObject pass) {
            this.merger.add(pass);
        }

        public void end() {
            if (this.merger.isEmpty()) {
                return;
            }
            this.merger.prepare();
            this.shader.begin();
            this.merger.forEach(group -> this.shader.apply((ShaderVertexGroup)group, () -> group.forEach(this.shader::render)));
            this.shader.end();
            this.merger.reset();
        }
    }
}

