/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.render;

import com.apple.library.uikit.UIColor;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import extensions.com.mojang.blaze3d.vertex.PoseStack.ABI;
import moe.plushie.armourers_workshop.core.client.model.MannequinModel;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderType;
import moe.plushie.armourers_workshop.core.client.render.SkinItemRenderer;
import moe.plushie.armourers_workshop.core.data.MannequinHitResult;
import moe.plushie.armourers_workshop.core.data.SkinBlockPlaceContext;
import moe.plushie.armourers_workshop.core.skin.SkinDescriptor;
import moe.plushie.armourers_workshop.core.skin.SkinTypes;
import moe.plushie.armourers_workshop.utils.RenderSystem;
import moe.plushie.armourers_workshop.utils.math.Vector3f;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class HighlightPlacementRenderer {
    public static void renderBlock(ItemStack itemStack, PlayerEntity player, BlockRayTraceResult traceResult, ActiveRenderInfo renderInfo, MatrixStack poseStack, IRenderTypeBuffer buffers) {
        SkinDescriptor descriptor = SkinDescriptor.of(itemStack);
        if (descriptor.getType() != SkinTypes.BLOCK) {
            return;
        }
        poseStack.func_227860_a_();
        float f = 0.0625f;
        Vector3f origin = new Vector3f((IPosition)renderInfo.func_216785_c());
        SkinBlockPlaceContext context = new SkinBlockPlaceContext(player, Hand.MAIN_HAND, itemStack, traceResult);
        BlockPos location = context.func_195995_a();
        poseStack.func_227861_a_((double)((float)location.func_177958_n() - origin.getX()), (double)((float)location.func_177956_o() - origin.getY()), (double)((float)location.func_177952_p() - origin.getZ()));
        poseStack.func_227861_a_(0.5, 0.5, 0.5);
        poseStack.func_227862_a_(f, f, f);
        for (SkinBlockPlaceContext.Part part : context.getParts()) {
            BlockPos pos = part.getOffset();
            UIColor color = UIColor.RED;
            if (context.canPlace(part)) {
                color = UIColor.WHITE;
            }
            poseStack.func_227860_a_();
            poseStack.func_227861_a_((double)((float)pos.func_177958_n() * 16.0f), (double)((float)pos.func_177956_o() * 16.0f), (double)((float)pos.func_177952_p() * 16.0f));
            RenderSystem.drawBoundingBox(poseStack, part.getShape(), color, buffers);
            poseStack.func_227865_b_();
        }
        poseStack.func_227865_b_();
    }

    public static void renderEntity(PlayerEntity player, BlockRayTraceResult traceResult, ActiveRenderInfo renderInfo, MatrixStack poseStack, IRenderTypeBuffer buffers) {
        Vector3f origin = new Vector3f((IPosition)renderInfo.func_216785_c());
        MannequinHitResult target = MannequinHitResult.test(player, origin, traceResult.func_216347_e(), traceResult.func_216350_a());
        poseStack.func_227860_a_();
        Vector3f location = new Vector3f((IPosition)target.func_216347_e());
        poseStack.func_227861_a_((double)(location.getX() - origin.getX()), (double)(location.getY() - origin.getY()), (double)(location.getZ() - origin.getZ()));
        ABI.mulPose(poseStack, Vector3f.YP.rotationDegrees(-target.getRotation()));
        MannequinModel<?> model = SkinItemRenderer.getInstance().getMannequinModel();
        if (model != null) {
            float f = target.getScale() * 0.9375f;
            IVertexBuilder builder = buffers.getBuffer(SkinRenderType.HIGHLIGHTED_ENTITY_LINES);
            poseStack.func_227860_a_();
            poseStack.func_227862_a_(f, f, f);
            poseStack.func_227862_a_(-1.0f, -1.0f, 1.0f);
            poseStack.func_227861_a_(0.0, (double)-1.501f, 0.0);
            model.func_225598_a_(poseStack, builder, 0xF000F0, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
            poseStack.func_227865_b_();
        }
        poseStack.func_227865_b_();
    }
}

