/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.render;

import com.apple.library.uikit.UIColor;
import com.mojang.blaze3d.matrix.MatrixStack;
import extensions.com.mojang.blaze3d.vertex.PoseStack.ABI;
import moe.plushie.armourers_workshop.compatibility.client.AbstractBlockEntityRendererProviderImpl;
import moe.plushie.armourers_workshop.compatibility.client.renderer.AbstractBlockEntityRenderer;
import moe.plushie.armourers_workshop.core.blockentity.HologramProjectorBlockEntity;
import moe.plushie.armourers_workshop.core.blockentity.RotableContainerBlockEntity;
import moe.plushie.armourers_workshop.core.blockentity.UpdatableContainerBlockEntity;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderTesselator;
import moe.plushie.armourers_workshop.core.data.ticket.Tickets;
import moe.plushie.armourers_workshop.core.skin.SkinDescriptor;
import moe.plushie.armourers_workshop.init.ModDebugger;
import moe.plushie.armourers_workshop.utils.RenderSystem;
import moe.plushie.armourers_workshop.utils.TickUtils;
import moe.plushie.armourers_workshop.utils.math.OpenQuaternionf;
import moe.plushie.armourers_workshop.utils.math.Rectangle3f;
import moe.plushie.armourers_workshop.utils.math.Vector3f;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class HologramProjectorBlockEntityRenderer<T extends HologramProjectorBlockEntity>
extends AbstractBlockEntityRenderer<T> {
    public HologramProjectorBlockEntityRenderer(AbstractBlockEntityRendererProviderImpl.Context context) {
        super(context);
    }

    public void render(T entity, float partialTicks, MatrixStack poseStack, IRenderTypeBuffer buffers, int light, int overlay) {
        if (!((HologramProjectorBlockEntity)entity).isPowered()) {
            return;
        }
        BlockState blockState = entity.func_195044_w();
        ItemStack itemStack = ((UpdatableContainerBlockEntity)entity).func_70301_a(0);
        SkinDescriptor descriptor = SkinDescriptor.of(itemStack);
        SkinRenderTesselator context = SkinRenderTesselator.create(descriptor, Tickets.RENDERER);
        if (context == null) {
            return;
        }
        float f = 0.0625f;
        float partialTicks1 = TickUtils.ticks();
        int overLight = light;
        if (((HologramProjectorBlockEntity)entity).isOverrideLight()) {
            overLight = 0xF000F0;
        }
        poseStack.func_227860_a_();
        poseStack.func_227861_a_(0.5, 0.5, 0.5);
        ABI.mulPose(poseStack, ((HologramProjectorBlockEntity)entity).getRenderRotations(blockState));
        poseStack.func_227861_a_(0.0, 0.5, 0.0);
        poseStack.func_227862_a_(f, f, f);
        poseStack.func_227862_a_(-1.0f, -1.0f, 1.0f);
        context.setLightmap(overLight);
        context.setPartialTicks(partialTicks1);
        context.setReference(0, itemStack);
        Rectangle3f rect = context.getBakedRenderBounds();
        this.apply(entity, rect, partialTicks1, poseStack, buffers);
        context.draw(poseStack, buffers);
        poseStack.func_227865_b_();
        if (ModDebugger.hologramProjectorBlock) {
            BlockPos pos = entity.func_174877_v();
            poseStack.func_227860_a_();
            poseStack.func_227861_a_((double)(-pos.func_177958_n()), (double)(-pos.func_177956_o()), (double)(-pos.func_177952_p()));
            RenderSystem.drawBoundingBox(poseStack, ((RotableContainerBlockEntity)entity).getCustomRenderBoundingBox(blockState), UIColor.ORANGE, buffers);
            poseStack.func_227865_b_();
        }
    }

    private void apply(T entity, Rectangle3f rect, float partialTicks, MatrixStack poseStack, IRenderTypeBuffer buffers) {
        Vector3f angle = ((HologramProjectorBlockEntity)entity).getModelAngle();
        Vector3f offset = ((HologramProjectorBlockEntity)entity).getModelOffset();
        Vector3f rotationOffset = ((HologramProjectorBlockEntity)entity).getRotationOffset();
        Vector3f rotationSpeed = ((HologramProjectorBlockEntity)entity).getRotationSpeed();
        float rotX = angle.getX();
        float speedX = rotationSpeed.getX();
        if (speedX != 0.0f) {
            rotX += partialTicks % speedX / speedX * 360.0f;
        }
        float rotY = angle.getY();
        float speedY = rotationSpeed.getY();
        if (speedY != 0.0f) {
            rotY += partialTicks % speedY / speedY * 360.0f;
        }
        float rotZ = angle.getZ();
        float speedZ = rotationSpeed.getZ();
        if (speedZ != 0.0f) {
            rotZ += partialTicks % speedZ / speedZ * 360.0f;
        }
        float scale = ((HologramProjectorBlockEntity)entity).getModelScale();
        poseStack.func_227862_a_(scale, scale, scale);
        if (((HologramProjectorBlockEntity)entity).isOverrideOrigin()) {
            poseStack.func_227861_a_(0.0, (double)(-rect.getMaxY()), 0.0);
        }
        poseStack.func_227861_a_((double)(-offset.getX()), (double)(-offset.getY()), (double)offset.getZ());
        if (((HologramProjectorBlockEntity)entity).shouldShowRotationPoint()) {
            RenderSystem.drawBoundingBox(poseStack, -1.0f, -1.0f, -1.0f, 1.0f, 1.0f, 1.0f, UIColor.MAGENTA, buffers);
        }
        if (ModDebugger.hologramProjectorBlock) {
            RenderSystem.drawPoint(poseStack, null, 128.0f, buffers);
        }
        ABI.mulPose(poseStack, new OpenQuaternionf(rotX, -rotY, rotZ, true));
        poseStack.func_227861_a_((double)rotationOffset.getX(), (double)(-rotationOffset.getY()), (double)rotationOffset.getZ());
        if (ModDebugger.hologramProjectorBlock) {
            RenderSystem.drawPoint(poseStack, null, 128.0f, buffers);
        }
    }

    @Override
    public int getViewDistance() {
        return 272;
    }
}

