/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.skinrender;

import com.apple.library.uikit.UIColor;
import moe.plushie.armourers_workshop.api.action.ICanHeld;
import moe.plushie.armourers_workshop.api.client.model.IModel;
import moe.plushie.armourers_workshop.api.skin.ISkinArmorType;
import moe.plushie.armourers_workshop.api.skin.ISkinPartType;
import moe.plushie.armourers_workshop.api.skin.ISkinType;
import moe.plushie.armourers_workshop.core.client.bake.BakedSkin;
import moe.plushie.armourers_workshop.core.client.bake.BakedSkinPart;
import moe.plushie.armourers_workshop.core.client.other.SkinModelTransformer;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderBufferSource;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderContext;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderData;
import moe.plushie.armourers_workshop.core.client.other.SkinVisibilityTransformer;
import moe.plushie.armourers_workshop.core.data.color.ColorScheme;
import moe.plushie.armourers_workshop.core.entity.EntityProfile;
import moe.plushie.armourers_workshop.core.skin.Skin;
import moe.plushie.armourers_workshop.core.skin.part.SkinPartTypes;
import moe.plushie.armourers_workshop.core.skin.transform.SkinPartTransform;
import moe.plushie.armourers_workshop.init.ModDebugger;
import moe.plushie.armourers_workshop.utils.ColorUtils;
import moe.plushie.armourers_workshop.utils.ObjectUtils;
import moe.plushie.armourers_workshop.utils.math.Vector3f;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SkinRenderer<T extends Entity, M extends IModel> {
    protected final EntityProfile profile;
    protected final SkinModelTransformer<T, M> transformer = new SkinModelTransformer();
    protected final SkinVisibilityTransformer<M> visibilityTransformer = new SkinVisibilityTransformer();

    public SkinRenderer(EntityProfile profile) {
        this.profile = profile;
    }

    protected void init(EntityRenderer<T> entityRenderer) {
    }

    protected void init(SkinModelTransformer<T, M> transformer) {
    }

    protected void init(SkinVisibilityTransformer<M> watcher) {
    }

    public void initWithRenderer(EntityRenderer<?> entityRenderer) {
        EntityRenderer renderer = (EntityRenderer)ObjectUtils.unsafeCast(entityRenderer);
        this.init(this.transformer);
        this.init(this.visibilityTransformer);
        this.init(renderer);
    }

    public boolean prepare(T entity, M model, BakedSkinPart bakedPart, BakedSkin bakedSkin, SkinRenderContext context) {
        ISkinPartType partType = bakedPart.getType();
        if (!context.shouldRenderPart(partType)) {
            return false;
        }
        if (partType == SkinPartTypes.BLOCK || partType == SkinPartTypes.BLOCK_MULTI || partType == SkinPartTypes.ADVANCED) {
            return true;
        }
        if (partType instanceof ICanHeld && this.transformer.getItem(context.getTransformType()) != null) {
            return true;
        }
        return this.transformer.getArmour(bakedPart.getType()) != null;
    }

    public void apply(T entity, M model, BakedSkinPart bakedPart, BakedSkin bakedSkin, SkinRenderContext context) {
        SkinPartTransform transform = bakedPart.getTransform();
        transform.setup(context.getPartialTicks(), (Entity)entity);
        transform.pre(context.pose());
        M model1 = this.getOverrideModel(model);
        SkinModelTransformer.Entry<T, M> partTransform = this.getPartTransform(entity, model1, bakedPart, bakedSkin, context);
        if (partTransform != null && model1 != null) {
            partTransform.apply(context.pose(), entity, model1, bakedPart, bakedSkin, context);
        }
        transform.post(context.pose());
    }

    public void willRender(T entity, M model, SkinRenderData renderData, SkinRenderContext context) {
    }

    public void willRenderModel(T entity, M model, SkinRenderData renderData, SkinRenderContext context) {
        this.visibilityTransformer.willRender(model, renderData.getOverriddenManager());
    }

    public void didRender(T entity, M model, SkinRenderData renderData, SkinRenderContext context) {
        this.visibilityTransformer.didRender(model, renderData.getOverriddenManager());
    }

    public int render(T entity, M model, BakedSkin bakedSkin, ColorScheme scheme, SkinRenderContext context) {
        ISkinType type;
        if (this.profile != null && (type = bakedSkin.getType()) instanceof ISkinArmorType && !this.profile.canSupport(type)) {
            return 0;
        }
        int counter = 0;
        Skin skin = bakedSkin.getSkin();
        ColorScheme scheme1 = bakedSkin.resolve((Entity)entity, scheme);
        SkinRenderBufferSource.ObjectBuilder builder = context.getBuffer(skin);
        for (BakedSkinPart bakedPart : bakedSkin.getSkinParts()) {
            if (!this.prepare(entity, model, bakedPart, bakedSkin, context)) continue;
            boolean shouldRenderPart = bakedSkin.shouldRenderPart(entity, model, bakedPart, context);
            context.pushPose();
            this.apply(entity, model, bakedPart, bakedSkin, context);
            builder.addPart(bakedPart, bakedSkin, scheme1, shouldRenderPart, context);
            counter += this.renderChildPart(bakedPart, bakedSkin, scheme1, shouldRenderPart, builder, context);
            if (shouldRenderPart && ModDebugger.skinPartBounds) {
                builder.addShape(bakedPart.getRenderShape(), ColorUtils.getPaletteColor(bakedPart.getId()), context);
            }
            if (shouldRenderPart && ModDebugger.skinPartOrigin) {
                builder.addShape(Vector3f.ZERO, context);
            }
            if (shouldRenderPart) {
                ++counter;
            }
            context.popPose();
        }
        if (ModDebugger.skinBounds) {
            builder.addShape(bakedSkin.getRenderShape(entity, model, context.getReference(), context.getTransformType(), this), UIColor.RED, context);
        }
        if (ModDebugger.skinBounds) {
            builder.addShape(Vector3f.ZERO, context);
        }
        if (ModDebugger.armature && skin.getType() instanceof ISkinArmorType) {
            builder.addShape(context.getTransforms(), context);
        }
        return counter;
    }

    public int renderChildPart(BakedSkinPart parentPart, BakedSkin bakedSkin, ColorScheme scheme, boolean shouldRenderPart, SkinRenderBufferSource.ObjectBuilder builder, SkinRenderContext context) {
        int counter = 0;
        for (BakedSkinPart bakedPart : parentPart.getChildren()) {
            SkinPartTransform transform = bakedPart.getTransform();
            context.pushPose();
            transform.apply(context.pose());
            builder.addPart(bakedPart, bakedSkin, scheme, shouldRenderPart, context);
            counter += this.renderChildPart(bakedPart, bakedSkin, scheme, shouldRenderPart, builder, context);
            if (shouldRenderPart && ModDebugger.skinPartBounds) {
                builder.addShape(bakedPart.getRenderShape(), ColorUtils.getPaletteColor(bakedPart.getId()), context);
            }
            if (shouldRenderPart && ModDebugger.skinPartOrigin) {
                builder.addShape(Vector3f.ZERO, context);
            }
            if (shouldRenderPart) {
                ++counter;
            }
            context.popPose();
        }
        return counter;
    }

    public SkinModelTransformer.Entry<T, M> getPartTransform(T entity, M model, BakedSkinPart bakedPart, BakedSkin bakedSkin, SkinRenderContext context) {
        SkinModelTransformer.Entry<T, M> transform;
        ISkinPartType partType = bakedPart.getType();
        if (partType instanceof ICanHeld && (transform = this.transformer.getItem(context.getTransformType())) != null) {
            return transform;
        }
        return this.transformer.getArmour(partType);
    }

    public M getOverrideModel(M model) {
        return model;
    }

    public EntityProfile getProfile() {
        return this.profile;
    }

    public static interface Factory<T> {
        public T create(EntityType<?> var1, EntityRenderer<?> var2, Model var3, EntityProfile var4);
    }
}

