/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.skinrender.plugin;

import java.util.ArrayList;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import moe.plushie.armourers_workshop.api.client.model.IModel;
import moe.plushie.armourers_workshop.core.client.layer.ForwardingLayer;
import moe.plushie.armourers_workshop.core.client.skinrender.LivingSkinRenderer;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ForwardingLayerPlugin<T extends LivingEntity, M extends IModel>
implements LivingSkinRenderer.Plugin<T, M> {
    private final ArrayList<Entry> entries = new ArrayList();

    public <R extends LayerRenderer<?, ?>> void register(Class<R> layerType, BiPredicate<T, M> tester) {
        Entry entry = new Entry();
        entry.layerType = layerType;
        entry.layerFactory = ForwardingLayer.when(tester);
        this.entries.add(entry);
    }

    @Override
    public LayerRenderer<T, EntityModel<T>> getOverrideLayer(LivingRenderer<T, EntityModel<T>> entityRenderer, LayerRenderer<T, EntityModel<T>> renderLayer) {
        for (Entry entry : this.entries) {
            LayerRenderer newValue;
            if (!entry.layerType.isInstance(renderLayer) || (newValue = entry.layerFactory.apply((IEntityRenderer<LivingRenderer<T, EntityModel<T>>, EntityModel<LivingRenderer<T, EntityModel<T>>>>)entityRenderer, (LayerRenderer<LivingRenderer<T, EntityModel<T>>, EntityModel<LivingRenderer<T, EntityModel<T>>>>)renderLayer)) == null) continue;
            return newValue;
        }
        return null;
    }

    private class Entry {
        Class<?> layerType;
        BiFunction<IEntityRenderer<T, EntityModel<T>>, LayerRenderer<T, EntityModel<T>>, LayerRenderer<T, EntityModel<T>>> layerFactory;

        private Entry() {
        }
    }
}

