/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.data;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Objects;
import moe.plushie.armourers_workshop.api.skin.ISkinType;
import moe.plushie.armourers_workshop.core.skin.Skin;
import moe.plushie.armourers_workshop.core.skin.SkinTypes;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperties;
import moe.plushie.armourers_workshop.init.ModLog;
import moe.plushie.armourers_workshop.utils.SkinFileUtils;
import moe.plushie.armourers_workshop.utils.SkinIOUtils;
import moe.plushie.armourers_workshop.utils.SkinUUID;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;

public class LocalDataService {
    private static LocalDataService RUNNING;
    private final File rootPath;
    private final HashMap<String, Node> nodes = new HashMap();
    private String lastGenUUID = "";

    public LocalDataService(File rootPath) {
        this.rootPath = rootPath;
        this.loadLegacyNodes();
        this.loadNodes();
    }

    public static LocalDataService getInstance() {
        return Objects.requireNonNull(RUNNING);
    }

    public static void start(File path) {
        if (RUNNING == null) {
            RUNNING = new LocalDataService(path);
            ModLog.info("start local service of '{}'", path.getParentFile().getName());
        }
    }

    public static void stop() {
        if (RUNNING != null) {
            RUNNING = null;
            ModLog.info("stop local service", new Object[0]);
        }
    }

    public static boolean isRunning() {
        return RUNNING != null;
    }

    protected void loadLegacyNodes() {
        File indexDB = new File(this.rootPath, "index.data");
        if (!indexDB.exists()) {
            return;
        }
        File[] files = SkinFileUtils.listFiles(this.rootPath);
        if (files == null) {
            return;
        }
        ModLog.info("data fixer for db {} started", indexDB);
        for (File file : files) {
            String name = file.getName();
            if (name.equals("objects") || name.equals("index.dat")) continue;
            try {
                Node node = this.generateNode(name, file);
                if (node == null) continue;
                ModLog.info("data fixer -> upgrade {} node to new db", name);
                SkinFileUtils.deleteQuietly(file);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        SkinFileUtils.deleteQuietly(indexDB);
        ModLog.info("data fixer for db {} completed", indexDB);
    }

    private void loadNodes() {
        File[] files = SkinFileUtils.listFiles(this.getRootFile());
        if (files != null) {
            for (File file : files) {
                this.loadNode(file);
            }
        }
    }

    private Node loadNode(File parent) {
        try {
            File indexFile = new File(parent, "0");
            CompoundNBT nbt = SkinFileUtils.readNBT(indexFile);
            if (nbt != null) {
                Node node = new Node(nbt);
                this.nodes.put(node.id, node);
                return node;
            }
            Node node = this.generateNode(parent.getName(), new File(parent, "1"));
            if (node != null) {
                this.nodes.put(node.id, node);
                return node;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private Node generateNode(String identifier, File skinFile) throws Exception {
        if (!skinFile.isFile()) {
            return null;
        }
        byte[] bytes = SkinFileUtils.readFileToByteArray(skinFile);
        ByteArrayInputStream stream = new ByteArrayInputStream(bytes);
        Skin skin = SkinIOUtils.loadSkinFromStream2(stream);
        if (skin == null) {
            return null;
        }
        Node node = new Node(identifier, skin.getType(), bytes, skin.getProperties());
        node.save(bytes);
        return node;
    }

    private File getRootFile() {
        return new File(this.rootPath, "objects");
    }

    public InputStream getFile(String identifier) throws IOException {
        File parent;
        Node node = this.nodes.get(identifier);
        if (node == null && (parent = new File(this.getRootFile(), identifier)).isDirectory()) {
            node = this.loadNode(parent);
        }
        if (node != null && node.isValid()) {
            return new FileInputStream(node.getFile());
        }
        throw new FileNotFoundException("the node '" + identifier + "' not found!");
    }

    public String addFile(Skin skin) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream(5120);
        SkinIOUtils.saveSkinToStream(stream, skin);
        byte[] bytes = stream.toByteArray();
        Node tmp = new Node(this.getFreeUUID(), skin.getType(), bytes, skin.getProperties());
        for (Node node : this.nodes.values()) {
            if (!node.isValid() || !node.equals(tmp) || !node.equalContents(bytes)) continue;
            return node.id;
        }
        ModLog.debug("Save skin into db {}", tmp.id);
        try {
            tmp.save(bytes);
            this.nodes.put(tmp.id, tmp);
            return tmp.id;
        }
        catch (IOException exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public void removeFile(String identifier) {
        Node node = this.nodes.get(identifier);
        if (node != null) {
            node.remove();
            this.nodes.remove(node.id);
        }
    }

    private String getFreeUUID() {
        String uuid = this.lastGenUUID;
        while (uuid.isEmpty() || this.nodes.containsKey(uuid)) {
            uuid = SkinUUID.randomUUID().toString();
        }
        this.lastGenUUID = uuid;
        return uuid;
    }

    public class Node {
        final String id;
        final ISkinType type;
        final int version;
        final int fileSize;
        final int fileHash;
        final SkinProperties properties;
        final int propertiesHash;

        Node(String id, ISkinType type, byte[] bytes, SkinProperties properties) {
            this.id = id;
            this.type = type;
            this.version = 2;
            this.fileSize = bytes.length;
            this.fileHash = Arrays.hashCode(bytes);
            this.properties = properties;
            this.propertiesHash = properties.hashCode();
        }

        Node(CompoundNBT nbt) {
            this.id = nbt.func_74779_i("UUID");
            this.type = SkinTypes.byName(nbt.func_74779_i("Type"));
            this.version = nbt.func_74762_e("Version");
            this.fileSize = nbt.func_74762_e("FileSize");
            this.fileHash = nbt.func_74762_e("FileHash");
            this.properties = SkinProperties.create();
            this.properties.readFromNBT(nbt.func_74775_l("Properties"));
            this.propertiesHash = nbt.func_74762_e("PropertiesHash");
        }

        public CompoundNBT serializeNBT() {
            CompoundNBT nbt = new CompoundNBT();
            nbt.func_74778_a("UUID", this.id);
            nbt.func_74778_a("Type", this.type.getRegistryName().toString());
            nbt.func_74768_a("Version", this.version);
            nbt.func_74768_a("FileSize", this.fileSize);
            nbt.func_74768_a("FileHash", this.fileHash);
            CompoundNBT props = new CompoundNBT();
            this.properties.writeToNBT(props);
            nbt.func_218657_a("Properties", (INBT)props);
            nbt.func_74768_a("PropertiesHash", this.propertiesHash);
            return nbt;
        }

        public void save(byte[] bytes) throws IOException {
            SkinFileUtils.forceMkdirParent(this.getFile());
            FileOutputStream fs = new FileOutputStream(this.getFile());
            fs.write(bytes);
            SkinFileUtils.writeNBT(this.serializeNBT(), this.getIndexFile());
        }

        public void remove() {
            SkinFileUtils.deleteQuietly(this.getFile().getParentFile());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Node)) {
                return false;
            }
            Node node = (Node)o;
            return this.fileSize == node.fileSize && this.fileHash == node.fileHash && this.propertiesHash == node.propertiesHash && this.type.equals(node.type) && this.properties.equals(node.properties);
        }

        /*
         * Enabled aggressive exception aggregation
         */
        public boolean equalContents(byte[] bytes) {
            int index;
            try (FileInputStream stream = new FileInputStream(this.getFile());){
                int readSize;
                byte[] buff = new byte[1024];
                for (index = 0; index < bytes.length; index += readSize) {
                    readSize = stream.read(buff);
                    if (readSize <= 0) {
                        break;
                    }
                    if (index + readSize > bytes.length) {
                        boolean bl = false;
                        return bl;
                    }
                    for (int i = 0; i < readSize; ++i) {
                        if (bytes[index + i] == buff[i]) continue;
                        boolean bl = false;
                        return bl;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return index == bytes.length;
        }

        public int hashCode() {
            return Objects.hash(this.type, this.fileSize, this.fileHash, this.propertiesHash);
        }

        public File getFile() {
            return new File(LocalDataService.this.rootPath, "objects/" + this.id + "/1");
        }

        public File getIndexFile() {
            return new File(LocalDataService.this.rootPath, "objects/" + this.id + "/0");
        }

        public boolean isValid() {
            return this.getFile().exists();
        }
    }
}

