/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.data.slot;

import moe.plushie.armourers_workshop.api.common.IItemTag;
import moe.plushie.armourers_workshop.api.registry.IRegistryKey;
import moe.plushie.armourers_workshop.init.ModConfig;
import moe.plushie.armourers_workshop.init.ModItemTags;
import moe.plushie.armourers_workshop.init.platform.RegistryManager;
import moe.plushie.armourers_workshop.utils.ItemMatcher;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public enum ItemOverrideType {
    SWORD("sword", "sword|tachi|katana|dagger", ModItemTags.SWORDS),
    SHIELD("shield", null, ModItemTags.SHIELDS),
    BOW("bow", null, ModItemTags.BOWS),
    TRIDENT("trident", "trident|lance", ModItemTags.TRIDENTS),
    PICKAXE("pickaxe", null, ModItemTags.PICKAXES),
    AXE("axe", "(?<!pick)axe", ModItemTags.AXES),
    SHOVEL("shovel", null, ModItemTags.SHOVELS),
    HOE("hoe", null, ModItemTags.HOES),
    ITEM("item", null, null);

    private final IRegistryKey<IItemTag> tag;
    private final String name;
    private final ItemMatcher matcher;

    private ItemOverrideType(String name, String regex, IRegistryKey<IItemTag> tag) {
        this.name = name;
        this.tag = tag;
        this.matcher = new ItemMatcher(name, regex);
    }

    @Nullable
    public static ItemOverrideType of(String name) {
        for (ItemOverrideType overrideType : ItemOverrideType.values()) {
            if (!overrideType.getName().equals(name)) continue;
            return overrideType;
        }
        return null;
    }

    public boolean isOverrideItem(ItemStack itemStack) {
        if (this == ITEM) {
            return true;
        }
        ResourceLocation registryName = RegistryManager.getKey(itemStack.func_77973_b());
        if (ModConfig.Common.overrides.contains(this.name + ":" + registryName)) {
            return true;
        }
        if (this.tag != null && ((IItemTag)this.tag.get()).contains(itemStack)) {
            return true;
        }
        return this.matcher.test(registryName);
    }

    public String getName() {
        return this.name;
    }
}

