/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.entity;

import extensions.net.minecraft.world.entity.Entity.PropertyProvider;
import java.util.Collections;
import moe.plushie.armourers_workshop.compatibility.core.AbstractLivingEntity;
import moe.plushie.armourers_workshop.core.blockentity.SkinnableBlockEntity;
import moe.plushie.armourers_workshop.init.ModConfig;
import moe.plushie.armourers_workshop.utils.DataSerializers;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.HandSide;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class SeatEntity
extends AbstractLivingEntity {
    private int holdingTick;
    private BlockPos blockPos;

    public SeatEntity(EntityType<? extends SeatEntity> entityType, World level) {
        super(entityType, level);
        this.func_181013_g(0.0f);
        this.holdingTick = ModConfig.Client.prefersSeatHoldingTick;
    }

    public void func_70037_a(CompoundNBT nbt) {
        super.func_70037_a(nbt);
        this.blockPos = DataSerializers.getBlockPos(nbt, "Refer", BlockPos.field_177992_a);
    }

    public void func_213281_b(CompoundNBT nbt) {
        super.func_213281_b(nbt);
        DataSerializers.putBlockPos(nbt, "Refer", this.blockPos, BlockPos.field_177992_a);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!PropertyProvider.getLevel((Entity)this).func_201670_d()) {
            this.autoKill();
        }
    }

    public void func_213352_e(Vector3d p_213352_1_) {
        if (this.func_70089_S() && !this.func_184188_bt().isEmpty()) {
            Entity passenger = (Entity)this.func_184188_bt().get(0);
            this.func_181013_g(PropertyProvider.getYRot(passenger));
        }
    }

    public void func_174812_G() {
        this.remove(AbstractLivingEntity.RemovalReason.KILLED);
    }

    public void autoKill() {
        if (this.holdingTick > 0) {
            --this.holdingTick;
        }
        if (this.holdingTick <= 0 && this.func_70089_S() && !this.isWorking()) {
            this.func_174812_G();
        }
    }

    protected void func_184225_p(Entity entity) {
        super.func_184225_p(entity);
        this.holdingTick = ModConfig.Client.prefersSeatHoldingTick;
    }

    public boolean isWorking() {
        if (this.func_184188_bt().isEmpty()) {
            return false;
        }
        return PropertyProvider.getLevel((Entity)this) != null && this.blockPos != null && PropertyProvider.getLevel((Entity)this).func_175625_s(this.blockPos) instanceof SkinnableBlockEntity;
    }

    public void func_181013_g(float f) {
        super.func_181013_g(f);
        PropertyProvider.setYRot((Entity)this, f);
        this.field_70126_B = f;
        this.field_70759_as = f;
    }

    public boolean func_189652_ae() {
        return true;
    }

    public boolean func_70104_M() {
        return false;
    }

    public boolean func_70075_an() {
        return false;
    }

    public boolean func_241845_aY() {
        return false;
    }

    public double func_70042_X() {
        return -0.15f;
    }

    public HandSide func_184591_cq() {
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_145770_h(double p_145770_1_, double p_145770_3_, double p_145770_5_) {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_70112_a(double p_70112_1_) {
        return false;
    }

    public Iterable<ItemStack> func_184193_aE() {
        return Collections.emptyList();
    }

    public ItemStack func_184582_a(EquipmentSlotType p_184582_1_) {
        return ItemStack.field_190927_a;
    }

    public void func_184201_a(EquipmentSlotType slotType, ItemStack itemStack) {
    }

    public BlockPos getBlockPos() {
        return this.blockPos;
    }

    public void setBlockPos(BlockPos blockPos) {
        this.blockPos = blockPos;
    }
}

