/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.item;

import extensions.net.minecraft.network.chat.Component.TranslatableProvider;
import extensions.net.minecraft.world.entity.player.Player.SystemMessageProvider;
import java.util.function.BiConsumer;
import moe.plushie.armourers_workshop.api.common.IItemHandler;
import moe.plushie.armourers_workshop.api.common.IItemModelProperty;
import moe.plushie.armourers_workshop.api.common.IItemPropertiesProvider;
import moe.plushie.armourers_workshop.core.blockentity.SkinnableBlockEntity;
import moe.plushie.armourers_workshop.core.item.FlavouredItem;
import moe.plushie.armourers_workshop.init.ModConstants;
import moe.plushie.armourers_workshop.utils.DataSerializers;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import org.jetbrains.annotations.Nullable;

public class LinkingToolItem
extends FlavouredItem
implements IItemHandler,
IItemPropertiesProvider {
    public LinkingToolItem(Item.Properties properties) {
        super(properties);
    }

    public static void setLinkedBlockPos(ItemStack itemStack, BlockPos pos) {
        DataSerializers.putBlockPos(itemStack.func_196082_o(), "LinkedPos", pos, null);
    }

    @Nullable
    public static BlockPos getLinkedBlockPos(ItemStack itemStack) {
        CompoundNBT tag = itemStack.func_77978_p();
        if (tag != null) {
            return DataSerializers.getBlockPos(tag, "LinkedPos", null);
        }
        return null;
    }

    @Override
    public void createModelProperties(BiConsumer<ResourceLocation, IItemModelProperty> builder) {
        builder.accept(ModConstants.key("empty"), (itemStack, level, entity, id) -> {
            CompoundNBT tag = itemStack.func_77978_p();
            if (tag != null && tag.func_74764_b("LinkedPos")) {
                return 0.0f;
            }
            return 1.0f;
        });
    }

    @Override
    public ActionResultType useOnFirst(ItemStack itemStack, ItemUseContext context) {
        World level = context.func_195991_k();
        PlayerEntity player = context.func_195999_j();
        if (level.func_201670_d() || player == null) {
            return ActionResultType.SUCCESS;
        }
        BlockPos linkedBlockPos = LinkingToolItem.getLinkedBlockPos(itemStack);
        SkinnableBlockEntity blockEntity = this.getTitleEntity(level, context.func_195995_a());
        if (blockEntity != null && player.func_225608_bj_()) {
            blockEntity.setLinkedBlockPos(null);
            SystemMessageProvider.sendSystemMessage(player, (ITextComponent)TranslatableProvider.translatable(ITextComponent.class, "inventory.armourers_workshop.linking-tool.clear", new Object[0]));
            return ActionResultType.SUCCESS;
        }
        if (linkedBlockPos != null) {
            LinkingToolItem.setLinkedBlockPos(itemStack, null);
            if (blockEntity != null) {
                blockEntity.setLinkedBlockPos(linkedBlockPos);
                SystemMessageProvider.sendSystemMessage(player, (ITextComponent)TranslatableProvider.translatable(ITextComponent.class, "inventory.armourers_workshop.linking-tool.finish", new Object[0]));
                return ActionResultType.SUCCESS;
            }
            SystemMessageProvider.sendSystemMessage(player, (ITextComponent)TranslatableProvider.translatable(ITextComponent.class, "inventory.armourers_workshop.linking-tool.fail", new Object[0]));
            return ActionResultType.SUCCESS;
        }
        if (blockEntity != null) {
            SystemMessageProvider.sendSystemMessage(player, (ITextComponent)TranslatableProvider.translatable(ITextComponent.class, "inventory.armourers_workshop.linking-tool.linkedToSkinnable", new Object[0]));
            return ActionResultType.FAIL;
        }
        LinkingToolItem.setLinkedBlockPos(itemStack, context.func_195995_a());
        SystemMessageProvider.sendSystemMessage(player, (ITextComponent)TranslatableProvider.translatable(ITextComponent.class, "inventory.armourers_workshop.linking-tool.start", new Object[0]));
        return ActionResultType.SUCCESS;
    }

    private SkinnableBlockEntity getTitleEntity(World level, BlockPos blockPos) {
        TileEntity blockEntity = level.func_175625_s(blockPos);
        if (blockEntity instanceof SkinnableBlockEntity) {
            return (SkinnableBlockEntity)blockEntity;
        }
        return null;
    }
}

