/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.network;

import java.util.function.BiConsumer;
import java.util.function.Function;
import moe.plushie.armourers_workshop.api.common.IEntitySerializer;
import moe.plushie.armourers_workshop.api.network.IServerPacketHandler;
import moe.plushie.armourers_workshop.core.blockentity.HologramProjectorBlockEntity;
import moe.plushie.armourers_workshop.core.network.CustomPacket;
import moe.plushie.armourers_workshop.utils.DataAccessor;
import moe.plushie.armourers_workshop.utils.DataSerializers;
import moe.plushie.armourers_workshop.utils.ObjectUtils;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;

public class UpdateHologramProjectorPacket
extends CustomPacket {
    private final BlockPos pos;
    private final Field field;
    private final Object fieldValue;

    public UpdateHologramProjectorPacket(PacketBuffer buffer) {
        this.pos = buffer.func_179259_c();
        this.field = (Field)buffer.func_179257_a(Field.class);
        this.fieldValue = this.field.getDataAccessor().dataSerializer.func_187159_a(buffer);
    }

    public UpdateHologramProjectorPacket(HologramProjectorBlockEntity entity, Field field, Object value) {
        this.pos = entity.func_174877_v();
        this.field = field;
        this.fieldValue = value;
    }

    @Override
    public void encode(PacketBuffer buffer) {
        buffer.func_179255_a(this.pos);
        buffer.func_179249_a((Enum)this.field);
        this.field.getDataAccessor().dataSerializer.func_187160_a(buffer, this.fieldValue);
    }

    @Override
    public void accept(IServerPacketHandler packetHandler, ServerPlayerEntity player) {
        TileEntity entity = player.func_71121_q().func_175625_s(this.pos);
        if (entity instanceof HologramProjectorBlockEntity) {
            this.field.set((HologramProjectorBlockEntity)entity, this.fieldValue);
        }
    }

    public static enum Field {
        POWER_MODE(DataSerializers.INT, HologramProjectorBlockEntity::getPowerMode, HologramProjectorBlockEntity::setPowerMode),
        IS_GLOWING(DataSerializers.BOOLEAN, HologramProjectorBlockEntity::isGlowing, HologramProjectorBlockEntity::setGlowing),
        SHOWS_ROTATION_POINT(DataSerializers.BOOLEAN, HologramProjectorBlockEntity::shouldShowRotationPoint, HologramProjectorBlockEntity::setShowRotationPoint),
        OFFSET(DataSerializers.VECTOR_3F, HologramProjectorBlockEntity::getModelOffset, HologramProjectorBlockEntity::setModelOffset),
        ANGLE(DataSerializers.VECTOR_3F, HologramProjectorBlockEntity::getModelAngle, HologramProjectorBlockEntity::setModelAngle),
        ROTATION_OFFSET(DataSerializers.VECTOR_3F, HologramProjectorBlockEntity::getRotationOffset, HologramProjectorBlockEntity::setRotationOffset),
        ROTATION_SPEED(DataSerializers.VECTOR_3F, HologramProjectorBlockEntity::getRotationSpeed, HologramProjectorBlockEntity::setRotationSpeed);

        private final DataAccessor<HologramProjectorBlockEntity, ?> dataAccessor;

        private <T> Field(IEntitySerializer<T> dataSerializer, Function<HologramProjectorBlockEntity, T> supplier, BiConsumer<HologramProjectorBlockEntity, T> applier) {
            this.dataAccessor = DataAccessor.of(dataSerializer, supplier, applier);
        }

        public <T> T get(HologramProjectorBlockEntity entity) {
            DataAccessor<HologramProjectorBlockEntity, T> dataAccessor = this.getDataAccessor();
            return dataAccessor.get(entity);
        }

        public <T> void set(HologramProjectorBlockEntity entity, T value) {
            DataAccessor<HologramProjectorBlockEntity, T> dataAccessor = this.getDataAccessor();
            dataAccessor.set(entity, value);
        }

        public <T> DataAccessor<HologramProjectorBlockEntity, T> getDataAccessor() {
            return (DataAccessor)ObjectUtils.unsafeCast(this.dataAccessor);
        }
    }
}

