/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.network;

import extensions.net.minecraft.world.entity.Entity.PropertyProvider;
import extensions.net.minecraft.world.item.ItemStack.ABI;
import java.util.function.BiConsumer;
import java.util.function.Function;
import moe.plushie.armourers_workshop.api.common.IEntitySerializer;
import moe.plushie.armourers_workshop.api.network.IClientPacketHandler;
import moe.plushie.armourers_workshop.api.network.IServerPacketHandler;
import moe.plushie.armourers_workshop.core.capability.SkinWardrobe;
import moe.plushie.armourers_workshop.core.data.slot.SkinSlotType;
import moe.plushie.armourers_workshop.core.entity.MannequinEntity;
import moe.plushie.armourers_workshop.core.menu.SkinWardrobeMenu;
import moe.plushie.armourers_workshop.core.network.CustomPacket;
import moe.plushie.armourers_workshop.init.ModItems;
import moe.plushie.armourers_workshop.init.ModLog;
import moe.plushie.armourers_workshop.init.platform.NetworkManager;
import moe.plushie.armourers_workshop.utils.DataAccessor;
import moe.plushie.armourers_workshop.utils.DataSerializers;
import moe.plushie.armourers_workshop.utils.ObjectUtils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.DataParameter;
import org.jetbrains.annotations.Nullable;

public class UpdateWardrobePacket
extends CustomPacket {
    private final Mode mode;
    private final int entityId;
    private final Field field;
    private final Object fieldValue;
    private final CompoundNBT compoundNBT;

    public UpdateWardrobePacket(PacketBuffer buffer) {
        this.mode = (Mode)buffer.func_179257_a(Mode.class);
        this.entityId = buffer.readInt();
        if (this.mode != Mode.SYNC_OPTION) {
            this.fieldValue = null;
            this.field = null;
            this.compoundNBT = buffer.func_150793_b();
        } else {
            this.field = (Field)buffer.func_179257_a(Field.class);
            this.fieldValue = this.field.getDataSerializer().func_187159_a(buffer);
            this.compoundNBT = null;
        }
    }

    public UpdateWardrobePacket(SkinWardrobe wardrobe, Mode mode, CompoundNBT compoundNBT, Field field, Object fieldValue) {
        this.mode = mode;
        this.entityId = wardrobe.getId();
        this.field = field;
        this.fieldValue = fieldValue;
        this.compoundNBT = compoundNBT;
    }

    public static UpdateWardrobePacket sync(SkinWardrobe wardrobe) {
        return new UpdateWardrobePacket(wardrobe, Mode.SYNC, wardrobe.serializeNBT(), null, null);
    }

    public static UpdateWardrobePacket pick(SkinWardrobe wardrobe, int slot, ItemStack itemStack) {
        CompoundNBT compoundNBT = new CompoundNBT();
        compoundNBT.func_74768_a("Slot", slot);
        compoundNBT.func_218657_a("Item", (INBT)itemStack.func_77955_b(new CompoundNBT()));
        return new UpdateWardrobePacket(wardrobe, Mode.SYNC_ITEM, compoundNBT, null, null);
    }

    public static UpdateWardrobePacket field(SkinWardrobe wardrobe, Field field, Object value) {
        return new UpdateWardrobePacket(wardrobe, Mode.SYNC_OPTION, null, field, value);
    }

    @Override
    public void encode(PacketBuffer buffer) {
        buffer.func_179249_a((Enum)this.mode);
        buffer.writeInt(this.entityId);
        if (this.compoundNBT != null) {
            buffer.func_150786_a(this.compoundNBT);
        }
        if (this.field != null) {
            buffer.func_179249_a((Enum)this.field);
            this.field.getDataSerializer().func_187160_a(buffer, this.fieldValue);
        }
    }

    @Override
    public void accept(IServerPacketHandler packetHandler, ServerPlayerEntity player) {
        String playerName = player.func_145748_c_().getString();
        if (!(player.field_71070_bA instanceof SkinWardrobeMenu)) {
            ModLog.info("the wardrobe {} operation rejected for '{}'", this.getOperator(), playerName);
            return;
        }
        if (!this.checkSecurityByServer()) {
            ModLog.info("the wardrobe {} operation rejected for '{}', for security reasons.", this.getOperator(), playerName);
            return;
        }
        ModLog.debug("the wardrobe {} operation accepted for '{}'", this.getOperator(), playerName);
        SkinWardrobe wardrobe = this.apply((PlayerEntity)player);
        if (wardrobe != null) {
            NetworkManager.sendToTracking(this, (Entity)player);
        }
    }

    @Override
    public void accept(IClientPacketHandler packetHandler, PlayerEntity player) {
        this.apply(player);
    }

    @Nullable
    private SkinWardrobe apply(PlayerEntity player) {
        SkinWardrobe wardrobe = SkinWardrobe.of(PropertyProvider.getLevel((Entity)player).func_73045_a(this.entityId));
        if (wardrobe == null) {
            return null;
        }
        switch (this.mode) {
            case SYNC: {
                wardrobe.deserializeNBT(this.compoundNBT);
                return wardrobe;
            }
            case SYNC_ITEM: {
                IInventory inventory = wardrobe.getInventory();
                int slot = this.compoundNBT.func_74762_e("Slot");
                if (slot >= inventory.func_70302_i_()) break;
                inventory.func_70299_a(slot, ItemStack.func_199557_a((CompoundNBT)this.compoundNBT.func_74775_l("Item")));
                return wardrobe;
            }
            case SYNC_OPTION: {
                if (this.field == null) break;
                this.field.set(wardrobe, this.fieldValue);
                return wardrobe;
            }
        }
        return null;
    }

    private boolean checkSecurityByServer() {
        switch (this.mode) {
            case SYNC: {
                return false;
            }
            case SYNC_ITEM: {
                int slot = this.compoundNBT.func_74762_e("Slot");
                int index = slot - SkinSlotType.DYE.getIndex();
                if (index < 8 || index >= SkinSlotType.DYE.getMaxSize()) {
                    return false;
                }
                ItemStack itemStack = ItemStack.func_199557_a((CompoundNBT)this.compoundNBT.func_74775_l("Item"));
                if (itemStack.func_190926_b()) {
                    return true;
                }
                return ABI.is(itemStack, (Item)ModItems.BOTTLE.get());
            }
            case SYNC_OPTION: {
                return true;
            }
        }
        return true;
    }

    private Object getOperator() {
        if (this.field != null) {
            return this.field;
        }
        return this.mode;
    }

    public static enum Mode {
        SYNC,
        SYNC_ITEM,
        SYNC_OPTION;

    }

    public static enum Field {
        WARDROBE_ARMOUR_HEAD(EquipmentSlotType.HEAD),
        WARDROBE_ARMOUR_CHEST(EquipmentSlotType.CHEST),
        WARDROBE_ARMOUR_LEGS(EquipmentSlotType.LEGS),
        WARDROBE_ARMOUR_FEET(EquipmentSlotType.FEET),
        WARDROBE_EXTRA_RENDER(SkinWardrobe::shouldRenderExtra, SkinWardrobe::setRenderExtra),
        MANNEQUIN_IS_CHILD(MannequinEntity.DATA_IS_CHILD),
        MANNEQUIN_IS_FLYING(MannequinEntity.DATA_IS_FLYING),
        MANNEQUIN_IS_VISIBLE(MannequinEntity.DATA_IS_VISIBLE),
        MANNEQUIN_IS_GHOST(MannequinEntity.DATA_IS_GHOST),
        MANNEQUIN_EXTRA_RENDER(MannequinEntity.DATA_EXTRA_RENDERER),
        MANNEQUIN_POSE(DataSerializers.COMPOUND_TAG, MannequinEntity::saveCustomPose, MannequinEntity::readCustomPose),
        MANNEQUIN_POSITION(DataSerializers.VECTOR_3D, Entity::func_213303_ch, Entity::func_233576_c_),
        MANNEQUIN_TEXTURE(MannequinEntity.DATA_TEXTURE);

        private final boolean broadcastChanges;
        private final DataAccessor<SkinWardrobe, ?> dataAccessor;

        private Field(EquipmentSlotType slotType) {
            this(w -> w.shouldRenderEquipment(slotType), (w, v) -> w.setRenderEquipment(slotType, (boolean)v));
        }

        private Field(Function<SkinWardrobe, Boolean> supplier, BiConsumer<SkinWardrobe, Boolean> applier) {
            this.broadcastChanges = true;
            this.dataAccessor = DataAccessor.withDataSerializer(SkinWardrobe.class, DataSerializers.BOOLEAN).withSupplier(supplier).withApplier(applier);
        }

        private <S extends Entity, T> Field(IEntitySerializer<T> dataSerializer, Function<S, T> supplier, BiConsumer<S, T> applier) {
            this.broadcastChanges = false;
            this.dataAccessor = DataAccessor.withDataSerializer(SkinWardrobe.class, dataSerializer).withSupplier(wardrobe -> {
                if (wardrobe.getEntity() != null) {
                    return supplier.apply((Entity)ObjectUtils.unsafeCast(wardrobe.getEntity()));
                }
                return null;
            }).withApplier((wardrobe, value) -> {
                if (wardrobe.getEntity() != null) {
                    applier.accept((Entity)ObjectUtils.unsafeCast(wardrobe.getEntity()), value);
                }
            });
        }

        private <T> Field(DataParameter<T> dataParameter) {
            this(DataSerializers.of(dataParameter.func_187156_b()), e -> e.func_184212_Q().func_187225_a(dataParameter), (e, v) -> e.func_184212_Q().func_187227_b(dataParameter, v));
        }

        public <T> void set(SkinWardrobe wardrobe, T value) {
            DataAccessor<SkinWardrobe, T> dataAccessor = this.getDataAccessor();
            dataAccessor.set(wardrobe, value);
        }

        public <T> T get(SkinWardrobe wardrobe, T defaultValue) {
            DataAccessor<SkinWardrobe, T> dataAccessor = this.getDataAccessor();
            T value = dataAccessor.get(wardrobe);
            if (value != null) {
                return value;
            }
            return defaultValue;
        }

        public <T> DataAccessor<SkinWardrobe, T> getDataAccessor() {
            return (DataAccessor)ObjectUtils.unsafeCast(this.dataAccessor);
        }

        public <T> IEntitySerializer<T> getDataSerializer() {
            DataAccessor<SkinWardrobe, T> dataAccessor = this.getDataAccessor();
            return dataAccessor.dataSerializer;
        }
    }
}

