/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.permission;

import java.util.Collection;
import java.util.HashMap;
import moe.plushie.armourers_workshop.api.permission.IPermissionContext;
import moe.plushie.armourers_workshop.api.permission.IPermissionNode;
import moe.plushie.armourers_workshop.api.registry.IRegistryKey;
import moe.plushie.armourers_workshop.core.permission.PlayerPermissionContext;
import moe.plushie.armourers_workshop.init.platform.BuilderManager;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public abstract class Permission {
    protected final String name;
    protected final HashMap<ResourceLocation, IPermissionNode> nodes = new HashMap();

    public Permission(String name) {
        this.name = name;
    }

    protected void add(IRegistryKey<?> object) {
        ResourceLocation registryName = object.getRegistryName();
        IPermissionNode node = this.makeNode(registryName.func_110623_a() + "." + this.name);
        this.nodes.put(registryName, node);
    }

    protected IPermissionNode get(ResourceLocation registryName) {
        return this.nodes.get(registryName);
    }

    protected boolean eval(IPermissionNode node, PlayerEntity player, @Nullable PlayerPermissionContext context) {
        return node.resolve(player, (IPermissionContext)context);
    }

    private IPermissionNode makeNode(String path) {
        return (IPermissionNode)BuilderManager.getInstance().createPermissionBuilder().level(0).build(path);
    }

    public String getName() {
        return this.name;
    }

    public Collection<IPermissionNode> getNodes() {
        return this.nodes.values();
    }
}

