/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import moe.plushie.armourers_workshop.api.skin.ISkin;
import moe.plushie.armourers_workshop.api.skin.ISkinType;
import moe.plushie.armourers_workshop.core.skin.SkinTypes;
import moe.plushie.armourers_workshop.core.skin.data.SkinMarker;
import moe.plushie.armourers_workshop.core.skin.part.SkinPart;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperties;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperty;
import moe.plushie.armourers_workshop.utils.ThreadUtils;
import moe.plushie.armourers_workshop.utils.math.Rectangle3i;
import moe.plushie.armourers_workshop.utils.texture.SkinPaintData;
import net.minecraft.util.math.BlockPos;
import org.jetbrains.annotations.Nullable;

public class Skin
implements ISkin {
    private final int id = ThreadUtils.SKIN_COUNTER.incrementAndGet();
    private final SkinProperties properties;
    private final ISkinType skinType;
    private final ArrayList<SkinPart> parts;
    private final SkinPaintData paintData;

    public Skin(ISkinType skinType, SkinProperties properties, SkinPaintData paintData, ArrayList<SkinPart> skinParts) {
        this.properties = properties;
        this.skinType = skinType;
        this.paintData = paintData;
        this.parts = skinParts;
    }

    public int getId() {
        return this.id;
    }

    public SkinProperties getProperties() {
        return this.properties;
    }

    public HashMap<BlockPos, Rectangle3i> getBlockBounds() {
        HashMap<BlockPos, Rectangle3i> blockBounds = new HashMap<BlockPos, Rectangle3i>();
        if (this.skinType != SkinTypes.BLOCK) {
            return blockBounds;
        }
        for (SkinPart part : this.getParts()) {
            HashMap<BlockPos, Rectangle3i> partBlockBounds = part.getBlockBounds();
            if (partBlockBounds == null) continue;
            blockBounds.putAll(partBlockBounds);
        }
        return blockBounds;
    }

    public int getModelCount() {
        int count = 0;
        for (int i = 0; i < this.parts.size(); ++i) {
            count += this.parts.get(i).getModelCount();
        }
        return count;
    }

    public int getPartCount() {
        return this.parts.size();
    }

    @Override
    public ISkinType getType() {
        return this.skinType;
    }

    @Nullable
    public SkinPaintData getPaintData() {
        return this.paintData;
    }

    public List<SkinPart> getParts() {
        return this.parts;
    }

    public boolean requiresAdvanceFeatures() {
        return false;
    }

    public String getCustomName() {
        return this.properties.get(SkinProperty.ALL_CUSTOM_NAME);
    }

    public String getAuthorName() {
        return this.properties.get(SkinProperty.ALL_AUTHOR_NAME);
    }

    public String getFlavourText() {
        return this.properties.get(SkinProperty.ALL_FLAVOUR_TEXT);
    }

    public String toString() {
        String returnString = "Skin [properties=" + this.properties + ", type=" + this.skinType.getRegistryName();
        if (this.paintData != null) {
            returnString = returnString + ", paintData=" + this.paintData;
        }
        returnString = returnString + "]";
        return returnString;
    }

    public Collection<SkinMarker> getMarkers() {
        ArrayList<SkinMarker> markers = new ArrayList<SkinMarker>();
        for (SkinPart part : this.parts) {
            markers.addAll(part.getMarkers());
        }
        return markers;
    }

    public Object getBlobs() {
        return null;
    }

    public static class Builder {
        private final ISkinType skinType;
        private final ArrayList<SkinPart> skinParts = new ArrayList();
        private SkinPaintData paintData;
        private SkinProperties properties = SkinProperties.EMPTY;
        private Object blobs;

        public Builder(ISkinType skinType) {
            this.skinType = skinType;
        }

        public Builder properties(SkinProperties properties) {
            this.properties = properties;
            return this;
        }

        public Builder paintData(SkinPaintData paintData) {
            this.paintData = paintData;
            return this;
        }

        public Builder parts(Collection<SkinPart> parts) {
            this.skinParts.addAll(parts);
            return this;
        }

        public Builder blobs(Object blobs) {
            this.blobs = blobs;
            return this;
        }

        public Skin build() {
            this.updatePropertiesIfNeeded();
            this.bindPropertiesIfNeeded();
            return new Skin(this.skinType, this.properties, this.paintData, this.skinParts);
        }

        private void updatePropertiesIfNeeded() {
            if (this.properties.get(SkinProperty.OVERRIDE_MODEL_ALL).booleanValue()) {
                if (this.skinType == SkinTypes.ARMOR_HEAD) {
                    this.properties.put(SkinProperty.OVERRIDE_MODEL_HEAD, true);
                }
                if (this.skinType == SkinTypes.ARMOR_CHEST) {
                    this.properties.put(SkinProperty.OVERRIDE_MODEL_CHEST, true);
                    this.properties.put(SkinProperty.OVERRIDE_MODEL_LEFT_ARM, true);
                    this.properties.put(SkinProperty.OVERRIDE_MODEL_RIGHT_ARM, true);
                }
                if (this.skinType == SkinTypes.ARMOR_LEGS) {
                    this.properties.put(SkinProperty.OVERRIDE_MODEL_LEFT_LEG, true);
                    this.properties.put(SkinProperty.OVERRIDE_MODEL_RIGHT_LEG, true);
                }
                if (this.skinType == SkinTypes.ARMOR_FEET) {
                    this.properties.put(SkinProperty.OVERRIDE_MODEL_LEFT_LEG, true);
                    this.properties.put(SkinProperty.OVERRIDE_MODEL_RIGHT_LEG, true);
                }
                this.properties.remove(SkinProperty.OVERRIDE_MODEL_ALL);
            }
            if (this.properties.get(SkinProperty.OVERRIDE_OVERLAY_ALL).booleanValue()) {
                if (this.skinType == SkinTypes.ARMOR_HEAD) {
                    this.properties.put(SkinProperty.OVERRIDE_OVERLAY_HAT, true);
                }
                if (this.skinType == SkinTypes.ARMOR_CHEST) {
                    this.properties.put(SkinProperty.OVERRIDE_OVERLAY_JACKET, true);
                    this.properties.put(SkinProperty.OVERRIDE_OVERLAY_LEFT_SLEEVE, true);
                    this.properties.put(SkinProperty.OVERRIDE_OVERLAY_RIGHT_SLEEVE, true);
                }
                if (this.skinType == SkinTypes.ARMOR_LEGS) {
                    this.properties.put(SkinProperty.OVERRIDE_OVERLAY_LEFT_PANTS, true);
                    this.properties.put(SkinProperty.OVERRIDE_OVERLAY_RIGHT_PANTS, true);
                }
                if (this.skinType == SkinTypes.ARMOR_FEET) {
                    this.properties.put(SkinProperty.OVERRIDE_OVERLAY_LEFT_PANTS, true);
                    this.properties.put(SkinProperty.OVERRIDE_OVERLAY_RIGHT_PANTS, true);
                }
                this.properties.remove(SkinProperty.OVERRIDE_OVERLAY_ALL);
            }
        }

        private void bindPropertiesIfNeeded() {
            for (SkinPart part : this.skinParts) {
                part.setProperties(this.properties);
            }
            String skinIndexs = this.properties.get(SkinProperty.OUTFIT_PART_INDEXS);
            if (skinIndexs != null && !skinIndexs.equals("")) {
                String[] split = skinIndexs.split(":");
                int partIndex = 0;
                for (int skinIndex = 0; skinIndex < split.length; ++skinIndex) {
                    SkinProperties stub = SkinProperties.create(this.properties, skinIndex);
                    int count = Integer.parseInt(split[skinIndex]);
                    while (partIndex < count) {
                        if (partIndex < this.skinParts.size()) {
                            SkinPart skinPart = this.skinParts.get(partIndex);
                            skinPart.setProperties(stub);
                        }
                        ++partIndex;
                    }
                    partIndex = count;
                }
            }
        }
    }
}

