/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin;

import java.util.Objects;
import java.util.function.BooleanSupplier;
import moe.plushie.armourers_workshop.init.ModConfig;
import moe.plushie.armourers_workshop.utils.DataSerializers;
import net.minecraft.nbt.CompoundNBT;

public class SkinOptions {
    public static SkinOptions DEFAULT = new SkinOptions();
    private int tooltipFlags = 0;
    private int enableEmbeddedItemRenderer = 0;

    public SkinOptions() {
    }

    public SkinOptions(CompoundNBT tag) {
        this.tooltipFlags = tag.func_74762_e("TooltipFlags");
        this.enableEmbeddedItemRenderer = tag.func_74762_e("EmbeddedItemRenderer");
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT nbt = new CompoundNBT();
        DataSerializers.putInt(nbt, "TooltipFlags", this.tooltipFlags, 0);
        DataSerializers.putInt(nbt, "EmbeddedItemRenderer", this.enableEmbeddedItemRenderer, 0);
        return nbt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SkinOptions)) {
            return false;
        }
        SkinOptions that = (SkinOptions)o;
        return this.tooltipFlags == that.tooltipFlags && this.enableEmbeddedItemRenderer == that.enableEmbeddedItemRenderer;
    }

    public int hashCode() {
        return Objects.hash(this.tooltipFlags, this.enableEmbeddedItemRenderer);
    }

    public boolean contains(TooltipFlags flags) {
        if ((this.tooltipFlags & flags.flags) != 0) {
            return false;
        }
        return flags.supplier.getAsBoolean();
    }

    public int getEmbeddedItemRenderer() {
        return this.enableEmbeddedItemRenderer;
    }

    public static enum TooltipFlags {
        NAME(1, () -> ModConfig.Client.tooltipSkinName),
        AUTHOR(2, () -> ModConfig.Client.tooltipSkinAuthor),
        TYPE(4, () -> ModConfig.Client.tooltipSkinType),
        FLAVOUR(8, () -> ModConfig.Client.tooltipFlavour),
        HAS_SKIN(16, () -> ModConfig.Client.tooltipHasSkin),
        OPEN_WARDROBE(32, () -> ModConfig.Client.tooltipHasSkin),
        PREVIEW(128, () -> ModConfig.Client.skinPreEnabled);

        private final int flags;
        private final BooleanSupplier supplier;

        private TooltipFlags(int flags, BooleanSupplier supplier) {
            this.flags = flags;
            this.supplier = supplier;
        }
    }
}

