/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.data.base;

import java.io.DataInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.function.Function;
import moe.plushie.armourers_workshop.api.registry.IRegistryEntry;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperties;
import moe.plushie.armourers_workshop.utils.math.Vector3f;

public interface IDataInputStream {
    public static IDataInputStream of(DataInputStream stream) {
        return () -> stream;
    }

    public DataInputStream getInputStream();

    default public void readFully(byte[] b) throws IOException {
        this.getInputStream().readFully(b);
    }

    default public void readFully(byte[] b, int off, int len) throws IOException {
        this.getInputStream().readFully(b, off, len);
    }

    default public byte readByte() throws IOException {
        return this.getInputStream().readByte();
    }

    default public boolean readBoolean() throws IOException {
        return this.getInputStream().readBoolean();
    }

    default public short readShort() throws IOException {
        return this.getInputStream().readShort();
    }

    default public int readInt() throws IOException {
        return this.getInputStream().readInt();
    }

    default public long readLong() throws IOException {
        return this.getInputStream().readLong();
    }

    default public double readDouble() throws IOException {
        return this.getInputStream().readDouble();
    }

    default public String readString() throws IOException {
        int size = this.getInputStream().readUnsignedShort();
        return this.readString(size);
    }

    default public String readString(int len) throws IOException {
        byte[] bytes = new byte[len];
        this.getInputStream().readFully(bytes, 0, len);
        return new String(bytes, StandardCharsets.UTF_8);
    }

    default public Vector3f readVector3f() throws IOException {
        DataInputStream stream = this.getInputStream();
        float x = stream.readFloat();
        float y = stream.readFloat();
        float z = stream.readFloat();
        return new Vector3f(x, y, z);
    }

    default public <T extends IRegistryEntry> T readType(Function<String, T> transform) throws IOException {
        String name = this.readString();
        return (T)((IRegistryEntry)transform.apply(name));
    }

    default public SkinProperties readProperties() throws IOException {
        SkinProperties properties = SkinProperties.create();
        properties.readFromStream(this);
        return properties;
    }
}

