/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.data.base;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import moe.plushie.armourers_workshop.api.registry.IRegistryEntry;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperties;
import moe.plushie.armourers_workshop.utils.math.Vector3f;

public interface IDataOutputStream {
    public static IDataOutputStream of(DataOutputStream stream) {
        return () -> stream;
    }

    public DataOutputStream getOutputStream();

    default public void write(byte[] bytes) throws IOException {
        this.getOutputStream().write(bytes);
    }

    default public void write(byte[] b, int off, int len) throws IOException {
        this.getOutputStream().write(b, off, len);
    }

    default public void writeByte(int v) throws IOException {
        this.getOutputStream().writeByte(v);
    }

    default public void writeBoolean(boolean v) throws IOException {
        this.getOutputStream().writeBoolean(v);
    }

    default public void writeShort(int v) throws IOException {
        this.getOutputStream().writeShort(v);
    }

    default public void writeInt(int v) throws IOException {
        this.getOutputStream().writeInt(v);
    }

    default public void writeLong(long v) throws IOException {
        this.getOutputStream().writeLong(v);
    }

    default public void writeDouble(double v) throws IOException {
        this.getOutputStream().writeDouble(v);
    }

    default public void writeString(String v) throws IOException {
        byte[] bytes = v.getBytes(StandardCharsets.UTF_8);
        int size = bytes.length;
        if (size > 65535) {
            throw new IOException("String is over the max length allowed.");
        }
        this.getOutputStream().writeShort((short)size);
        this.getOutputStream().write(bytes);
    }

    default public void writeString(String v, int len) throws IOException {
        byte[] bytes = v.getBytes(StandardCharsets.UTF_8);
        this.getOutputStream().write(bytes, 0, len);
    }

    default public void writeVector3f(Vector3f vec) throws IOException {
        DataOutputStream stream = this.getOutputStream();
        stream.writeFloat(vec.getX());
        stream.writeFloat(vec.getY());
        stream.writeFloat(vec.getZ());
    }

    default public void writeSkinProperties(SkinProperties properties) throws IOException {
        properties.writeToStream(this);
    }

    default public void writeType(IRegistryEntry type) throws IOException {
        this.writeString(type.getRegistryName().toString());
    }
}

