/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.data.serialize.v20.chunk;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import moe.plushie.armourers_workshop.api.painting.IPaintColor;
import moe.plushie.armourers_workshop.api.skin.ISkinPaintType;
import moe.plushie.armourers_workshop.core.data.color.PaintColor;
import moe.plushie.armourers_workshop.core.skin.data.base.IDataInputStream;
import moe.plushie.armourers_workshop.core.skin.data.base.IDataOutputStream;
import moe.plushie.armourers_workshop.core.skin.data.serialize.v20.chunk.ChunkInputStream;
import moe.plushie.armourers_workshop.core.skin.data.serialize.v20.chunk.ChunkOutputStream;
import moe.plushie.armourers_workshop.core.skin.data.serialize.v20.chunk.ChunkVariable;
import moe.plushie.armourers_workshop.core.skin.painting.SkinPaintType;
import moe.plushie.armourers_workshop.core.skin.painting.SkinPaintTypes;

public class ChunkPalette
implements ChunkVariable {
    private final byte[] buffer = new byte[8];
    private final ArrayList<Section> sections = new ArrayList();
    private final HashMap<Integer, Section> fastSections = new HashMap();
    private final ArrayList<IPaintColor> allColors = new ArrayList();
    private int freezeCount = 0;
    private int usedBytes = 1;
    private boolean resolved = false;

    public void writeColor(int color, ChunkOutputStream stream) throws IOException {
        stream.writeVariable(this._index(color));
    }

    public void writeColor(IPaintColor color, ChunkOutputStream stream) throws IOException {
        stream.writeVariable(this._index(color.getRawValue()));
    }

    public IPaintColor readColor(ChunkInputStream stream) throws IOException {
        int index = this._readFixedInt(this.usedBytes, stream);
        return this.allColors.get(index);
    }

    public void readFromStream(IDataInputStream stream) throws IOException {
        Section section;
        while ((section = this.readSectionFromStream(stream)) != null) {
            this.sections.add(section);
            Iterator iterator = section.colors.iterator();
            while (iterator.hasNext()) {
                int color = (Integer)iterator.next();
                this.allColors.add(PaintColor.of(color, section.paintType));
            }
        }
    }

    @Override
    public void writeToStream(IDataOutputStream stream) throws IOException {
        for (Section section : this.sections) {
            this.writeSectionToStream(section, stream);
        }
        this.writeSectionToStream(null, stream);
    }

    @Override
    public boolean freeze() {
        ++this.freezeCount;
        if (this.freezeCount <= 1) {
            return false;
        }
        int usedCount = 0;
        for (Section section : this.sections) {
            ((Section)section).offset[0] = usedCount;
            usedCount += section.colors.size();
        }
        this.usedBytes = this._used(usedCount);
        this.resolved = true;
        return true;
    }

    private Index _index(int value) {
        return this.fastSections.computeIfAbsent(value & 0xFF000000 | 3, k -> {
            ISkinPaintType paintType = PaintColor.getPaintType(value);
            Section section = new Section(paintType, 3);
            this.sections.add(section);
            return section;
        }).put(value);
    }

    private int _used(int size) {
        for (int i = 1; i < 4; ++i) {
            if (size >>> i * 8 != 0) continue;
            return i;
        }
        return 4;
    }

    private int _readFixedInt(int usedBytes, IDataInputStream stream) throws IOException {
        stream.readFully(this.buffer, 4 - usedBytes, usedBytes);
        int value = 0;
        for (int i = 4 - usedBytes; i < 4; ++i) {
            value = value << 8 | this.buffer[i] & 0xFF;
        }
        return value;
    }

    private void _writeFixedInt(int value, int usedBytes, IDataOutputStream stream) throws IOException {
        this.buffer[0] = (byte)(value >>> 24);
        this.buffer[1] = (byte)(value >>> 16);
        this.buffer[2] = (byte)(value >>> 8);
        this.buffer[3] = (byte)(value >>> 0);
        stream.write(this.buffer, 4 - usedBytes, usedBytes);
    }

    private Section readSectionFromStream(IDataInputStream stream) throws IOException {
        int length = stream.readInt();
        if (length == 0) {
            return null;
        }
        SkinPaintType paintType = SkinPaintTypes.byId(stream.readByte());
        byte usedBytes = stream.readByte();
        Section section = new Section(paintType, usedBytes);
        for (int i = 0; i < length; ++i) {
            section.colors.add(this._readFixedInt(usedBytes, stream));
        }
        return section;
    }

    private void writeSectionToStream(Section section, IDataOutputStream stream) throws IOException {
        if (section == null) {
            stream.writeInt(0);
            return;
        }
        stream.writeInt(section.colors.size());
        stream.writeByte(section.paintType.getId());
        stream.writeByte(section.usedBytes);
        Iterator iterator = section.colors.iterator();
        while (iterator.hasNext()) {
            int color = (Integer)iterator.next();
            this._writeFixedInt(color, section.usedBytes, stream);
        }
    }

    public class Index
    implements ChunkVariable {
        private final int value;
        private final int[] offset;

        public Index(int value, int[] offset) {
            this.value = value;
            this.offset = offset;
        }

        @Override
        public void writeToStream(IDataOutputStream stream) throws IOException {
            ChunkPalette.this._writeFixedInt(this.offset[0] + this.value, ChunkPalette.this.usedBytes, stream);
        }

        @Override
        public boolean freeze() {
            return ChunkPalette.this.resolved;
        }
    }

    public class Section {
        private final int[] offset = new int[]{0};
        private final ArrayList<Integer> colors = new ArrayList();
        private final HashMap<Integer, Index> fastColors = new HashMap();
        private final int usedBytes;
        private final ISkinPaintType paintType;

        public Section(ISkinPaintType paintType, int usedBytes) {
            this.paintType = paintType;
            this.usedBytes = usedBytes;
        }

        public Index put(int value) {
            if (this.usedBytes == 3) {
                value |= 0xFF000000;
            }
            return this.fastColors.computeIfAbsent(value, k -> {
                Index index = new Index(this.colors.size(), this.offset);
                this.colors.add((Integer)k);
                return index;
            });
        }
    }
}

