/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.data.serialize.v20.chunk;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.function.Predicate;
import moe.plushie.armourers_workshop.core.skin.data.base.IDataOutputStream;
import moe.plushie.armourers_workshop.core.skin.data.serialize.v20.ChunkSerializer;
import moe.plushie.armourers_workshop.core.skin.data.serialize.v20.chunk.ChunkContext;
import moe.plushie.armourers_workshop.core.skin.data.serialize.v20.chunk.ChunkInputStream;
import moe.plushie.armourers_workshop.core.skin.data.serialize.v20.chunk.ChunkVariable;
import org.jetbrains.annotations.Nullable;

public class ChunkReader {
    private final ChunkInputStream stream;
    private final Predicate<String> chunkFilter;
    private final ArrayList<Entry> entries = new ArrayList();

    public ChunkReader(ChunkInputStream stream, Predicate<String> chunkFilter) {
        this.stream = stream;
        this.chunkFilter = chunkFilter;
    }

    protected void prepare() throws IOException {
        int length;
        int header = 10;
        while ((length = this.stream.readInt()) != 0) {
            String name = this.stream.readString(4);
            short flag = this.stream.readShort();
            if (this.chunkFilter != null && !this.chunkFilter.test(name)) {
                this.stream.getInputStream().skipBytes(length - header);
                continue;
            }
            ByteBuf buffer = Unpooled.buffer((int)(length - header));
            this.stream.readFully(buffer.array(), 0, length - header);
            buffer.writerIndex(length - header);
            this.entries.add(new Entry(name, flag, length, buffer, this.stream.getContext()));
        }
    }

    @Nullable
    public <T> T read(ChunkSerializer<T, Void> serializer) throws IOException {
        return this.read(serializer, null);
    }

    @Nullable
    public <T, C> T read(ChunkSerializer<T, C> serializer, C context) throws IOException {
        Iterator<Entry> iterator = this.entries.iterator();
        while (iterator.hasNext()) {
            Entry entry = iterator.next();
            if (!entry.name.equalsIgnoreCase(serializer.getChunkType().getName())) continue;
            iterator.remove();
            return entry.read(serializer, context);
        }
        return null;
    }

    public <T> Collection<T> readAll(ChunkSerializer<T, Void> serializer) throws IOException {
        return this.readAll(serializer, null);
    }

    public <T, C> Collection<T> readAll(ChunkSerializer<T, C> serializer, C context) throws IOException {
        ArrayList<T> results = new ArrayList<T>();
        Iterator<Entry> iterator = this.entries.iterator();
        while (iterator.hasNext()) {
            Entry entry = iterator.next();
            if (!entry.name.equalsIgnoreCase(serializer.getChunkType().getName())) continue;
            iterator.remove();
            T result = entry.read(serializer, context);
            if (result == null) continue;
            results.add(result);
        }
        return results;
    }

    public Object readBlobs() throws IOException {
        if (this.entries.size() != 0) {
            return this.entries;
        }
        return null;
    }

    protected static class Entry
    implements ChunkVariable {
        private final String name;
        private final ByteBuf buffer;
        private final int flag;
        private final int length;
        private ChunkInputStream inputStream;
        private final ChunkContext context;

        public Entry(String name, int flag, int length, ByteBuf buffer, ChunkContext context) {
            this.length = length;
            this.name = name;
            this.flag = flag;
            this.buffer = buffer;
            this.context = context;
        }

        public <T, C> T read(ChunkSerializer<T, C> serializer, C obj) throws IOException {
            if (this.inputStream == null) {
                this.inputStream = new ChunkInputStream(new DataInputStream(this.context.createInputStream(this.buffer, this.flag)), this.context, null);
            }
            return serializer.read(this.inputStream, obj);
        }

        @Override
        public void writeToStream(IDataOutputStream stream) throws IOException {
            stream.writeInt(this.length);
            stream.writeString(this.name, 4);
            stream.writeShort(this.flag);
            stream.write(this.buffer.array());
        }

        @Override
        public boolean freeze() {
            return true;
        }
    }
}

