/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.exporter;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import moe.plushie.armourers_workshop.api.skin.ISkin;
import moe.plushie.armourers_workshop.api.skin.ISkinCubeType;
import moe.plushie.armourers_workshop.api.skin.ISkinExporter;
import moe.plushie.armourers_workshop.core.data.color.PaintColor;
import moe.plushie.armourers_workshop.core.skin.Skin;
import moe.plushie.armourers_workshop.core.skin.cube.SkinCubeTypes;
import moe.plushie.armourers_workshop.core.skin.cube.SkinCubes;
import moe.plushie.armourers_workshop.core.skin.exporter.SkinExportManager;
import moe.plushie.armourers_workshop.core.skin.face.SkinCubeFace;
import moe.plushie.armourers_workshop.core.skin.face.SkinCuller;
import moe.plushie.armourers_workshop.core.skin.painting.SkinPaintTypes;
import moe.plushie.armourers_workshop.core.skin.part.SkinPart;
import moe.plushie.armourers_workshop.init.ModLog;
import moe.plushie.armourers_workshop.utils.SkinUtils;
import moe.plushie.armourers_workshop.utils.math.OpenPoseStack;
import moe.plushie.armourers_workshop.utils.math.Rectangle3i;
import moe.plushie.armourers_workshop.utils.math.Vector3f;
import moe.plushie.armourers_workshop.utils.math.Vector4f;

public class SkinExporterPolygon
implements ISkinExporter {
    private static final String CRLF = "\n";

    @Override
    public Collection<String> getExtensions() {
        return Collections.singleton("ply");
    }

    @Override
    public void exportSkin(ISkin skinIn, File filePath, String filename, float scale) throws Exception {
        Skin skin = (Skin)skinIn;
        int partIndex = 0;
        for (SkinPart skinPart : skin.getParts()) {
            this.exportPart(skinPart, skin, filePath, filename, scale, partIndex++);
        }
    }

    private void exportPart(SkinPart skinPart, Skin skin, File filePath, String filename, float scale, int partIndex) throws IOException {
        SkinCubes cubeData = skinPart.getCubeData();
        Rectangle3i bounds = new Rectangle3i(cubeData.getRenderShape().bounds());
        HashMap<ISkinCubeType, ArrayList> faces = new HashMap<ISkinCubeType, ArrayList>();
        for (SkinCubeFace face : SkinCuller.cullFaces(cubeData, bounds)) {
            if (face.getPaintType() == SkinPaintTypes.NONE) continue;
            faces.computeIfAbsent(face.getType(), k -> new ArrayList()).add(face);
        }
        String[] layerNames = new String[]{"opaque", "glowing", "transparent", "transparent-glowing"};
        for (int i = 0; i < SkinCubeTypes.getTotalCubes(); ++i) {
            ArrayList faces1 = (ArrayList)faces.get(SkinCubeTypes.byId(i));
            if (faces1 == null || faces1.isEmpty()) continue;
            this.exportLayer(faces1, skinPart, skin, filePath, filename, scale, layerNames[i], partIndex);
        }
    }

    private void exportLayer(ArrayList<SkinCubeFace> faces, SkinPart skinPart, Skin skin, File filePath, String filename, float scale, String layer, int partIndex) throws IOException {
        ModLog.debug("export {} layer of {}:{}, faces: {}", layer, partIndex, skinPart.getType(), faces.size());
        String finalName = filename;
        finalName = finalName + "-" + partIndex;
        finalName = finalName + "-" + skinPart.getType().getRegistryName().func_110623_a();
        finalName = finalName + "-" + layer;
        finalName = finalName + ".ply";
        FileOutputStream outputStream = new FileOutputStream(new File(filePath, finalName), false);
        OutputStreamWriter os = new OutputStreamWriter((OutputStream)outputStream, StandardCharsets.US_ASCII);
        os.write("ply\n");
        os.write("format ascii 1.0\n");
        os.write("comment made by RiskyKen\n");
        os.write("comment This file was exported from the Minecraft mod Armourer's Workshop\n");
        os.write("element vertex " + faces.size() * 4 + CRLF);
        os.write("property float x\n");
        os.write("property float y\n");
        os.write("property float z\n");
        os.write("property uchar red\n");
        os.write("property uchar green\n");
        os.write("property uchar blue\n");
        os.write("element face " + faces.size() + CRLF);
        os.write("property list uchar int vertex_index\n");
        os.write("end_header\n");
        os.flush();
        OpenPoseStack poseStack = new OpenPoseStack();
        poseStack.scale(scale, scale, scale);
        poseStack.scale(-1.0f, -1.0f, 1.0f);
        poseStack.rotate(Vector3f.YP.rotationDegrees(90.0f));
        for (SkinCubeFace face : faces) {
            byte[][] vertexes = SkinUtils.getRenderVertexes(face.getDirection());
            for (int i = 0; i < 4; ++i) {
                this.writeVert(poseStack, os, face.x + vertexes[i][0], face.y + vertexes[i][1], face.z + vertexes[i][2], face.getColor());
            }
        }
        for (int i = 0; i < faces.size(); ++i) {
            os.write(String.format("4 %d %d %d %d", 4 * i, 4 * i + 1, 4 * i + 2, 4 * i + 3) + CRLF);
        }
        os.flush();
        outputStream.flush();
        outputStream.close();
    }

    private void writeVert(OpenPoseStack poseStack, OutputStreamWriter os, float x, float y, float z, PaintColor color) throws IOException {
        Vector4f q = new Vector4f(x, y, z, 1.0f);
        q.transform(poseStack.lastPose());
        os.write(String.format("%s %s %s %d %d %d", this.f2s(q.x()), this.f2s(q.y()), this.f2s(q.z()), color.getRed(), color.getGreen(), color.getBlue()) + CRLF);
    }

    private String f2s(float value) {
        return SkinExportManager.FLOAT_FORMAT.format(value);
    }
}

