/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.init;

import java.util.ArrayList;
import moe.plushie.armourers_workshop.init.ModConfigSpec;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;

public class ModConfig {
    public static void init() {
        ModConfigSpec.init();
    }

    public static boolean enableEmbeddedSkinRenderer() {
        int flags = Client.enableEmbeddedSkinRenderer;
        if (flags == 0) {
            flags = Common.enableEmbeddedSkinRenderer;
        }
        return flags == 2;
    }

    public static boolean enableFirstPersonSkinRenderer() {
        int flags = Client.enableFirstPersonSkinRenderer;
        if (flags == 0) {
            flags = Common.enableFirstPersonSkinRenderer;
        }
        return flags == 2;
    }

    public static class Client {
        public static int enableEmbeddedSkinRenderer = 0;
        public static int enableFirstPersonSkinRenderer = 0;
        public static int renderDistanceSkin;
        public static int renderDistanceBlockSkin;
        public static int renderDistanceMannequinEquipment;
        public static int modelBakingThreadCount;
        public static double lodDistance;
        public static boolean multipassSkinRendering;
        public static int maxLodLevels;
        public static int prefersSeatHoldingTick;
        public static int skinLoadAnimationTime;
        public static boolean enableEntityInInventoryClip;
        public static boolean enableSkinLimitLimbs;
        public static int skinCacheExpireTime;
        public static int skinCacheMaxSize;
        public static int modelPartCacheExpireTime;
        public static int modelPartCacheMaxSize;
        public static int textureCacheExpireTime;
        public static int textureCacheMaxSize;
        public static int maxSkinRequests;
        public static int fastCacheSize;
        public static int maxSkinSlots;
        public static boolean skinPreEnabled;
        public static boolean skinPreDrawBackground;
        public static int skinPreSize;
        public static double skinPreLocHorizontal;
        public static double skinPreLocVertical;
        public static boolean skinPreLocFollowMouse;
        public static boolean tooltipHasSkin;
        public static boolean tooltipSkinName;
        public static boolean tooltipSkinAuthor;
        public static boolean tooltipSkinType;
        public static boolean tooltipFlavour;
        public static boolean tooltipOpenWardrobe;
        public static int texturePaintingType;
        public static boolean showF3DebugInfo;
        public static float ploOffset;
        public static boolean enablePartSubdivide;
        public static boolean enableShaderDebug;
        public static boolean enableEntityPlacementHighlight;
        public static boolean enableBlockPlacementHighlight;
        public static boolean enablePaintToolPlacementHighlight;
        public static boolean enableMagicWhenContributor;

        public static int getNumberOfRenderLayers() {
            if (multipassSkinRendering) {
                return 4;
            }
            return 2;
        }

        public static TexturePaintType getTexturePaintType() {
            if (texturePaintingType < 0) {
                return TexturePaintType.DISABLED;
            }
            if (texturePaintingType == 0) {
                return TexturePaintType.TEXTURE_REPLACE;
            }
            return TexturePaintType.values()[texturePaintingType];
        }

        static {
            modelBakingThreadCount = 4;
            lodDistance = 32.0;
            multipassSkinRendering = true;
            maxLodLevels = 4;
            prefersSeatHoldingTick = 60;
            enableEntityInInventoryClip = true;
            enableSkinLimitLimbs = true;
            maxSkinSlots = 10;
            skinPreEnabled = true;
            skinPreDrawBackground = true;
            skinPreSize = 96;
            skinPreLocHorizontal = 0.0;
            skinPreLocVertical = 0.5;
            skinPreLocFollowMouse = true;
            tooltipHasSkin = true;
            tooltipSkinName = true;
            tooltipSkinAuthor = true;
            tooltipSkinType = true;
            tooltipFlavour = true;
            tooltipOpenWardrobe = true;
            ploOffset = -0.01f;
            enablePartSubdivide = false;
            enableShaderDebug = true;
            enableEntityPlacementHighlight = true;
            enableBlockPlacementHighlight = true;
            enablePaintToolPlacementHighlight = true;
            enableMagicWhenContributor = false;
        }
    }

    public static class Common {
        public static int maxUndos = 100;
        public static int blockTaskRate = 10;
        public static boolean lockDyesOnSkins = false;
        public static boolean instancedDyeTable = false;
        public static boolean enableProtocolCheck = true;
        public static int serverSkinSendRate = 4000;
        public static boolean enableServerCompressesSkins = true;
        public static int enableEmbeddedSkinRenderer = 0;
        public static int enableFirstPersonSkinRenderer = 0;
        public static boolean enableMatchingByItemId = true;
        public static boolean wardrobeAllowOpening = true;
        public static boolean showWardrobeSkins = true;
        public static boolean showWardrobeOutfits = true;
        public static boolean showWardrobeDisplaySettings = true;
        public static boolean showWardrobeColorSettings = true;
        public static boolean showWardrobeDyeSetting = true;
        public static boolean showWardrobeContributorSetting = true;
        public static int prefersWardrobePlayerSlots = 3;
        public static int prefersWardrobeMobSlots = 3;
        public static int prefersWardrobeDropOnDeath = 0;
        public static boolean extractOfficialSkins;
        public static boolean allowLibraryPreviews;
        public static boolean allowDownloadingSkins;
        public static boolean allowUploadingSkins;
        public static boolean allowLibraryRemoteManage;
        public static boolean disableAllHolidayEvents;
        public static int skinCacheExpireTime;
        public static int skinCacheMaxSize;
        public static ArrayList<String> customGlobalSkinLibraryURLs;
        public static boolean enablePrivateGlobalSkinLibrary;
        public static ArrayList<String> overrides;
        public static ArrayList<String> disableMatchingItems;

        public static boolean canOpenWardrobe(Entity target, PlayerEntity operator) {
            if (!wardrobeAllowOpening) {
                return false;
            }
            if (operator.func_184812_l_()) {
                return true;
            }
            return showWardrobeSkins || showWardrobeOutfits || showWardrobeDisplaySettings || showWardrobeColorSettings || showWardrobeDyeSetting;
        }

        static {
            allowLibraryPreviews = true;
            allowDownloadingSkins = false;
            allowUploadingSkins = true;
            allowLibraryRemoteManage = false;
            disableAllHolidayEvents = false;
            skinCacheExpireTime = 600;
            skinCacheMaxSize = 2000;
            customGlobalSkinLibraryURLs = new ArrayList();
            enablePrivateGlobalSkinLibrary = false;
            overrides = new ArrayList();
            disableMatchingItems = new ArrayList();
        }
    }

    public static enum TexturePaintType {
        DISABLED,
        TEXTURE_REPLACE,
        MODEL_REPLACE_MC,
        MODEL_REPLACE_AW;

    }
}

