/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.init;

import com.apple.library.coregraphics.CGPoint;
import com.apple.library.uikit.UIImage;
import java.util.HashMap;
import moe.plushie.armourers_workshop.init.ModConstants;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ModTextures {
    public static final ResourceLocation WARDROBE_1 = ModTextures.res("textures/gui/wardrobe/wardrobe-1.png");
    public static final ResourceLocation WARDROBE_2 = ModTextures.res("textures/gui/wardrobe/wardrobe-2.png");
    public static final ResourceLocation SKINNING_TABLE = ModTextures.res("textures/gui/skinning_table/skinning-table.png");
    public static final ResourceLocation DYE_TABLE = ModTextures.res("textures/gui/dye_table/dye-table.png");
    public static final ResourceLocation SKIN_LIBRARY = ModTextures.res("textures/gui/skin_library/armour-library.png");
    public static final ResourceLocation GLOBAL_SKIN_LIBRARY = ModTextures.res("textures/gui/global_library/global-library.png");
    public static final ResourceLocation COLOR_MIXER = ModTextures.res("textures/gui/colour_mixer/colour-mixer.png");
    public static final ResourceLocation OUTFIT_MAKER = ModTextures.res("textures/gui/outfit_maker/outfit-maker.png");
    public static final ResourceLocation ARMOURER = ModTextures.res("textures/gui/armourer/armourer.png");
    public static final ResourceLocation ADVANCED_SKIN_BUILDER = ModTextures.res("textures/gui/advanced_skin_builder/advanced-skin-builder.png");
    public static final ResourceLocation TABS = ModTextures.res("textures/gui/controls/tabs.png");
    public static final ResourceLocation COMMON = ModTextures.res("textures/gui/common.png");
    public static final ResourceLocation WIDGETS = ModTextures.res("textures/gui/widgets.png");
    public static final ResourceLocation LIST = ModTextures.res("textures/gui/controls/list.png");
    public static final ResourceLocation RATING = ModTextures.res("textures/gui/controls/rating.png");
    public static final ResourceLocation TAB_ICONS = ModTextures.res("textures/gui/controls/tab_icons.png");
    public static final ResourceLocation HUE = ModTextures.res("textures/gui/controls/slider-hue.png");
    public static final ResourceLocation BUTTONS = ModTextures.res("textures/gui/controls/buttons.png");
    public static final ResourceLocation HELP = ModTextures.res("textures/gui/controls/help.png");
    public static final ResourceLocation PLAYER_INVENTORY = ModTextures.res("textures/gui/player_inventory.png");
    public static final ResourceLocation CUBE = ModTextures.res("textures/armour/cube.png");
    public static final ResourceLocation LIGHTING_CUBE = ModTextures.res("textures/armour/glowcube.png");
    public static final ResourceLocation CIRCLE = ModTextures.res("textures/other/nanoha-circle.png");
    public static final ResourceLocation EARTH = ModTextures.res("textures/blockentity/global-skin-library.png");
    public static final ResourceLocation MANNEQUIN_DEFAULT = ModTextures.res("textures/entity/mannequin.png");
    public static final ResourceLocation MANNEQUIN_HIGHLIGHT = ModTextures.res("textures/entity/mannequin_h.png");
    public static final ResourceLocation GUI_PREVIEW = ModTextures.res("textures/gui/skin-preview.png");
    public static final ResourceLocation SKIN_PANEL = ModTextures.res("textures/gui/controls/skin-panel.png");
    public static final ResourceLocation SCROLLBAR = ModTextures.res("textures/gui/controls/scrollbar.png");
    public static final ResourceLocation MARKERS = ModTextures.res("textures/blockentity/markers.png");
    public static final ResourceLocation GUIDES = ModTextures.res("textures/block/guide.png");
    public static final ResourceLocation BLOCK_CUBE = ModTextures.res("textures/block/colourable/colourable.png");
    public static final ResourceLocation BLOCK_CUBE_GLASS = ModTextures.res("textures/block/colourable/colourable-glass.png");

    private static ResourceLocation res(String name) {
        return ModConstants.key(name);
    }

    public static UIImage defaultWindowImage() {
        return UIImage.of(COMMON).fixed(128.0f, 128.0f).clip(4.0f, 4.0f, 4.0f, 4.0f).build();
    }

    public static UIImage defaultButtonImage() {
        HashMap<Integer, CGPoint> offsets = new HashMap<Integer, CGPoint>();
        offsets.put(4, new CGPoint(0.0f, 0.0f));
        offsets.put(0, new CGPoint(0.0f, 1.0f));
        offsets.put(1, new CGPoint(0.0f, 2.0f));
        return UIImage.of(WIDGETS).uv(0.0f, 46.0f).fixed(200.0f, 20.0f).clip(4.0f, 4.0f, 4.0f, 4.0f).unzip(offsets::get).build();
    }

    public static UIImage defaultButtonImage(float u, float v) {
        return ModTextures.buttonImage(BUTTONS, u, v, 16.0f, 16.0f);
    }

    public static UIImage buttonImage(ResourceLocation texture, float u, float v, float width, float height) {
        HashMap<Integer, CGPoint> offsets = new HashMap<Integer, CGPoint>();
        offsets.put(0, new CGPoint(0.0f, 0.0f));
        offsets.put(1, new CGPoint(1.0f, 0.0f));
        offsets.put(2, new CGPoint(2.0f, 0.0f));
        offsets.put(3, new CGPoint(3.0f, 0.0f));
        offsets.put(4, new CGPoint(3.0f, 0.0f));
        return UIImage.of(texture).uv(u, v).fixed(width, height).unzip(offsets::get).build();
    }

    public static UIImage iconImage(float u, float v, float width, float height, ResourceLocation resource) {
        HashMap<Integer, CGPoint> offsets = new HashMap<Integer, CGPoint>();
        offsets.put(0, new CGPoint(0.0f, 0.0f));
        offsets.put(1, new CGPoint(1.0f, 0.0f));
        offsets.put(4, new CGPoint(2.0f, 0.0f));
        return UIImage.of(resource).uv(u, v).fixed(width, height).unzip(offsets::get).build();
    }

    public static UIImage helpButtonImage() {
        HashMap<Integer, CGPoint> offsets = new HashMap<Integer, CGPoint>();
        offsets.put(0, new CGPoint(0.0f, 0.0f));
        offsets.put(1, new CGPoint(1.0f, 0.0f));
        return UIImage.of(HELP).fixed(7.0f, 8.0f).unzip(offsets::get).build();
    }

    public static UIImage tabButtonImage() {
        HashMap<Integer, CGPoint> offsets = new HashMap<Integer, CGPoint>();
        offsets.put(4, new CGPoint(0.0f, 0.0f));
        offsets.put(0, new CGPoint(0.0f, 1.0f));
        offsets.put(1, new CGPoint(0.0f, 2.0f));
        return UIImage.of(WIDGETS).uv(0.0f, 46.0f).fixed(200.0f, 20.0f).clip(2.0f, 3.0f, 2.0f, 2.0f).unzip(offsets::get).build();
    }
}

