/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.init.network;

import extensions.net.minecraft.network.chat.Component.TranslatableProvider;
import extensions.net.minecraft.world.entity.player.Player.SystemMessageProvider;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import moe.plushie.armourers_workshop.api.network.IClientPacketHandler;
import moe.plushie.armourers_workshop.core.network.CustomPacket;
import moe.plushie.armourers_workshop.init.ModConfig;
import moe.plushie.armourers_workshop.init.ModConfigSpec;
import moe.plushie.armourers_workshop.utils.StreamUtils;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.ITextComponent;

public class ExecuteCommandPacket
extends CustomPacket {
    private final Class<?> object;
    private final Mode mode;
    private final String key;
    private final Object value;

    public ExecuteCommandPacket(Class<?> object, String key, Object value, Mode mode) {
        this.object = object;
        this.mode = mode;
        this.key = key;
        this.value = value;
    }

    public ExecuteCommandPacket(PacketBuffer buffer) {
        this.object = this.readClass(buffer);
        this.mode = (Mode)buffer.func_179257_a(Mode.class);
        this.key = buffer.func_150789_c(Short.MAX_VALUE);
        this.value = this.readObject(buffer);
    }

    public static ExecuteCommandPacket set(Class<?> obj, String key, Object value) {
        return new ExecuteCommandPacket(obj, key, value, Mode.SET);
    }

    public static ExecuteCommandPacket get(Class<?> obj, String key) {
        return new ExecuteCommandPacket(obj, key, null, Mode.GET);
    }

    @Override
    public void encode(PacketBuffer buffer) {
        buffer.func_180714_a(this.object.getName());
        buffer.func_179249_a((Enum)this.mode);
        buffer.func_180714_a(this.key);
        this.writeObject(buffer, this.value);
    }

    @Override
    public void accept(IClientPacketHandler packetHandler, PlayerEntity player) {
        try {
            Object data = this.value;
            switch (this.mode) {
                case GET: {
                    Field field = this.object.getField(this.key);
                    data = field.get(this.object);
                    break;
                }
                case SET: {
                    Field field = this.object.getField(this.key);
                    field.set(this.object, data);
                    break;
                }
            }
            SystemMessageProvider.sendSystemMessage(player, (ITextComponent)TranslatableProvider.literal(ITextComponent.class, this.key + " = " + data));
            if (ModConfig.Client.class == this.object) {
                ModConfigSpec.CLIENT.save();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object readObject(PacketBuffer buffer) {
        Object object;
        if (this.mode != Mode.SET) {
            return null;
        }
        ByteBufInputStream inputStream = null;
        ObjectInputStream objectInputStream = null;
        try {
            inputStream = new ByteBufInputStream((ByteBuf)buffer);
            objectInputStream = new ObjectInputStream((InputStream)inputStream);
            object = objectInputStream.readObject();
        }
        catch (Exception exception) {
            Exception exception2;
            try {
                exception2 = exception;
            }
            catch (Throwable throwable) {
                StreamUtils.closeQuietly(new Closeable[]{objectInputStream, inputStream});
                throw throwable;
            }
            StreamUtils.closeQuietly(new Closeable[]{objectInputStream, inputStream});
            return exception2;
        }
        StreamUtils.closeQuietly(new Closeable[]{objectInputStream, inputStream});
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(PacketBuffer buffer, Object object) {
        if (this.mode != Mode.SET) {
            return;
        }
        ByteBufOutputStream outputStream = null;
        ObjectOutputStream objectOutputStream = null;
        try {
            outputStream = new ByteBufOutputStream((ByteBuf)buffer);
            objectOutputStream = new ObjectOutputStream((OutputStream)outputStream);
            objectOutputStream.writeObject(object);
        }
        catch (Exception exception1) {
            try {
                exception1.printStackTrace();
            }
            catch (Throwable throwable) {
                StreamUtils.closeQuietly(new Closeable[]{objectOutputStream, outputStream});
                throw throwable;
            }
            StreamUtils.closeQuietly(new Closeable[]{objectOutputStream, outputStream});
        }
        StreamUtils.closeQuietly(new Closeable[]{objectOutputStream, outputStream});
    }

    private Class<?> readClass(PacketBuffer buffer) {
        try {
            return Class.forName(buffer.func_150789_c(Short.MAX_VALUE));
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public static enum Mode {
        SET,
        GET;

    }
}

