/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.init.network;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.function.Consumer;
import moe.plushie.armourers_workshop.api.network.IClientPacketHandler;
import moe.plushie.armourers_workshop.core.network.CustomPacket;
import moe.plushie.armourers_workshop.init.platform.ReplayManager;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;

public class ServerReplayPacket
extends CustomPacket {
    private final Event event;
    private final PacketBuffer parameters;

    public ServerReplayPacket(Event event, Consumer<PacketBuffer> consumer) {
        this.event = event;
        if (consumer != null) {
            this.parameters = new PacketBuffer(Unpooled.buffer());
            consumer.accept(this.parameters);
        } else {
            this.parameters = null;
        }
    }

    public ServerReplayPacket(PacketBuffer buffer) {
        this.event = (Event)buffer.func_179257_a(Event.class);
        int size = buffer.readInt();
        this.parameters = size != 0 ? new PacketBuffer(buffer.readBytes(size)) : null;
    }

    @Override
    public void encode(PacketBuffer buffer) {
        buffer.func_179249_a((Enum)this.event);
        if (this.parameters != null) {
            buffer.writeInt(this.parameters.readableBytes());
            buffer.writeBytes((ByteBuf)this.parameters);
        } else {
            buffer.writeInt(0);
        }
    }

    @Override
    public void accept(IClientPacketHandler packetHandler, PlayerEntity player) {
        ReplayManager.accept(this);
    }

    public Event getEvent() {
        return this.event;
    }

    public PacketBuffer getParameters() {
        return this.parameters;
    }

    public static enum Event {
        START_RECORDING,
        STOP_RECORDING;

    }
}

