/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.init.platform;

import java.util.HashMap;
import moe.plushie.armourers_workshop.api.common.IContainerLevelAccess;
import moe.plushie.armourers_workshop.api.common.IPlayerDataSerializer;
import moe.plushie.armourers_workshop.api.registry.IRegistryKey;
import moe.plushie.armourers_workshop.init.ModLog;
import moe.plushie.armourers_workshop.init.ModPermissions;
import moe.plushie.armourers_workshop.utils.ObjectUtils;
import moe.plushie.armourers_workshop.utils.TranslateUtils;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import org.jetbrains.annotations.Nullable;

public class MenuManager {
    private static final HashMap<ContainerType<?>, MenuOpener<Object>> MENU_OPENERS = new HashMap();

    public static <T extends Container, V> void registerMenuOpener(ContainerType<T> menuType, IPlayerDataSerializer<V> serializer, MenuOpener<V> menuOpener) {
        MenuOpener<Object> safeMenuOpener = (player, title, value) -> {
            try {
                return menuOpener.openMenu(player, title, value);
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        };
        MENU_OPENERS.put(menuType, (MenuOpener)ObjectUtils.unsafeCast(safeMenuOpener));
    }

    public static <T extends Container, V> boolean openMenu(IRegistryKey<ContainerType<T>> menuType, PlayerEntity player, V value) {
        ContainerType menuType1 = (ContainerType)menuType.get();
        MenuOpener<Object> menuOpener = MENU_OPENERS.get(menuType1);
        if (menuOpener == null) {
            ModLog.warn("Trying to open container for unknown container type {}", menuType1);
            return false;
        }
        if (player instanceof ServerPlayerEntity) {
            IFormattableTextComponent title = TranslateUtils.title("inventory.armourers_workshop." + menuType.getRegistryName().func_110623_a(), new Object[0]);
            return menuOpener.openMenu((ServerPlayerEntity)player, (ITextComponent)title, value);
        }
        return false;
    }

    public static <C extends Container> ActionResultType openMenu(IRegistryKey<ContainerType<C>> type, TileEntity blockEntity, PlayerEntity player) {
        return MenuManager.openMenu(type, blockEntity, player, null);
    }

    public static <C extends Container> ActionResultType openMenu(IRegistryKey<ContainerType<C>> type, World level, BlockPos blockPos, PlayerEntity player) {
        return MenuManager.openMenu(type, level, blockPos, player, null);
    }

    public static <C extends Container> ActionResultType openMenu(IRegistryKey<ContainerType<C>> type, TileEntity blockEntity, PlayerEntity player, @Nullable CompoundNBT extraData) {
        if (blockEntity != null && blockEntity.func_145831_w() != null) {
            return MenuManager.openMenu(type, blockEntity.func_145831_w(), blockEntity.func_174877_v(), player, extraData);
        }
        return ActionResultType.FAIL;
    }

    public static <C extends Container> ActionResultType openMenu(IRegistryKey<ContainerType<C>> type, World level, BlockPos blockPos, PlayerEntity player, @Nullable CompoundNBT extraData) {
        if (level.func_201670_d()) {
            return ActionResultType.SUCCESS;
        }
        if (!ModPermissions.OPEN.accept(type, level, blockPos, player)) {
            return ActionResultType.FAIL;
        }
        if (MenuManager.openMenu(type, player, IContainerLevelAccess.create(level, blockPos, extraData))) {
            return ActionResultType.CONSUME;
        }
        return ActionResultType.FAIL;
    }

    @FunctionalInterface
    public static interface MenuOpener<V> {
        public boolean openMenu(ServerPlayerEntity var1, ITextComponent var2, V var3);
    }
}

