/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.init.platform;

import dev.architectury.injectables.annotations.ExpectPlatform;
import moe.plushie.armourers_workshop.api.common.IResultHandler;
import moe.plushie.armourers_workshop.core.capability.SkinWardrobe;
import moe.plushie.armourers_workshop.core.network.CustomPacket;
import moe.plushie.armourers_workshop.core.network.CustomReplyPacket;
import moe.plushie.armourers_workshop.init.platform.forge.NetworkManagerImpl;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;

public class NetworkManager {
    private static Impl IMPL;

    public static void init(String name, String version) {
        IMPL = NetworkManager.getInstance(name, version);
    }

    public static void sendToTracking(CustomPacket message, Entity entity) {
        IMPL.sendToTracking(message, entity);
    }

    public static void sendTo(CustomPacket message, ServerPlayerEntity player) {
        IMPL.sendTo(message, player);
    }

    public static void sendToServer(CustomPacket message) {
        IMPL.sendToServer(message);
    }

    public static void sendToAll(CustomPacket message) {
        IMPL.sendToAll(message);
    }

    public static void sendWardrobeTo(Entity entity, ServerPlayerEntity player) {
        SkinWardrobe wardrobe = SkinWardrobe.of(entity);
        if (wardrobe != null) {
            wardrobe.broadcast(player);
        }
    }

    public static <R> void sendTo(CustomReplyPacket<R> message, ServerPlayerEntity player, IResultHandler<R> handler) {
        CustomReplyPacket.Receiver.await(message, handler);
        NetworkManager.sendTo(message, player);
    }

    public static <R> void sendToServer(CustomReplyPacket<R> message, IResultHandler<R> handler) {
        CustomReplyPacket.Receiver.await(message, handler);
        NetworkManager.sendToServer(message);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Impl getInstance(String name, String version) {
        void var1_1;
        return NetworkManagerImpl.getInstance(name, (String)var1_1);
    }

    public static interface Impl {
        public void sendToTracking(CustomPacket var1, Entity var2);

        public void sendTo(CustomPacket var1, ServerPlayerEntity var2);

        public void sendToServer(CustomPacket var1);

        public void sendToAll(CustomPacket var1);
    }
}

