/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.init.platform.forge.builder;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import extensions.net.minecraft.core.Registry.LootFunction;
import java.util.Set;
import java.util.function.Supplier;
import moe.plushie.armourers_workshop.api.common.ILootConditionalFunction;
import moe.plushie.armourers_workshop.api.common.ILootFunction;
import moe.plushie.armourers_workshop.api.common.ILootFunctionType;
import moe.plushie.armourers_workshop.api.data.IDataPackObject;
import moe.plushie.armourers_workshop.api.registry.ILootFunctionBuilder;
import moe.plushie.armourers_workshop.api.registry.IRegistryKey;
import moe.plushie.armourers_workshop.compatibility.forge.AbstractForgeRegistryEntry;
import moe.plushie.armourers_workshop.init.ModConstants;
import moe.plushie.armourers_workshop.utils.ObjectUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.ILootSerializer;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootFunction;
import net.minecraft.loot.LootFunctionType;
import net.minecraft.loot.LootParameter;
import net.minecraft.loot.ValidationTracker;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;

public class LootFunctionBuilderImpl<T extends ILootFunction>
implements ILootFunctionBuilder<T> {
    private final Supplier<ILootFunction.Serializer<T>> serializer;

    public LootFunctionBuilderImpl(Supplier<ILootFunction.Serializer<T>> serializer) {
        this.serializer = serializer;
    }

    @Override
    public IRegistryKey<ILootFunctionType<T>> build(String name) {
        LootFunctionType[] type = new LootFunctionType[]{null};
        ResourceLocation registryName = ModConstants.key(name);
        type[0] = this.createType(() -> type[0], this.serializer.get());
        Proxy proxy = new Proxy(type[0]);
        LootFunction.registerItemLootFunctionFO(Registry.class, name, () -> type[0]);
        return new AbstractForgeRegistryEntry<ILootFunctionType<T>>(registryName, () -> proxy);
    }

    public LootFunctionType createType(Supplier<LootFunctionType> type, ILootFunction.Serializer<T> serializer) {
        if (serializer instanceof ILootConditionalFunction.Serializer) {
            ILootConditionalFunction.Serializer serializer2 = (ILootConditionalFunction.Serializer)ObjectUtils.unsafeCast(serializer);
            return new LootFunctionType(new ConditionalFunction.Factory(type, serializer2));
        }
        return new LootFunctionType(new NormalFunction.Factory<T>(type, serializer));
    }

    public static class Proxy<T extends ILootFunction>
    implements ILootFunctionType<T> {
        private final LootFunctionType type;

        public Proxy(LootFunctionType type) {
            this.type = type;
        }
    }

    public static class ConditionalFunction<T extends ILootConditionalFunction>
    extends net.minecraft.loot.LootFunction {
        private final T value;
        private final Supplier<LootFunctionType> type;

        protected ConditionalFunction(T value, ILootCondition[] args, Supplier<LootFunctionType> type) {
            super(args);
            this.type = type;
            this.value = value;
        }

        protected ItemStack func_215859_a(ItemStack arg, LootContext arg2) {
            return this.value.apply(arg, arg2);
        }

        public void func_225580_a_(ValidationTracker arg) {
            this.value.func_225580_a_(arg);
        }

        public Set<LootParameter<?>> func_215855_a() {
            return this.value.func_215855_a();
        }

        public LootFunctionType func_230425_b_() {
            return this.type.get();
        }

        public static class Factory<T extends ILootConditionalFunction>
        extends LootFunction.Serializer<ConditionalFunction<T>> {
            private final Supplier<LootFunctionType> type;
            private final ILootConditionalFunction.Serializer<T> serializer;

            public Factory(Supplier<LootFunctionType> type, ILootConditionalFunction.Serializer<T> serializer) {
                this.type = type;
                this.serializer = serializer;
            }

            public void serialize(JsonObject object, ConditionalFunction<T> arg, JsonSerializationContext context) {
                super.func_230424_a_(object, arg, context);
                this.serializer.serialize(IDataPackObject.of((JsonElement)object), ((ConditionalFunction)arg).value);
            }

            public ConditionalFunction<T> deserialize(JsonObject object, JsonDeserializationContext context, ILootCondition[] args) {
                ILootConditionalFunction value = (ILootConditionalFunction)this.serializer.deserialize(IDataPackObject.of((JsonElement)object));
                return new ConditionalFunction<ILootConditionalFunction>(value, args, this.type);
            }
        }
    }

    public static class NormalFunction<T extends ILootFunction>
    implements net.minecraft.loot.functions.ILootFunction {
        private final T value;
        private final Supplier<LootFunctionType> type;

        public NormalFunction(T value, Supplier<LootFunctionType> type) {
            this.type = type;
            this.value = value;
        }

        public LootFunctionType func_230425_b_() {
            return this.type.get();
        }

        public ItemStack apply(ItemStack itemStack, LootContext lootContext) {
            return this.value.apply(itemStack, lootContext);
        }

        public void func_225580_a_(ValidationTracker arg) {
            this.value.func_225580_a_(arg);
        }

        public Set<LootParameter<?>> func_215855_a() {
            return this.value.func_215855_a();
        }

        public static class Factory<T extends ILootFunction>
        implements ILootSerializer<NormalFunction<T>> {
            private final Supplier<LootFunctionType> type;
            private final ILootFunction.Serializer<T> serializer;

            public Factory(Supplier<LootFunctionType> type, ILootFunction.Serializer<T> serializer) {
                this.type = type;
                this.serializer = serializer;
            }

            public void serialize(JsonObject object, NormalFunction<T> arg, JsonSerializationContext context) {
                this.serializer.serialize(IDataPackObject.of((JsonElement)object), ((NormalFunction)arg).value);
            }

            public NormalFunction<T> deserialize(JsonObject object, JsonDeserializationContext context) {
                T value = this.serializer.deserialize(IDataPackObject.of((JsonElement)object));
                return new NormalFunction<T>(value, this.type);
            }
        }
    }
}

