/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.init.proxy;

import moe.plushie.armourers_workshop.api.common.IEntityType;
import moe.plushie.armourers_workshop.builder.other.WorldUpdater;
import moe.plushie.armourers_workshop.core.capability.SkinWardrobe;
import moe.plushie.armourers_workshop.core.data.DataDomain;
import moe.plushie.armourers_workshop.core.data.LocalDataService;
import moe.plushie.armourers_workshop.core.entity.EntityProfile;
import moe.plushie.armourers_workshop.core.entity.MannequinEntity;
import moe.plushie.armourers_workshop.core.entity.SeatEntity;
import moe.plushie.armourers_workshop.core.skin.SkinLoader;
import moe.plushie.armourers_workshop.core.skin.data.SkinServerType;
import moe.plushie.armourers_workshop.init.ModCommands;
import moe.plushie.armourers_workshop.init.ModContext;
import moe.plushie.armourers_workshop.init.ModEntityProfiles;
import moe.plushie.armourers_workshop.init.ModEntityTypes;
import moe.plushie.armourers_workshop.init.ModHolidays;
import moe.plushie.armourers_workshop.init.ModLog;
import moe.plushie.armourers_workshop.init.network.UpdateContextPacket;
import moe.plushie.armourers_workshop.init.platform.CommonNativeManager;
import moe.plushie.armourers_workshop.init.platform.DataPackManager;
import moe.plushie.armourers_workshop.init.platform.EnvironmentManager;
import moe.plushie.armourers_workshop.init.platform.NetworkManager;
import moe.plushie.armourers_workshop.init.platform.ReplayManager;
import moe.plushie.armourers_workshop.init.provider.CommonNativeProvider;
import moe.plushie.armourers_workshop.library.data.GlobalSkinLibrary;
import moe.plushie.armourers_workshop.library.data.SkinLibraryManager;
import moe.plushie.armourers_workshop.utils.BlockUtils;
import moe.plushie.armourers_workshop.utils.ObjectUtils;
import moe.plushie.armourers_workshop.utils.SkinUtils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class CommonProxy {
    public static void init() {
        CommonProxy.setup();
        CommonProxy.register(CommonNativeManager.getProvider());
    }

    private static void setup() {
        GlobalSkinLibrary library = GlobalSkinLibrary.getInstance();
        SkinLoader.getInstance().register(DataDomain.GLOBAL_SERVER, library::downloadSkin);
        SkinLoader.getInstance().register(DataDomain.GLOBAL_SERVER_PREVIEW, library::downloadPreviewSkin);
        ReplayManager.init();
    }

    private static void register(CommonNativeProvider registries) {
        registries.willRegisterCommand(ModCommands::init);
        registries.willRegisterCustomDataPack(DataPackManager::getLoader);
        registries.willRegisterEntityAttributes(registry -> {
            registry.register((EntityType<? extends LivingEntity>)((EntityType)((IEntityType)ModEntityTypes.MANNEQUIN.get()).get()), MannequinEntity.func_233639_cI_());
            registry.register((EntityType<? extends LivingEntity>)((EntityType)((IEntityType)ModEntityTypes.SEAT.get()).get()), SeatEntity.func_233639_cI_());
        });
        registries.willServerTick(WorldUpdater.getInstance()::tick);
        registries.willServerStart(server -> {
            ModLog.debug("hello", new Object[0]);
            LocalDataService.start(EnvironmentManager.getSkinDatabaseDirectory());
            SkinLoader.getInstance().prepare(SkinServerType.of(server));
        });
        registries.didServerStart(server -> {
            ModLog.debug("init", new Object[0]);
            ModContext.init(server);
            SkinLoader.getInstance().start();
        });
        registries.willServerStop(server -> {
            ModLog.debug("wait", new Object[0]);
            for (ServerWorld level : server.func_212370_w()) {
                WorldUpdater.getInstance().drain((World)level);
            }
            LocalDataService.stop();
            SkinLoader.getInstance().stop();
        });
        registries.didServerStop(server -> {
            ModLog.debug("bye", new Object[0]);
            ModContext.reset();
        });
        registries.willBlockPlace(BlockUtils::snapshot);
        registries.willBlockBreak(BlockUtils::snapshot);
        registries.willPlayerLogin(player -> {
            ModLog.debug("welcome back {}", player.func_195047_I_());
            ReplayManager.startRecording(player.func_184102_h(), player);
            ModHolidays.welcome(player);
        });
        registries.willPlayerLogout(player -> {
            ModLog.debug("good bye {}", player.func_195047_I_());
            SkinLibraryManager.getServer().remove((PlayerEntity)player);
            ReplayManager.stopRecording(player.func_184102_h(), player);
        });
        registries.willPlayerDrop(player -> {
            ModLog.debug("keep careful {}", player.func_195047_I_());
            SkinUtils.dropAll(player);
        });
        registries.willPlayerClone((oldPlayer, newPlayer) -> {
            ModLog.debug("woa {}", newPlayer.func_195047_I_());
            SkinWardrobe oldWardrobe = SkinWardrobe.of((Entity)oldPlayer);
            SkinWardrobe newWardrobe = SkinWardrobe.of((Entity)newPlayer);
            if (newWardrobe != null && oldWardrobe != null) {
                newWardrobe.deserializeNBT(oldWardrobe.serializeNBT());
                newWardrobe.broadcast();
            }
        });
        registries.didTackingEntity((entity, player) -> {
            EntityProfile entityProfile = ModEntityProfiles.getProfile(entity);
            if (entityProfile != null) {
                NetworkManager.sendWardrobeTo(entity, (ServerPlayerEntity)player);
            }
        });
        registries.didEntityJoin(entity -> {
            SkinUtils.copySkinFromOwner(entity);
            ServerPlayerEntity player = ObjectUtils.safeCast(entity, ServerPlayerEntity.class);
            if (player != null) {
                NetworkManager.sendTo(new UpdateContextPacket((PlayerEntity)player), player);
                NetworkManager.sendWardrobeTo((Entity)player, player);
            }
        });
    }
}

