/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.library.client.gui.panels;

import com.apple.library.coregraphics.CGRect;
import com.apple.library.foundation.NSMutableString;
import com.apple.library.uikit.UIButton;
import com.apple.library.uikit.UIColor;
import com.apple.library.uikit.UIComboBox;
import com.apple.library.uikit.UIComboItem;
import com.apple.library.uikit.UIControl;
import com.apple.library.uikit.UITextField;
import com.apple.library.uikit.UITextFieldDelegate;
import java.util.ArrayList;
import moe.plushie.armourers_workshop.api.skin.ISkinType;
import moe.plushie.armourers_workshop.core.client.gui.widget.SkinComboBox;
import moe.plushie.armourers_workshop.core.skin.SkinTypes;
import moe.plushie.armourers_workshop.init.ModTextures;
import moe.plushie.armourers_workshop.library.client.gui.GlobalSkinLibraryWindow;
import moe.plushie.armourers_workshop.library.client.gui.panels.AbstractLibraryPanel;
import moe.plushie.armourers_workshop.library.data.impl.SearchColumnType;
import moe.plushie.armourers_workshop.library.data.impl.SearchOrderType;
import moe.plushie.armourers_workshop.utils.TranslateUtils;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SearchBoxLibraryPanel
extends AbstractLibraryPanel
implements UITextFieldDelegate {
    private final SearchOrderType[] orderTypes = new SearchOrderType[]{SearchOrderType.DESC, SearchOrderType.ASC};
    private final SearchColumnType[] columnTypes = new SearchColumnType[]{SearchColumnType.DATE_CREATED, SearchColumnType.DATE_CREATED, SearchColumnType.NAME, SearchColumnType.NAME, SearchColumnType.DOWNLOADS, SearchColumnType.DOWNLOADS, SearchColumnType.RATING, SearchColumnType.RATING};
    private final UITextField searchText = new UITextField(CGRect.ZERO);
    private final UIComboBox sortList = new UIComboBox(CGRect.ZERO);
    private final SkinComboBox skinTypeList = new SkinComboBox(CGRect.ZERO);
    private final UIButton searchButton = new UIButton(CGRect.ZERO);
    private String keyword = "";
    private ISkinType skinType = SkinTypes.UNKNOWN;
    private SearchOrderType orderType = SearchOrderType.DESC;
    private SearchColumnType columnType = SearchColumnType.DATE_CREATED;

    public SearchBoxLibraryPanel() {
        super("inventory.armourers_workshop.skin-library-global.searchBox", GlobalSkinLibraryWindow.Page::hasSearch);
        this.setup();
    }

    private void setup() {
        CGRect rect = this.bounds();
        this.setupSearchField(new CGRect(5.0f, 3.0f, rect.width - 10.0f - 180.0f - 70.0f - 5.0f, 16.0f));
        this.setupSortView(new CGRect(rect.width - 180.0f - 70.0f - 5.0f, 3.0f, 90.0f, 16.0f));
        this.setupSkinListView(new CGRect(rect.width - 160.0f, 3.0f, 70.0f, 16.0f));
        this.searchButton.setFrame(new CGRect(rect.width - 84.0f, 3.0f, 80.0f, 16.0f));
        this.searchButton.setTitle(this.getDisplayText("search"), 0);
        this.searchButton.setTitleColor(UIColor.WHITE, 0);
        this.searchButton.setBackgroundImage(ModTextures.defaultButtonImage(), 7);
        this.searchButton.addTarget(this, UIControl.Event.MOUSE_LEFT_DOWN, SearchBoxLibraryPanel::search);
        this.searchButton.setAutoresizingMask(1);
        this.addSubview(this.searchButton);
    }

    private void setupSearchField(CGRect rect) {
        this.searchText.setFrame(rect);
        this.searchText.setPlaceholder(this.getDisplayText("typeToSearch"));
        this.searchText.setText(this.keyword);
        this.searchText.setMaxLength(255);
        this.searchText.setDelegate(this);
        this.searchText.setAutoresizingMask(2);
        this.addSubview(this.searchText);
    }

    private void setupSkinListView(CGRect rect) {
        this.skinTypeList.setFrame(rect);
        this.skinTypeList.reloadSkins(SkinTypes.values());
        this.skinTypeList.setSelectedSkin(this.skinType);
        this.skinTypeList.setAutoresizingMask(1);
        this.skinTypeList.setMaxRows(10);
        this.skinTypeList.addTarget(this, UIControl.Event.VALUE_CHANGED, (self, sender) -> {
            self.skinType = ((SkinComboBox)sender).selectedSkin();
            self.search(null);
        });
        this.addSubview(this.skinTypeList);
    }

    private void setupSortView(CGRect rect) {
        int selectedIndex = 0;
        ArrayList<SearchColumnType> columnTypes1 = new ArrayList<SearchColumnType>();
        ArrayList<UIComboItem> items = new ArrayList<UIComboItem>();
        for (SearchColumnType columnType : this.columnTypes) {
            SearchOrderType orderType = this.orderTypes[columnTypes1.size() % 2];
            NSMutableString title = new NSMutableString("");
            if (orderType == SearchOrderType.DESC) {
                title.append("\u2191 ");
            } else {
                title.append("\u2193 ");
            }
            title.append((ITextComponent)TranslateUtils.title("skin_search_column.armourers_workshop." + columnType.toString().toLowerCase(), new Object[0]));
            UIComboItem item = new UIComboItem(title);
            if (columnType == this.columnType && orderType == this.orderType) {
                selectedIndex = items.size();
            }
            items.add(item);
            columnTypes1.add(columnType);
        }
        this.sortList.setFrame(rect);
        this.sortList.setSelectedIndex(selectedIndex);
        this.sortList.setAutoresizingMask(1);
        this.sortList.reloadData(items);
        this.sortList.addTarget(this, UIControl.Event.VALUE_CHANGED, (self, sender) -> {
            int newValue = ((UIComboBox)sender).selectedIndex();
            self.orderType = this.orderTypes[newValue % 2];
            self.columnType = (SearchColumnType)((Object)((Object)columnTypes1.get(newValue)));
            self.search(sender);
        });
        this.addSubview(this.sortList);
    }

    @Override
    public boolean textFieldShouldReturn(UITextField textField) {
        this.search(textField);
        return true;
    }

    public void reloadData(String keyword, ISkinType skinType, SearchColumnType columnType, SearchOrderType orderType) {
        this.keyword = keyword;
        this.skinType = skinType;
        this.orderType = orderType;
        this.columnType = columnType;
        if (this.searchText == null) {
            return;
        }
        this.searchText.setText(keyword);
        this.sortList.setSelectedIndex(this.getSortIndex(columnType, orderType));
        this.skinTypeList.setSelectedSkin(skinType);
    }

    private int getSortIndex(SearchColumnType columnType, SearchOrderType orderType) {
        for (int i = 0; i < this.columnTypes.length; ++i) {
            if (columnType != this.columnTypes[i] || orderType != this.orderTypes[i % 2]) continue;
            return i;
        }
        return 0;
    }

    private void search(Object button) {
        this.keyword = this.searchText.text();
        this.router.showSkinList(this.keyword, this.skinType, this.columnType, this.orderType);
    }
}

