/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.library.client.gui.panels;

import com.apple.library.foundation.NSString;
import moe.plushie.armourers_workshop.api.common.IResultHandler;
import moe.plushie.armourers_workshop.api.skin.ISkinType;
import moe.plushie.armourers_workshop.library.client.gui.GlobalSkinLibraryWindow;
import moe.plushie.armourers_workshop.library.client.gui.panels.SearchResultsLibraryPanel;
import moe.plushie.armourers_workshop.library.data.GlobalSkinLibrary;
import moe.plushie.armourers_workshop.library.data.impl.SearchResult;
import moe.plushie.armourers_workshop.library.data.impl.ServerSkin;
import moe.plushie.armourers_workshop.library.data.impl.ServerUser;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class UserSkinsLibraryPanel
extends SearchResultsLibraryPanel {
    private ServerUser user;

    public UserSkinsLibraryPanel() {
        super("inventory.armourers_workshop.skin-library-global.searchResults", GlobalSkinLibraryWindow.Page.LIST_USER_SKINS::equals);
    }

    public void reloadData(ServerUser user) {
        this.clearResults();
        this.user = user;
        this.fetchPage(0);
    }

    @Override
    protected void showSkinInfo(ServerSkin sender) {
        this.router.showSkinDetail(sender, GlobalSkinLibraryWindow.Page.LIST_USER_SKINS);
    }

    @Override
    protected void doSearch(int pageIndex, int pageSize, ISkinType searchType, IResultHandler<SearchResult> handler) {
        GlobalSkinLibrary.getInstance().getUserSkinList(this.user.getId(), pageIndex, pageSize, searchType, handler);
    }

    @Override
    protected NSString getResultsTitle() {
        if (this.totalPages < 0) {
            return this.getDisplayText("label.searching");
        }
        if (this.totalPages == 0) {
            return this.getDisplayText("label.no_results");
        }
        String username = "unknown";
        if (this.user != null && !this.user.getName().isEmpty()) {
            username = this.user.getName();
        }
        return this.getDisplayText("user_results", username, this.currentPage + 1, this.totalPages, this.totalResults);
    }
}

