/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.library.client.gui.widget;

import com.apple.library.coregraphics.CGGraphicsContext;
import com.apple.library.coregraphics.CGPoint;
import com.apple.library.coregraphics.CGRect;
import com.apple.library.coregraphics.CGSize;
import com.apple.library.foundation.NSString;
import com.apple.library.uikit.UIEvent;
import com.apple.library.uikit.UIFont;
import com.apple.library.uikit.UIScreen;
import com.apple.library.uikit.UIView;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import moe.plushie.armourers_workshop.ArmourersWorkshop;
import moe.plushie.armourers_workshop.core.client.bake.BakedSkin;
import moe.plushie.armourers_workshop.core.client.bake.SkinBakery;
import moe.plushie.armourers_workshop.core.client.render.ExtendedItemRenderer;
import moe.plushie.armourers_workshop.core.data.ticket.Ticket;
import moe.plushie.armourers_workshop.core.skin.Skin;
import moe.plushie.armourers_workshop.init.ModTextures;
import moe.plushie.armourers_workshop.library.data.impl.ServerSkin;
import moe.plushie.armourers_workshop.utils.MathUtils;
import moe.plushie.armourers_workshop.utils.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SkinItemList
extends UIView {
    protected Insets contentInset = new Insets(0, 0, 0, 0);
    protected CGSize itemSize = new CGSize(48.0f, 48.0f);
    protected UIFont font = UIFont.systemFont();
    protected Consumer<ServerSkin> itemSelector;
    protected ArrayList<ServerSkin> entries = new ArrayList();
    protected Ticket loadTicket = Ticket.list();
    protected int minimumLineSpacing = 1;
    protected int minimumInteritemSpacing = 1;
    protected int backgroundColor = -1071504862;
    private int rowCount;
    private int colCount;
    private int totalCount;
    private int hoveredIndex = -1;
    private boolean showsName = true;

    public SkinItemList(CGRect frame) {
        super(frame);
        this.reloadData();
    }

    @Override
    public void mouseDown(UIEvent event) {
        super.mouseDown(event);
        if (this.itemSelector == null) {
            return;
        }
        int index = this.indexAtPoint(event.locationInView(this));
        if (index >= 0 && index < this.entries.size()) {
            this.itemSelector.accept(this.entries.get(index));
        }
    }

    @Override
    public void mouseEntered(UIEvent event) {
        super.mouseEntered(event);
        this.applyHovered(event);
    }

    @Override
    public void mouseMoved(UIEvent event) {
        super.mouseMoved(event);
        this.applyHovered(event);
    }

    @Override
    public void mouseExited(UIEvent event) {
        super.mouseExited(event);
        this.hoveredIndex = -1;
    }

    @Override
    public void removeFromSuperview() {
        super.removeFromSuperview();
        this.loadTicket.invalidate();
    }

    public ArrayList<ServerSkin> getEntries() {
        return this.entries;
    }

    public void setEntries(ArrayList<ServerSkin> entries) {
        this.loadTicket.invalidate();
        this.entries = new ArrayList<ServerSkin>(entries);
    }

    public void reloadData() {
        float boxW = this.getInnerWidth() + (float)this.minimumInteritemSpacing;
        float boxH = this.getInnerHeight() + (float)this.minimumLineSpacing;
        this.colCount = Math.max(1, (int)Math.floor(boxW / (this.itemSize.width + (float)this.minimumInteritemSpacing)));
        this.rowCount = Math.max(1, (int)Math.floor(boxH / (this.itemSize.height + (float)this.minimumLineSpacing)));
        this.totalCount = this.rowCount * this.colCount;
    }

    @Override
    public void render(CGPoint point, CGGraphicsContext context) {
        int i;
        super.render(point, context);
        CGRect rect = this.bounds();
        float x = rect.x;
        float y = rect.y;
        float width = rect.width;
        float height = rect.height;
        if ((this.backgroundColor & 0xFF000000) != 0) {
            context.fillRect(x, y, x + width, y + height, this.backgroundColor);
        }
        IRenderTypeBuffer.Impl buffers = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
        for (i = 0; i < this.totalCount; ++i) {
            this.renderItem(context, i, false, buffers);
        }
        buffers.func_228461_a_();
        for (i = 0; i < this.totalCount; ++i) {
            this.renderItem(context, i, true, buffers);
        }
    }

    public void renderItem(CGGraphicsContext context, int index, boolean allowsHovered, IRenderTypeBuffer.Impl buffers) {
        boolean isHovered;
        if (index >= this.entries.size()) {
            return;
        }
        ServerSkin entry = this.entries.get(index);
        int row = index / this.colCount;
        int col = index % this.colCount;
        float ix = (this.itemSize.width + (float)this.minimumInteritemSpacing) * (float)col;
        float iy = (this.itemSize.height + (float)this.minimumLineSpacing) * (float)row;
        float iw = this.itemSize.width;
        float ih = this.itemSize.height;
        boolean bl = isHovered = index == this.hoveredIndex;
        if (isHovered != allowsHovered) {
            return;
        }
        CGRect clipBox = UIScreen.convertRectFromView(new CGRect(ix, iy, iw, ih), this);
        if (!RenderSystem.inScissorRect(clipBox)) {
            return;
        }
        this.renderItemBackground(ix, iy, iw, ih, isHovered, entry, context);
        this.renderItemContent(ix, iy, iw, ih, isHovered, entry, (IRenderTypeBuffer)buffers, context);
        if (isHovered) {
            context.addClipRect(clipBox.insetBy(1.0f, 1.0f, 1.0f, 1.0f));
            buffers.func_228461_a_();
            context.removeClipRect();
        }
    }

    public void renderItemContent(float x, float y, float width, float height, boolean isHovered, ServerSkin entry, IRenderTypeBuffer buffers, CGGraphicsContext context) {
        ResourceLocation texture;
        BakedSkin bakedSkin = SkinBakery.getInstance().loadSkin(entry.getDescriptor(), this.loadTicket);
        if (bakedSkin == null) {
            int speed = 60;
            int frames = 18;
            int frame = (int)(System.currentTimeMillis() / (long)speed % (long)frames);
            int u = MathUtils.floor((float)frame / 9.0f);
            int v = frame - u * 9;
            context.drawResizableImage(ModTextures.SKIN_PANEL, x + 8.0f, y + 8.0f, width - 16.0f, height - 16.0f, u * 28, v * 28, 27.0f, 27.0f, 256.0f, 256.0f);
            return;
        }
        Skin skin = bakedSkin.getSkin();
        if (this.showsName) {
            NSString name = new NSString(entry.getName());
            List<NSString> properties = name.split(width - 2.0f, this.font);
            float iy = y + height - (float)properties.size() * this.font.lineHeight() - 2.0f;
            context.drawText(properties, x + 1.0f, iy, -1118482, false, this.font, 0.0f);
        }
        if ((texture = ArmourersWorkshop.getItemIcon(skin.getType())) != null) {
            context.drawResizableImage(texture, x + 1.0f, y + 1.0f, width / 4.0f, height / 4.0f, 0.0f, 0.0f, 16.0f, 16.0f, 16.0f, 16.0f);
        }
        float dx = x + width / 2.0f;
        float dy = y + height / 2.0f;
        float dw = width;
        float dh = height;
        if (isHovered) {
            dw *= 1.5f;
            dh *= 1.5f;
        }
        float tx = dx - dw / 2.0f;
        float ty = dy - dh / 2.0f;
        ExtendedItemRenderer.renderSkinInBox(bakedSkin, tx, ty, 100.0f, dw, dh, 20.0f, 45.0f, 0.0f, context.state().ctm(), buffers);
    }

    public void renderItemBackground(float x, float y, float width, float height, boolean isHovered, ServerSkin entry, CGGraphicsContext context) {
        int backgroundColor = 0x22AAAAAA;
        int borderColor = 0x22FFFFFF;
        if (isHovered) {
            backgroundColor = -1065912559;
            borderColor = -863467503;
        }
        context.fillRect(x, y, x + width, y + height, backgroundColor);
        context.fillRect(x, y + 1.0f, x + 1.0f, y + height, borderColor);
        context.fillRect(x, y, x + width - 1.0f, y + 1.0f, borderColor);
        context.fillRect(x + 1.0f, y + height - 1.0f, x + width, y + height, borderColor);
        context.fillRect(x + width - 1.0f, y, x + width, y + height - 1.0f, borderColor);
        RenderSystem.enableAlphaTest();
    }

    public CGSize getItemSize() {
        return this.itemSize;
    }

    public void setItemSize(CGSize itemSize) {
        this.itemSize = itemSize;
    }

    public int getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(int backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public boolean showsName() {
        return this.showsName;
    }

    public void setShowsName(boolean showsName) {
        this.showsName = showsName;
    }

    public Consumer<ServerSkin> getItemSelector() {
        return this.itemSelector;
    }

    public void setItemSelector(Consumer<ServerSkin> itemSelector) {
        this.itemSelector = itemSelector;
    }

    public int getTotalCount() {
        return this.totalCount;
    }

    private float getInnerWidth() {
        return this.bounds().width - (float)this.contentInset.left - (float)this.contentInset.right;
    }

    private float getInnerHeight() {
        return this.bounds().height - (float)this.contentInset.top - (float)this.contentInset.bottom;
    }

    private void applyHovered(UIEvent event) {
        this.hoveredIndex = this.indexAtPoint(event.locationInView(this));
    }

    private int indexAtPoint(CGPoint point) {
        int col = (int)(point.x / (this.itemSize.width + (float)this.minimumInteritemSpacing));
        int row = (int)(point.y / (this.itemSize.height + (float)this.minimumLineSpacing));
        if (col < 0 || row < 0 || col >= this.colCount || row >= this.rowCount) {
            return -1;
        }
        return row * this.colCount + col;
    }
}

