/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.library.data;

import java.util.ArrayList;
import java.util.Collection;
import moe.plushie.armourers_workshop.api.library.ISkinLibrary;
import moe.plushie.armourers_workshop.api.skin.ISkinFileHeader;
import moe.plushie.armourers_workshop.api.skin.ISkinType;
import moe.plushie.armourers_workshop.api.skin.property.ISkinProperties;
import moe.plushie.armourers_workshop.core.data.DataDomain;
import moe.plushie.armourers_workshop.core.skin.SkinTypes;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperty;
import moe.plushie.armourers_workshop.utils.ObjectUtils;
import moe.plushie.armourers_workshop.utils.SkinFileUtils;
import org.apache.logging.log4j.util.Strings;

public class SkinLibraryFile
implements Comparable<SkinLibraryFile>,
ISkinLibrary.Entry {
    protected final String name;
    protected final String path;
    protected final DataDomain domain;
    protected final ISkinFileHeader header;
    protected final boolean isDirectory;
    protected final boolean isPrivateDirectory;
    private Collection<String> searchableContentList;

    public SkinLibraryFile(DataDomain domain, String name, String path) {
        this.name = name;
        this.path = path;
        this.domain = domain;
        this.header = null;
        this.isDirectory = true;
        this.isPrivateDirectory = domain.equals((Object)DataDomain.DEDICATED_SERVER) && path.startsWith("/private");
    }

    public SkinLibraryFile(DataDomain domain, String name, String path, ISkinFileHeader header) {
        this.name = name;
        this.path = SkinFileUtils.normalize(path, true);
        this.domain = domain;
        this.header = header;
        this.isDirectory = false;
        this.isPrivateDirectory = false;
    }

    public boolean matches(String keywords, ISkinType skinType) {
        if (skinType != SkinTypes.UNKNOWN && skinType != this.getSkinType()) {
            return false;
        }
        if (keywords != null && !keywords.isEmpty()) {
            return this.matchesInContentList(keywords);
        }
        return true;
    }

    public boolean isSameFile(SkinLibraryFile other) {
        return this.name.equals(other.name) && this.path.equals(other.path) && this.domain.equals((Object)other.domain);
    }

    @Override
    public int compareTo(SkinLibraryFile o) {
        if (this.isDirectory & !o.isDirectory) {
            return this.path.compareToIgnoreCase(o.path) - 1000000;
        }
        if (!this.isDirectory & o.isDirectory) {
            return this.path.compareToIgnoreCase(o.path) + 1000000;
        }
        return this.path.compareToIgnoreCase(o.path);
    }

    public String toString() {
        return this.domain.normalize(this.path);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getNamespace() {
        return this.domain.namespace();
    }

    @Override
    public String getPath() {
        return this.path;
    }

    public int getLastModified() {
        if (this.header != null) {
            return this.header.getLastModified();
        }
        return 0;
    }

    public int getSkinVersion() {
        if (this.header != null) {
            return this.header.getVersion();
        }
        return 0;
    }

    @Override
    public String getSkinIdentifier() {
        return this.getNamespace() + ":" + this.getPath();
    }

    @Override
    public ISkinType getSkinType() {
        if (this.header != null) {
            return this.header.getType();
        }
        return null;
    }

    public ISkinProperties getSkinProperties() {
        if (this.header != null) {
            return this.header.getProperties();
        }
        return null;
    }

    @Override
    public boolean isDirectory() {
        return this.isDirectory;
    }

    @Override
    public boolean isPrivateDirectory() {
        return this.isPrivateDirectory;
    }

    public boolean isChildDirectory(String rootPath) {
        int length = rootPath.length();
        return length < this.path.length() && this.path.startsWith(rootPath) && this.path.indexOf(47, length) < 0;
    }

    private boolean matchesInContentList(String keyword) {
        int index = 0;
        int length = keyword.length();
        while (index < length) {
            int lastIndex = index;
            for (String content : this.getSearchableContentList()) {
                int searchIndex = -1;
                for (int offset = index; offset < length; ++offset) {
                    int ch = keyword.codePointAt(offset);
                    if (Character.isSpaceChar(ch)) {
                        index = offset + 1;
                        break;
                    }
                    if ((searchIndex = content.indexOf(ch, searchIndex + 1)) < 0) break;
                }
                if (searchIndex > 0) {
                    return true;
                }
                if (lastIndex == index) continue;
                break;
            }
            if (lastIndex != index) continue;
            return false;
        }
        return true;
    }

    private Collection<String> getSearchableContentList() {
        if (this.searchableContentList != null) {
            return this.searchableContentList;
        }
        ArrayList<String> values = new ArrayList<String>();
        values.add(SkinFileUtils.removeExtension(this.path));
        ISkinProperties properties = this.getSkinProperties();
        if (properties != null) {
            values.add(properties.get(SkinProperty.ALL_CUSTOM_NAME));
            values.add(properties.get(SkinProperty.ALL_AUTHOR_NAME));
            values.add(properties.get(SkinProperty.ALL_FLAVOUR_TEXT));
        }
        this.searchableContentList = ObjectUtils.compactMap(values, s -> {
            if (Strings.isNotBlank((String)s)) {
                return s.toLowerCase();
            }
            return null;
        });
        return this.searchableContentList;
    }
}

