/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.library.data.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.function.Supplier;
import moe.plushie.armourers_workshop.init.ModLog;
import moe.plushie.armourers_workshop.utils.StreamUtils;

public class MinecraftAuth {
    private static final String JOIN_URL = "https://sessionserver.mojang.com/session/minecraft/join";
    private static final Object MC_AUTH_LOCK = new Object();
    private static long lastAuthTime;
    private static Supplier<String> USER_ID_PROVIDER;
    private static Supplier<String> USER_ACCESS_TOKEN_PROVIDER;

    public static void init(Supplier<String> idProvider, Supplier<String> accessTokenProvider) {
        USER_ID_PROVIDER = idProvider;
        USER_ACCESS_TOKEN_PROVIDER = accessTokenProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkAndRefeshAuth(String serverId) {
        Object object = MC_AUTH_LOCK;
        synchronized (object) {
            if (lastAuthTime + 30000L > System.currentTimeMillis()) {
                ModLog.debug("skipping mc auth", new Object[0]);
                return true;
            }
            if (USER_ID_PROVIDER == null || USER_ACCESS_TOKEN_PROVIDER == null) {
                ModLog.debug("pls call init before!!!", new Object[0]);
                return false;
            }
            ModLog.info("MC Auth start", new Object[0]);
            Object conn = null;
            String data = "{\"accessToken\":\"" + USER_ACCESS_TOKEN_PROVIDER.get() + "\", \"serverId\":\"" + serverId + "\", \"selectedProfile\":\"" + USER_ID_PROVIDER.get() + "\"}";
            try {
                String result = MinecraftAuth.performPostRequest(new URL(JOIN_URL), data, "application/json");
                lastAuthTime = System.currentTimeMillis();
                return true;
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String performPostRequest(URL url, String post, String contentType) throws IOException {
        String string;
        HttpURLConnection connection = MinecraftAuth.createUrlConnection(url);
        byte[] postAsBytes = post.getBytes(StandardCharsets.UTF_8);
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Content-Type", contentType + "; charset=utf-8");
        connection.setRequestProperty("Content-Length", "" + postAsBytes.length);
        connection.setDoOutput(true);
        OutputStream outputStream = null;
        try {
            outputStream = connection.getOutputStream();
            outputStream.write(postAsBytes);
        }
        catch (Throwable throwable) {
            StreamUtils.closeQuietly(outputStream);
            throw throwable;
        }
        StreamUtils.closeQuietly(outputStream);
        InputStream inputStream = null;
        try {
            inputStream = connection.getInputStream();
            string = StreamUtils.toString(inputStream, StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            block7: {
                String string2;
                try {
                    StreamUtils.closeQuietly(inputStream);
                    inputStream = connection.getErrorStream();
                    if (inputStream == null) break block7;
                    string2 = StreamUtils.toString(inputStream, StandardCharsets.UTF_8);
                }
                catch (Throwable throwable) {
                    StreamUtils.closeQuietly(inputStream);
                    throw throwable;
                }
                StreamUtils.closeQuietly(inputStream);
                return string2;
            }
            throw e;
        }
        StreamUtils.closeQuietly(inputStream);
        return string;
    }

    private static HttpURLConnection createUrlConnection(URL url) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setConnectTimeout(15000);
        connection.setReadTimeout(15000);
        connection.setUseCaches(false);
        return connection;
    }
}

