/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.library.data.impl;

import java.util.Objects;
import java.util.UUID;
import moe.plushie.armourers_workshop.api.data.IDataPackObject;
import moe.plushie.armourers_workshop.library.data.impl.ServerPermission;
import moe.plushie.armourers_workshop.library.data.impl.ServerPermissions;
import moe.plushie.armourers_workshop.library.data.impl.ServerToken;

public class ServerUser {
    private final String id;
    private final UUID uuid;
    private final String name;
    private final ServerPermissions permissions;
    private ServerToken accessToken;

    public ServerUser(UUID uuid, String name) {
        this(null, uuid, name, ServerPermissions.NO_LOGIN);
    }

    public ServerUser(String id, UUID uuid, String name, ServerPermissions permissions) {
        this.id = id;
        this.uuid = uuid;
        this.name = name;
        this.permissions = permissions;
    }

    public static ServerUser fromJSON(IDataPackObject object) {
        String id = object.get("id").stringValue();
        UUID uuid = UUID.fromString(object.get("uuid").stringValue());
        String name = object.get("username").stringValue();
        ServerPermissions permissions = ServerPermissions.byId(object.get("permission_group_id").intValue());
        return new ServerUser(id, uuid, name, permissions);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServerUser user = (ServerUser)o;
        return this.id == user.id;
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public boolean hasPermission(ServerPermission action) {
        return this.permissions.hasPermission(action);
    }

    public boolean isMember() {
        return this.id != null;
    }

    public boolean isAuthenticated() {
        return this.accessToken != null && this.accessToken.isValid();
    }

    public String getId() {
        return this.id;
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public String getName() {
        return this.name;
    }

    public ServerPermissions getPermissions() {
        return this.permissions;
    }

    public void setAccessToken(ServerToken accessToken) {
        this.accessToken = accessToken;
    }

    public ServerToken getAccessToken() {
        return this.accessToken;
    }
}

