/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.library.menu;

import extensions.net.minecraft.world.item.ItemStack.ABI;
import moe.plushie.armourers_workshop.api.common.IContainerLevelAccess;
import moe.plushie.armourers_workshop.core.item.SkinItem;
import moe.plushie.armourers_workshop.core.menu.AbstractBlockContainerMenu;
import moe.plushie.armourers_workshop.core.skin.SkinDescriptor;
import moe.plushie.armourers_workshop.init.ModItems;
import moe.plushie.armourers_workshop.library.data.SkinLibraryManager;
import net.minecraft.block.Block;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class SkinLibraryMenu
extends AbstractBlockContainerMenu {
    protected final IInventory inventory = this.getBlockInventory();
    protected final PlayerInventory playerInventory;
    public int inventoryWidth = 162;
    public int inventoryHeight = 76;
    private int libraryVersion = 0;

    public SkinLibraryMenu(ContainerType<?> menuType, Block block, int containerId, PlayerInventory playerInventory, IContainerLevelAccess access) {
        super(menuType, block, containerId, access);
        this.playerInventory = playerInventory;
        this.reload(0, 0, 240, 240);
    }

    public void reload(int x, int y, int width, int height) {
        int inventoryX = 6;
        int inventoryY = height - this.inventoryHeight - 4;
        this.field_75151_b.clear();
        this.addPlayerSlots((IInventory)this.playerInventory, inventoryX, inventoryY);
        this.addInputSlot(this.inventory, 0, inventoryX, inventoryY - 27);
        this.addOutputSlot(this.inventory, 1, inventoryX + this.inventoryWidth - 22, inventoryY - 27);
    }

    public void func_75142_b() {
        SkinLibraryManager.Server server;
        super.func_75142_b();
        if (this.playerInventory.field_70458_d instanceof ServerPlayerEntity && this.libraryVersion != (server = SkinLibraryManager.getServer()).getVersion()) {
            server.sendTo((ServerPlayerEntity)this.playerInventory.field_70458_d);
            this.libraryVersion = server.getVersion();
        }
    }

    @Override
    public ItemStack func_82846_b(PlayerEntity player, int index) {
        return this.quickMoveStack(player, index, this.field_75151_b.size() - 1);
    }

    protected void addInputSlot(IInventory inventory, int slot, int x, int y) {
        this.func_75146_a(new Slot(inventory, slot, x, y){

            public boolean func_75214_a(ItemStack itemStack) {
                return ABI.is(itemStack, (Item)ModItems.SKIN_TEMPLATE.get()) || !SkinDescriptor.of(itemStack).isEmpty();
            }
        });
    }

    protected void addOutputSlot(IInventory inventory, int slot, int x, int y) {
        this.func_75146_a(new Slot(inventory, slot, x, y){

            public boolean func_75214_a(ItemStack itemStack) {
                return false;
            }
        });
    }

    public ItemStack getInputStack() {
        return this.inventory.func_70301_a(0);
    }

    public ItemStack getOutputStack() {
        return this.inventory.func_70301_a(1);
    }

    public PlayerEntity getPlayer() {
        return this.playerInventory.field_70458_d;
    }

    public boolean shouldSaveStack() {
        return this.getOutputStack().func_190926_b();
    }

    public boolean shouldLoadStack() {
        return this.getOutputStack().func_190926_b() && !this.getInputStack().func_190926_b() && ABI.is(this.getInputStack(), (Item)ModItems.SKIN_TEMPLATE.get());
    }

    public void crafting(SkinDescriptor descriptor) {
        boolean consume = true;
        ItemStack itemStack = this.getInputStack();
        ItemStack newItemStack = itemStack.func_77946_l();
        if (descriptor != null) {
            newItemStack = SkinItem.replace(itemStack.func_77946_l(), descriptor);
            consume = ABI.is(itemStack, (Item)ModItems.SKIN_TEMPLATE.get());
        }
        this.inventory.func_70299_a(1, newItemStack);
        if (consume) {
            itemStack.func_190918_g(1);
        }
    }
}

