/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.library.network;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import moe.plushie.armourers_workshop.api.network.IClientPacketHandler;
import moe.plushie.armourers_workshop.api.network.IServerPacketHandler;
import moe.plushie.armourers_workshop.core.data.DataDomain;
import moe.plushie.armourers_workshop.core.network.CustomPacket;
import moe.plushie.armourers_workshop.core.skin.Skin;
import moe.plushie.armourers_workshop.core.skin.SkinDescriptor;
import moe.plushie.armourers_workshop.core.skin.SkinLoader;
import moe.plushie.armourers_workshop.init.ModLog;
import moe.plushie.armourers_workshop.init.ModPermissions;
import moe.plushie.armourers_workshop.init.platform.NetworkManager;
import moe.plushie.armourers_workshop.library.data.SkinLibrary;
import moe.plushie.armourers_workshop.library.data.SkinLibraryManager;
import moe.plushie.armourers_workshop.library.menu.SkinLibraryMenu;
import moe.plushie.armourers_workshop.utils.SkinFileUtils;
import moe.plushie.armourers_workshop.utils.SkinIOUtils;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;

public class SaveSkinPacket
extends CustomPacket {
    protected final String source;
    protected final String destination;
    protected Skin skin;
    protected Mode mode;

    public SaveSkinPacket(String source, String destination) {
        boolean shouldUpload;
        this.source = source;
        this.destination = destination;
        this.mode = Mode.NONE;
        boolean bl = shouldUpload = DataDomain.isLocal(source) && !DataDomain.isLocal(destination);
        if (shouldUpload) {
            this.mode = Mode.UPLOAD;
            if (SkinLibraryManager.getClient().shouldUploadFile(null)) {
                this.skin = SkinLoader.getInstance().loadSkin(source);
            }
        }
    }

    public SaveSkinPacket(PacketBuffer buffer) {
        this.source = this.decodeResourceLocation(buffer);
        this.destination = this.decodeResourceLocation(buffer);
        this.mode = (Mode)buffer.func_179257_a(Mode.class);
        switch (this.mode) {
            case UPLOAD: {
                boolean shouldUpload;
                boolean bl = shouldUpload = DataDomain.isLocal(this.source) && !DataDomain.isLocal(this.destination);
                if (!shouldUpload || !SkinLibraryManager.getServer().shouldUploadFile(null)) break;
                this.skin = this.decodeSkin(buffer);
                break;
            }
            case DOWNLOAD: {
                boolean shouldDownload;
                boolean bl = shouldDownload = !DataDomain.isLocal(this.source) && DataDomain.isLocal(this.destination);
                if (!shouldDownload) break;
                this.skin = this.decodeSkin(buffer);
                break;
            }
        }
    }

    @Override
    public void encode(PacketBuffer buffer) {
        buffer.func_180714_a(this.source);
        buffer.func_180714_a(this.destination);
        this.encodeSkin(buffer);
    }

    @Override
    public void accept(IClientPacketHandler packetHandler, PlayerEntity player) {
        if (!DataDomain.isLocal(this.destination)) {
            return;
        }
        Skin skin = this.getSkin();
        if (skin == null) {
            this.abort(player, "load", "missing from skin loader");
            return;
        }
        SkinLibrary library = SkinLibraryManager.getClient().getLocalSkinLibrary();
        library.save(this.getPath(this.destination), skin);
    }

    @Override
    public void accept(IServerPacketHandler packetHandler, ServerPlayerEntity player) {
        if (!(this.isAuthorized(this.source, (PlayerEntity)player) && this.isAuthorized(this.destination, (PlayerEntity)player) && player.field_71070_bA instanceof SkinLibraryMenu)) {
            this.abort((PlayerEntity)player, "unauthorized", "user status is incorrect or the path is invalid");
            return;
        }
        SkinLibraryManager.Server server = SkinLibraryManager.getServer();
        if (DataDomain.isLocal(this.source) && !server.shouldUploadFile((PlayerEntity)player)) {
            this.abort((PlayerEntity)player, "upload", "uploading prohibited in the config file");
            return;
        }
        SkinLibraryMenu container = (SkinLibraryMenu)player.field_71070_bA;
        if (DataDomain.isDatabase(this.destination)) {
            if (!ModPermissions.SKIN_LIBRARY_SKIN_LOAD.accept((PlayerEntity)player)) {
                this.abort((PlayerEntity)player, "load", "load prohibited in the config file");
                return;
            }
            Skin skin = this.getSkin();
            if (skin == null) {
                this.abort((PlayerEntity)player, "load", "missing from skin loader");
                return;
            }
            if (container.shouldLoadStack()) {
                String identifier = SkinLoader.getInstance().saveSkin(this.source, skin);
                container.crafting(new SkinDescriptor(identifier, skin.getType()));
                this.accept((PlayerEntity)player, "load");
            }
            return;
        }
        if (DataDomain.isServer(this.destination)) {
            if (!ModPermissions.SKIN_LIBRARY_SKIN_SAVE.accept((PlayerEntity)player)) {
                this.abort((PlayerEntity)player, "save", "save prohibited in the config file");
                return;
            }
            Skin skin = this.getSkin();
            if (skin == null) {
                this.abort((PlayerEntity)player, "save", "missing from skin loader");
                return;
            }
            if (container.shouldSaveStack()) {
                server.getLibrary().save(this.getPath(this.destination), skin);
                container.crafting(null);
                this.accept((PlayerEntity)player, "save");
            }
            return;
        }
        if (DataDomain.isLocal(this.destination)) {
            if (!DataDomain.isLocal(this.source) && !server.shouldDownloadFile((PlayerEntity)player)) {
                this.abort((PlayerEntity)player, "download", "downloading prohibited in the config file");
                return;
            }
            if (!DataDomain.isLocal(this.source)) {
                this.skin = this.getSkin();
                this.mode = Mode.DOWNLOAD;
            }
            if (container.shouldSaveStack()) {
                NetworkManager.sendTo(this, player);
                container.crafting(null);
                this.accept((PlayerEntity)player, "download");
            }
            return;
        }
        this.abort((PlayerEntity)player, "unknown", "dangerous operation");
    }

    public boolean isReady(PlayerEntity player) {
        SkinLibraryManager.Client libraryManager = SkinLibraryManager.getClient();
        if (DataDomain.isLocal(this.source) && !DataDomain.isLocal(this.destination) && !((SkinLibraryManager)libraryManager).shouldUploadFile(player)) {
            return false;
        }
        if (!DataDomain.isLocal(this.source) && DataDomain.isLocal(this.destination) && !((SkinLibraryManager)libraryManager).shouldDownloadFile(player)) {
            return false;
        }
        return this.mode == Mode.NONE || this.skin != null;
    }

    private void accept(PlayerEntity player, String op) {
        String playerName = player.func_195047_I_();
        ModLog.info("accept {} request of the '{}', from: '{}', to: '{}'", op, playerName, this.source, this.destination);
    }

    private void abort(PlayerEntity player, String op, String reason) {
        String playerName = player.func_195047_I_();
        ModLog.info("abort {} request of the '{}', reason: '{}', from: '{}', to: '{}'", op, playerName, reason, this.source, this.destination);
    }

    private void encodeSkin(PacketBuffer buffer) {
        if (this.skin == null) {
            buffer.func_179249_a((Enum)Mode.NONE);
            return;
        }
        try {
            buffer.func_179249_a((Enum)this.mode);
            GZIPOutputStream stream = new GZIPOutputStream((OutputStream)new ByteBufOutputStream((ByteBuf)buffer));
            SkinIOUtils.saveSkinToStream(stream, this.skin);
            stream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Skin decodeSkin(PacketBuffer buffer) {
        Skin skin = null;
        try {
            GZIPInputStream stream = new GZIPInputStream((InputStream)new ByteBufInputStream((ByteBuf)buffer));
            skin = SkinIOUtils.loadSkinFromStream(stream);
            stream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return skin;
    }

    private String decodeResourceLocation(PacketBuffer buffer) {
        String location = buffer.func_150789_c(Short.MAX_VALUE);
        int index = location.indexOf(58);
        if (index < 0) {
            return "";
        }
        String path = SkinFileUtils.normalize(location.substring(index + 1), true);
        if (path != null) {
            return location.subSequence(0, index + 1) + path;
        }
        return "";
    }

    public String getPath(String location) {
        int index = location.indexOf(58);
        if (index < 0) {
            return "";
        }
        String path = SkinFileUtils.normalize(location.substring(index + 1), true);
        if (path != null) {
            return path;
        }
        return "";
    }

    private Skin getSkin() {
        if (this.skin != null) {
            return this.skin;
        }
        this.skin = SkinLoader.getInstance().loadSkin(this.source);
        return this.skin;
    }

    private boolean isAuthorized(String location, PlayerEntity player) {
        if (DataDomain.isServer(location)) {
            String path = this.getPath(location);
            if (path.startsWith("/private/" + player.func_189512_bd())) {
                return true;
            }
            return !path.startsWith("/private");
        }
        return !location.isEmpty();
    }

    public static enum Mode {
        NONE,
        UPLOAD,
        DOWNLOAD;

    }
}

