/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.utils;

import com.mojang.authlib.GameProfile;
import extensions.net.minecraft.world.entity.Entity.PropertyProvider;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.Unpooled;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import moe.plushie.armourers_workshop.api.common.IContainerLevelAccess;
import moe.plushie.armourers_workshop.api.common.IEntitySerializer;
import moe.plushie.armourers_workshop.api.common.IPlayerDataSerializer;
import moe.plushie.armourers_workshop.api.painting.IPaintColor;
import moe.plushie.armourers_workshop.api.skin.ISkinType;
import moe.plushie.armourers_workshop.core.capability.SkinWardrobe;
import moe.plushie.armourers_workshop.core.data.color.BlockPaintColor;
import moe.plushie.armourers_workshop.core.data.color.ColorScheme;
import moe.plushie.armourers_workshop.core.data.color.PaintColor;
import moe.plushie.armourers_workshop.core.entity.EntityProfile;
import moe.plushie.armourers_workshop.core.skin.SkinDescriptor;
import moe.plushie.armourers_workshop.core.skin.SkinOptions;
import moe.plushie.armourers_workshop.core.skin.SkinTypes;
import moe.plushie.armourers_workshop.core.skin.data.SkinMarker;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperties;
import moe.plushie.armourers_workshop.core.texture.PlayerTextureDescriptor;
import moe.plushie.armourers_workshop.init.ModConfig;
import moe.plushie.armourers_workshop.init.ModEntityProfiles;
import moe.plushie.armourers_workshop.utils.SkinFileUtils;
import moe.plushie.armourers_workshop.utils.StreamUtils;
import moe.plushie.armourers_workshop.utils.math.Rectangle3i;
import moe.plushie.armourers_workshop.utils.math.Vector3f;
import moe.plushie.armourers_workshop.utils.math.Vector3i;
import moe.plushie.armourers_workshop.utils.texture.SkinPaintData;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.FloatNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Rotations;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import org.apache.logging.log4j.util.Strings;
import org.jetbrains.annotations.Nullable;

public class DataSerializers {
    public static final IEntitySerializer<CompoundNBT> COMPOUND_TAG = DataSerializers.of(net.minecraft.network.datasync.DataSerializers.field_192734_n);
    public static final IEntitySerializer<Integer> INT = DataSerializers.of(net.minecraft.network.datasync.DataSerializers.field_187192_b);
    public static final IEntitySerializer<String> STRING = DataSerializers.of(net.minecraft.network.datasync.DataSerializers.field_187194_d);
    public static final IEntitySerializer<Boolean> BOOLEAN = DataSerializers.of(net.minecraft.network.datasync.DataSerializers.field_187198_h);
    public static final IEntitySerializer<Float> FLOAT = DataSerializers.of(net.minecraft.network.datasync.DataSerializers.field_187193_c);
    public static final IEntitySerializer<Vector3d> VECTOR_3D = new IEntitySerializer<Vector3d>(){

        public void write(PacketBuffer buffer, Vector3d pos) {
            buffer.writeDouble(pos.func_82615_a());
            buffer.writeDouble(pos.func_82617_b());
            buffer.writeDouble(pos.func_82616_c());
        }

        public Vector3d read(PacketBuffer buffer) {
            return new Vector3d(buffer.readDouble(), buffer.readDouble(), buffer.readDouble());
        }
    };
    public static final IEntitySerializer<Vector3f> VECTOR_3F = new IEntitySerializer<Vector3f>(){

        public void write(PacketBuffer buffer, Vector3f pos) {
            buffer.writeFloat(pos.getX());
            buffer.writeFloat(pos.getY());
            buffer.writeFloat(pos.getZ());
        }

        public Vector3f read(PacketBuffer buffer) {
            return new Vector3f(buffer.readFloat(), buffer.readFloat(), buffer.readFloat());
        }
    };
    public static final IEntitySerializer<IPaintColor> PAINT_COLOR = new IEntitySerializer<IPaintColor>(){

        public void write(PacketBuffer buffer, IPaintColor color) {
            buffer.writeInt(color.getRawValue());
        }

        public IPaintColor read(PacketBuffer buffer) {
            return PaintColor.of(buffer.readInt());
        }
    };
    public static final IEntitySerializer<PlayerTextureDescriptor> PLAYER_TEXTURE = new IEntitySerializer<PlayerTextureDescriptor>(){

        public void write(PacketBuffer buffer, PlayerTextureDescriptor descriptor) {
            buffer.func_150786_a(descriptor.serializeNBT());
        }

        public PlayerTextureDescriptor read(PacketBuffer buffer) {
            return new PlayerTextureDescriptor(buffer.func_150793_b());
        }
    };
    public static final IEntitySerializer<Exception> EXCEPTION = new IEntitySerializer<Exception>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(PacketBuffer buffer, Exception exception) {
            OutputStream outputStream = null;
            ObjectOutputStream objectOutputStream = null;
            try {
                boolean compress = ModConfig.Common.enableServerCompressesSkins;
                buffer.writeBoolean(compress);
                outputStream = this.createOutputStream(buffer, compress);
                objectOutputStream = new ObjectOutputStream(outputStream);
                objectOutputStream.writeObject(exception);
            }
            catch (Exception exception1) {
                try {
                    exception1.printStackTrace();
                }
                catch (Throwable throwable) {
                    StreamUtils.closeQuietly(objectOutputStream, outputStream);
                    throw throwable;
                }
                StreamUtils.closeQuietly(objectOutputStream, outputStream);
            }
            StreamUtils.closeQuietly(objectOutputStream, outputStream);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Exception read(PacketBuffer buffer) {
            Exception exception;
            InputStream inputStream = null;
            ObjectInputStream objectInputStream = null;
            try {
                boolean compress = buffer.readBoolean();
                inputStream = this.createInputStream(buffer, compress);
                objectInputStream = new ObjectInputStream(inputStream);
                exception = (Exception)objectInputStream.readObject();
            }
            catch (Exception exception2) {
                Exception exception3;
                try {
                    exception3 = exception2;
                }
                catch (Throwable throwable) {
                    StreamUtils.closeQuietly(objectInputStream, inputStream);
                    throw throwable;
                }
                StreamUtils.closeQuietly(objectInputStream, inputStream);
                return exception3;
            }
            StreamUtils.closeQuietly(objectInputStream, inputStream);
            return exception;
        }

        public Exception copy(Exception value) {
            return value;
        }

        private InputStream createInputStream(PacketBuffer buffer, boolean compress) throws Exception {
            ByteBufInputStream inputStream = new ByteBufInputStream((ByteBuf)buffer);
            if (compress) {
                return new GZIPInputStream((InputStream)inputStream);
            }
            return inputStream;
        }

        private OutputStream createOutputStream(PacketBuffer buffer, boolean compress) throws Exception {
            ByteBufOutputStream outputStream = new ByteBufOutputStream((ByteBuf)buffer);
            if (compress) {
                return new GZIPOutputStream((OutputStream)outputStream);
            }
            return outputStream;
        }
    };
    public static final IPlayerDataSerializer<SkinWardrobe> ENTITY_WARDROBE = new IPlayerDataSerializer<SkinWardrobe>(){

        @Override
        public void write(PacketBuffer buffer, PlayerEntity player, SkinWardrobe wardrobe) {
            buffer.writeInt(wardrobe.getId());
            buffer.func_192572_a(wardrobe.getProfile().getRegistryName());
        }

        @Override
        public SkinWardrobe read(PacketBuffer buffer, PlayerEntity player) {
            if (player == null || PropertyProvider.getLevel((Entity)player) == null) {
                return null;
            }
            int entityId = buffer.readInt();
            Entity entity = PropertyProvider.getLevel((Entity)player).func_73045_a(entityId);
            if (entity == null) {
                for (PlayerEntity player1 : PropertyProvider.getLevel((Entity)player).func_217369_A()) {
                    if (player1.func_145782_y() != entityId) continue;
                    entity = player1;
                    break;
                }
            }
            SkinWardrobe wardrobe = SkinWardrobe.of(entity);
            EntityProfile serverProfile = ModEntityProfiles.getProfile(buffer.func_192575_l());
            if (wardrobe != null && serverProfile != null) {
                wardrobe.setProfile(serverProfile);
            }
            return wardrobe;
        }
    };
    public static final IPlayerDataSerializer<IContainerLevelAccess> WORLD_POS = new IPlayerDataSerializer<IContainerLevelAccess>(){

        @Override
        public void write(PacketBuffer buffer, PlayerEntity player, IContainerLevelAccess callable) {
            Optional pos1 = callable.func_221484_a((world, pos) -> pos);
            buffer.func_179255_a(pos1.orElse(BlockPos.field_177992_a));
        }

        @Override
        public IContainerLevelAccess read(PacketBuffer buffer, PlayerEntity player) {
            if (player == null || PropertyProvider.getLevel((Entity)player) == null) {
                return null;
            }
            BlockPos blockPos = buffer.func_179259_c();
            return IContainerLevelAccess.create(PropertyProvider.getLevel((Entity)player), blockPos, null);
        }
    };
    public static final IPlayerDataSerializer<ISkinType> SKIN_TYPE = new IPlayerDataSerializer<ISkinType>(){

        @Override
        public void write(PacketBuffer buffer, PlayerEntity player, ISkinType value) {
            buffer.func_180714_a(value.getRegistryName().toString());
        }

        @Override
        public ISkinType read(PacketBuffer buffer, PlayerEntity player) {
            return SkinTypes.byName(buffer.func_150789_c(Short.MAX_VALUE));
        }
    };
    public static final IPlayerDataSerializer<SkinProperties> SKIN_PROPERTIES = new IPlayerDataSerializer<SkinProperties>(){

        @Override
        public void write(PacketBuffer buffer, PlayerEntity player, SkinProperties value) {
            CompoundNBT nbt = new CompoundNBT();
            value.writeToNBT(nbt);
            buffer.func_150786_a(nbt);
        }

        @Override
        public SkinProperties read(PacketBuffer buffer, PlayerEntity player) {
            SkinProperties properties = SkinProperties.create();
            CompoundNBT nbt = buffer.func_150793_b();
            if (nbt != null) {
                properties.readFromNBT(nbt);
            }
            return properties;
        }
    };
    private static final Random RANDOM = new Random();

    public static <T> IEntitySerializer<T> of(final IDataSerializer<T> serializer) {
        return new IEntitySerializer<T>(){

            @Override
            public T func_187159_a(PacketBuffer buffer) {
                return serializer.func_187159_a(buffer);
            }

            @Override
            public void func_187160_a(PacketBuffer buffer, T descriptor) {
                serializer.func_187160_a(buffer, descriptor);
            }
        };
    }

    public static CompoundNBT parseCompoundTag(CompoundNBT nbt, String key) {
        if (nbt.func_150297_b(key, 10)) {
            return nbt.func_74775_l(key);
        }
        if (nbt.func_150297_b(key, 8)) {
            return SkinFileUtils.readNBT(nbt.func_74779_i(key));
        }
        return null;
    }

    public static Vector3i getVector3i(CompoundNBT nbt, String key) {
        ListNBT listNBT = nbt.func_150295_c(key, 3);
        if (listNBT.size() >= 3) {
            return new Vector3i(listNBT.func_186858_c(0), listNBT.func_186858_c(1), listNBT.func_186858_c(2));
        }
        return Vector3i.ZERO;
    }

    public static void putVector3i(CompoundNBT nbt, String key, Vector3i vector) {
        int x = vector.getX();
        int y = vector.getY();
        int z = vector.getZ();
        if (x == 0 && y == 0 && z == 0) {
            return;
        }
        ListNBT tags = new ListNBT();
        tags.add((Object)IntNBT.func_229692_a_((int)x));
        tags.add((Object)IntNBT.func_229692_a_((int)y));
        tags.add((Object)IntNBT.func_229692_a_((int)z));
        nbt.func_218657_a(key, (INBT)tags);
    }

    public static Vector3f getVector3f(CompoundNBT nbt, String key) {
        ListNBT listNBT = nbt.func_150295_c(key, 5);
        if (listNBT.size() >= 3) {
            return new Vector3f(listNBT.func_150308_e(0), listNBT.func_150308_e(1), listNBT.func_150308_e(2));
        }
        return new Vector3f(0.0f, 0.0f, 0.0f);
    }

    public static void putVector3f(CompoundNBT nbt, String key, Vector3f vector) {
        float x = vector.getX();
        float y = vector.getY();
        float z = vector.getZ();
        if (x == 0.0f && y == 0.0f && z == 0.0f) {
            return;
        }
        ListNBT tags = new ListNBT();
        tags.add((Object)FloatNBT.func_229689_a_((float)x));
        tags.add((Object)FloatNBT.func_229689_a_((float)y));
        tags.add((Object)FloatNBT.func_229689_a_((float)z));
        nbt.func_218657_a(key, (INBT)tags);
    }

    public static Rectangle3i getRectangle3i(CompoundNBT nbt, String key, Rectangle3i defaultValue) {
        ListNBT listNBT = nbt.func_150295_c(key, 3);
        if (listNBT.size() >= 6) {
            return new Rectangle3i(listNBT.func_186858_c(0), listNBT.func_186858_c(1), listNBT.func_186858_c(2), listNBT.func_186858_c(3), listNBT.func_186858_c(4), listNBT.func_186858_c(5));
        }
        return defaultValue;
    }

    public static void putRectangle3i(CompoundNBT nbt, String key, Rectangle3i value, Rectangle3i defaultValue) {
        if (value.equals(defaultValue)) {
            return;
        }
        ListNBT tags = new ListNBT();
        tags.add((Object)IntNBT.func_229692_a_((int)value.getX()));
        tags.add((Object)IntNBT.func_229692_a_((int)value.getY()));
        tags.add((Object)IntNBT.func_229692_a_((int)value.getZ()));
        tags.add((Object)IntNBT.func_229692_a_((int)value.getWidth()));
        tags.add((Object)IntNBT.func_229692_a_((int)value.getHeight()));
        tags.add((Object)IntNBT.func_229692_a_((int)value.getDepth()));
        nbt.func_218657_a(key, (INBT)tags);
    }

    public static boolean getBoolean(CompoundNBT nbt, String key, boolean defaultValue) {
        if (nbt.func_150297_b(key, 1)) {
            return nbt.func_74767_n(key);
        }
        return defaultValue;
    }

    public static void putBoolean(CompoundNBT nbt, String key, boolean value, boolean defaultValue) {
        if (defaultValue != value) {
            nbt.func_74757_a(key, value);
        }
    }

    public static int getInt(CompoundNBT nbt, String key, int defaultValue) {
        if (nbt != null && nbt.func_150297_b(key, 3)) {
            return nbt.func_74762_e(key);
        }
        return defaultValue;
    }

    public static void putInt(CompoundNBT nbt, String key, int value, int defaultValue) {
        if (defaultValue != value) {
            nbt.func_74768_a(key, value);
        }
    }

    @Nullable
    public static SkinPaintData getPaintData(CompoundNBT nbt, String key) {
        if (nbt != null && nbt.func_150297_b(key, 7)) {
            try {
                ByteBuf buffer = Unpooled.wrappedBuffer((byte[])nbt.func_74770_j(key));
                ByteBufInputStream bufferedStream = new ByteBufInputStream(buffer);
                GZIPInputStream compressedStream = new GZIPInputStream((InputStream)bufferedStream);
                DataInputStream dataStream = new DataInputStream(compressedStream);
                SkinPaintData paintData = SkinPaintData.v2();
                int length = dataStream.readInt();
                int[] colors = paintData.getData();
                for (int i = 0; i < length; ++i) {
                    if (i >= colors.length) continue;
                    colors[i] = dataStream.readInt();
                }
                StreamUtils.closeQuietly(new Closeable[]{dataStream, compressedStream, bufferedStream});
                return paintData;
            }
            catch (Exception ignored) {
                return null;
            }
        }
        return null;
    }

    public static void putPaintData(CompoundNBT nbt, String key, SkinPaintData paintData) {
        if (paintData != null) {
            try {
                int[] colors = paintData.getData();
                ByteBuf buffer = Unpooled.buffer();
                ByteBufOutputStream bufferedStream = new ByteBufOutputStream(buffer);
                GZIPOutputStream compressedStream = new GZIPOutputStream((OutputStream)bufferedStream);
                DataOutputStream dataStream = new DataOutputStream(compressedStream);
                dataStream.writeInt(colors.length);
                for (int color : colors) {
                    dataStream.writeInt(color);
                }
                StreamUtils.closeQuietly(new Closeable[]{dataStream, compressedStream, bufferedStream});
                nbt.func_74773_a(key, Arrays.copyOf(buffer.array(), buffer.writerIndex()));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static float getFloat(CompoundNBT nbt, String key, float defaultValue) {
        if (nbt.func_150297_b(key, 5)) {
            return nbt.func_74760_g(key);
        }
        return defaultValue;
    }

    public static void putFloat(CompoundNBT nbt, String key, float value, float defaultValue) {
        if (defaultValue != value) {
            nbt.func_74776_a(key, value);
        }
    }

    public static String getString(CompoundNBT nbt, String key, String defaultValue) {
        if (nbt != null && nbt.func_150297_b(key, 8)) {
            return nbt.func_74779_i(key);
        }
        return defaultValue;
    }

    public static void putString(CompoundNBT nbt, String key, String value, String defaultValue) {
        if (defaultValue != value) {
            nbt.func_74778_a(key, value);
        }
    }

    public static void putRotations(CompoundNBT nbt, String key, Rotations value, Rotations defaultValue) {
        if (!value.equals((Object)defaultValue)) {
            nbt.func_218657_a(key, (INBT)value.func_179414_a());
        }
    }

    public static Rotations getRotations(CompoundNBT nbt, String key, Rotations defaultValue) {
        ListNBT listNBT = nbt.func_150295_c(key, 5);
        if (listNBT.size() >= 3) {
            return new Rotations(listNBT);
        }
        return defaultValue;
    }

    public static void mirrorRotations(CompoundNBT source, String sourceKey, Rotations sourceDefaultValue, CompoundNBT target, String targetKey, Rotations targetDefaultValue) {
        Rotations rot = DataSerializers.getRotations(source, sourceKey, sourceDefaultValue);
        rot = new Rotations(rot.func_179415_b(), -rot.func_179416_c(), -rot.func_179413_d());
        DataSerializers.putRotations(target, targetKey, rot, targetDefaultValue);
    }

    public static void putSkinProperties(CompoundNBT nbt, String key, SkinProperties properties) {
        if (properties == null || properties.isEmpty()) {
            return;
        }
        CompoundNBT propertiesTag = new CompoundNBT();
        properties.writeToNBT(propertiesTag);
        nbt.func_218657_a(key, (INBT)propertiesTag);
    }

    public static SkinProperties getSkinProperties(CompoundNBT nbt, String key) {
        SkinProperties properties = new SkinProperties();
        if (nbt.func_150297_b(key, 10)) {
            properties.readFromNBT(nbt.func_74775_l(key));
        }
        return properties;
    }

    public static void putPaintColor(CompoundNBT nbt, String key, IPaintColor value, IPaintColor defaultValue) {
        if (value != null && !value.equals(defaultValue)) {
            nbt.func_74768_a(key, value.getRawValue());
        } else {
            nbt.func_82580_o(key);
        }
    }

    public static IPaintColor getPaintColor(CompoundNBT nbt, String key, IPaintColor defaultValue) {
        if (nbt != null && nbt.func_150297_b(key, 3)) {
            return PaintColor.of(nbt.func_74762_e(key));
        }
        return defaultValue;
    }

    public static void putBlockPaintColor(CompoundNBT nbt, String key, BlockPaintColor value, BlockPaintColor defaultValue) {
        if (value != null && !value.equals(defaultValue)) {
            nbt.func_218657_a(key, (INBT)value.serializeNBT());
        } else {
            nbt.func_82580_o(key);
        }
    }

    public static BlockPaintColor getBlockPaintColor(CompoundNBT nbt, String key, BlockPaintColor defaultValue) {
        if (!nbt.func_150297_b(key, 10)) {
            return defaultValue;
        }
        CompoundNBT colorNBT = nbt.func_74775_l(key);
        if (colorNBT.isEmpty()) {
            return defaultValue;
        }
        BlockPaintColor color = new BlockPaintColor();
        color.deserializeNBT(colorNBT);
        return color;
    }

    public static ColorScheme getColorScheme(CompoundNBT nbt, String key, ColorScheme defaultValue) {
        if (nbt.func_150297_b(key, 10)) {
            return new ColorScheme(nbt.func_74775_l(key));
        }
        return defaultValue;
    }

    public static void putColorScheme(CompoundNBT nbt, String key, ColorScheme value, ColorScheme defaultValue) {
        if (!value.equals(defaultValue)) {
            nbt.func_218657_a(key, (INBT)value.serializeNBT());
        }
    }

    public static void putSkinDescriptor(CompoundNBT nbt, String key, SkinDescriptor value, SkinDescriptor defaultValue) {
        if (!value.equals(defaultValue)) {
            nbt.func_218657_a(key, (INBT)value.serializeNBT());
        }
    }

    public static SkinDescriptor getSkinDescriptor(CompoundNBT nbt, String key, SkinDescriptor defaultValue) {
        CompoundNBT nbt1 = DataSerializers.parseCompoundTag(nbt, key);
        if (nbt1 != null && !nbt1.isEmpty()) {
            return new SkinDescriptor(nbt1);
        }
        return defaultValue;
    }

    public static void putSkinOptions(CompoundNBT nbt, String key, SkinOptions value, SkinOptions defaultValue) {
        if (!value.equals(defaultValue)) {
            nbt.func_218657_a(key, (INBT)value.serializeNBT());
        }
    }

    public static SkinOptions getSkinOptions(CompoundNBT nbt, String key, SkinOptions defaultValue) {
        CompoundNBT nbt1;
        if (nbt.func_150297_b(key, 10) && !(nbt1 = nbt.func_74775_l(key)).isEmpty()) {
            return new SkinOptions(nbt1);
        }
        return defaultValue;
    }

    public static void putTextureDescriptor(CompoundNBT nbt, String key, PlayerTextureDescriptor value, PlayerTextureDescriptor defaultValue) {
        if (!value.equals(defaultValue)) {
            nbt.func_218657_a(key, (INBT)value.serializeNBT());
        }
    }

    public static PlayerTextureDescriptor getTextureDescriptor(CompoundNBT nbt, String key, PlayerTextureDescriptor defaultValue) {
        CompoundNBT nbt1;
        if (nbt.func_150297_b(key, 10) && !(nbt1 = nbt.func_74775_l(key)).isEmpty()) {
            return new PlayerTextureDescriptor(nbt1);
        }
        return defaultValue;
    }

    public static void putBlockPos(CompoundNBT nbt, String key, BlockPos value, BlockPos defaultValue) {
        if (!Objects.equals(value, defaultValue)) {
            nbt.func_74772_a(key, value.func_218275_a());
        } else {
            nbt.func_82580_o(key);
        }
    }

    public static BlockPos getBlockPos(CompoundNBT nbt, String key, BlockPos defaultValue) {
        if (nbt.func_150297_b(key, 4)) {
            return BlockPos.func_218283_e((long)nbt.func_74763_f(key));
        }
        return defaultValue;
    }

    public static void putBlockPosList(CompoundNBT nbt, String key, Collection<BlockPos> elements) {
        if (elements.isEmpty()) {
            return;
        }
        ArrayList<Long> list = new ArrayList<Long>(elements.size());
        for (BlockPos pos : elements) {
            list.add(pos.func_218275_a());
        }
        nbt.func_202168_c(key, list);
    }

    public static Collection<BlockPos> getBlockPosList(CompoundNBT nbt, String key) {
        ArrayList<BlockPos> elements = new ArrayList<BlockPos>();
        if (nbt.func_150297_b(key, 12)) {
            for (long value : nbt.func_197645_o(key)) {
                elements.add(BlockPos.func_218283_e((long)value));
            }
        }
        return elements;
    }

    public static void putMarkerList(CompoundNBT nbt, String key, Collection<SkinMarker> elements) {
        if (elements.isEmpty()) {
            return;
        }
        ArrayList<Long> list = new ArrayList<Long>(elements.size());
        for (SkinMarker marker : elements) {
            list.add(marker.asLong());
        }
        nbt.func_202168_c(key, list);
    }

    public static Collection<SkinMarker> getMarkerList(CompoundNBT nbt, String key) {
        ArrayList<SkinMarker> elements = new ArrayList<SkinMarker>();
        if (nbt.func_150297_b(key, 12)) {
            for (long value : nbt.func_197645_o(key)) {
                elements.add(SkinMarker.of(value));
            }
        }
        return elements;
    }

    @Nullable
    public static GameProfile readGameProfile(CompoundNBT compoundTag) {
        String name = null;
        UUID id = null;
        if (compoundTag.func_150297_b("Name", 8)) {
            name = compoundTag.func_74779_i("Name");
        }
        if (compoundTag.func_186855_b("Id")) {
            id = compoundTag.func_186857_a("Id");
        }
        try {
            return new GameProfile(id, name);
        }
        catch (Exception ignored) {
            return null;
        }
    }

    public static CompoundNBT writeGameProfile(CompoundNBT compoundTag, GameProfile gameProfile) {
        if (Strings.isNotBlank((String)gameProfile.getName())) {
            compoundTag.func_74778_a("Name", gameProfile.getName());
        }
        if (gameProfile.getId() != null) {
            compoundTag.func_186854_a("Id", gameProfile.getId());
        }
        return compoundTag;
    }

    public static void dropContents(World level, BlockPos blockPos, IInventory container) {
        DataSerializers.dropContents(level, blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p(), container);
    }

    public static void dropContents(World level, Entity entity, IInventory container) {
        DataSerializers.dropContents(level, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), container);
    }

    private static void dropContents(World level, double x, double y, double z, IInventory container) {
        for (int i = 0; i < container.func_70302_i_(); ++i) {
            DataSerializers.dropItemStack(level, x, y, z, container.func_70301_a(i));
        }
    }

    public static void dropContents(World level, BlockPos blockPos, NonNullList<ItemStack> itemStacks) {
        itemStacks.forEach(itemStack -> DataSerializers.dropItemStack(level, blockPos, itemStack));
    }

    public static void dropItemStack(World level, BlockPos blockPos, ItemStack itemStack) {
        DataSerializers.dropItemStack(level, blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p(), itemStack);
    }

    public static void dropItemStack(World level, double x, double y, double z, ItemStack itemStack) {
        double d0 = EntityType.field_200765_E.func_220333_h();
        double d1 = 1.0 - d0;
        double d2 = d0 / 2.0;
        double d3 = Math.floor(x) + RANDOM.nextDouble() * d1 + d2;
        double d4 = Math.floor(y) + RANDOM.nextDouble() * d1;
        double d5 = Math.floor(z) + RANDOM.nextDouble() * d1 + d2;
        while (!itemStack.func_190926_b()) {
            ItemEntity itementity = new ItemEntity(level, d3, d4, d5, itemStack.func_77979_a(RANDOM.nextInt(21) + 10));
            float f = 0.05f;
            itementity.func_213293_j(RANDOM.nextGaussian() * (double)0.05f, RANDOM.nextGaussian() * (double)0.05f + (double)0.2f, RANDOM.nextGaussian() * (double)0.05f);
            level.func_217376_c((Entity)itementity);
        }
    }
}

