/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.utils;

import com.apple.library.coregraphics.CGRect;
import com.apple.library.uikit.UIColor;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import extensions.com.mojang.blaze3d.systems.RenderSystem.Fix16;
import java.nio.FloatBuffer;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicInteger;
import moe.plushie.armourers_workshop.api.math.IRectangle3f;
import moe.plushie.armourers_workshop.api.math.IRectangle3i;
import moe.plushie.armourers_workshop.compatibility.client.AbstractRenderSystem;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderType;
import moe.plushie.armourers_workshop.core.client.other.SkinVertexBufferBuilder;
import moe.plushie.armourers_workshop.core.data.color.PaintColor;
import moe.plushie.armourers_workshop.init.ModDebugger;
import moe.plushie.armourers_workshop.utils.ObjectUtils;
import moe.plushie.armourers_workshop.utils.math.OpenMatrix3f;
import moe.plushie.armourers_workshop.utils.math.OpenMatrix4f;
import moe.plushie.armourers_workshop.utils.math.Rectangle3f;
import moe.plushie.armourers_workshop.utils.math.Rectangle3i;
import moe.plushie.armourers_workshop.utils.math.Vector3f;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL11;

@OnlyIn(value=Dist.CLIENT)
public final class RenderSystem
extends AbstractRenderSystem {
    private static final AtomicInteger extendedMatrixFlags = new AtomicInteger();
    private static final Storage<OpenMatrix3f> extendedNormalMatrix = new Storage<OpenMatrix3f>(OpenMatrix3f.createScaleMatrix(1.0f, 1.0f, 1.0f));
    private static final Storage<OpenMatrix4f> extendedTextureMatrix = new Storage<OpenMatrix4f>(OpenMatrix4f.createScaleMatrix(1.0f, 1.0f, 1.0f));
    private static final Storage<OpenMatrix4f> extendedLightmapTextureMatrix = new Storage<OpenMatrix4f>(OpenMatrix4f.createScaleMatrix(1.0f, 1.0f, 1.0f));
    private static final Storage<OpenMatrix4f> extendedModelViewMatrix = new Storage<OpenMatrix4f>(OpenMatrix4f.createScaleMatrix(1.0f, 1.0f, 1.0f));
    private static final Storage<PaintColor> extendedTintColor = new Storage<PaintColor>(PaintColor.WHITE);
    private static final FloatBuffer BUFFER = ObjectUtils.createFloatBuffer(3);
    private static final byte[][][] FACE_MARK_TEXTURES = new byte[][][]{new byte[][]{{1, 3}, {1, 0}, {0, 0}, {0, 3}}, new byte[][]{{1, 3}, {1, 0}, {0, 0}, {0, 3}}, new byte[][]{{1, 2}, {1, 0}, {0, 0}, {0, 2}}, new byte[][]{{1, 2}, {1, 0}, {0, 0}, {0, 2}}, new byte[][]{{3, 2}, {3, 0}, {0, 0}, {0, 2}}, new byte[][]{{3, 2}, {3, 0}, {0, 0}, {0, 2}}};
    private static final byte[][][] FACE_MARK_VERTEXES = new byte[][][]{new byte[][]{{0, 0, 1}, {0, 0, 0}, {1, 0, 0}, {1, 0, 1}, {0, -1, 0}}, new byte[][]{{1, 1, 1}, {1, 1, 0}, {0, 1, 0}, {0, 1, 1}, {0, 1, 0}}, new byte[][]{{0, 0, 0}, {0, 1, 0}, {1, 1, 0}, {1, 0, 0}, {0, 0, -1}}, new byte[][]{{1, 0, 1}, {1, 1, 1}, {0, 1, 1}, {0, 0, 1}, {0, 0, 1}}, new byte[][]{{0, 0, 1}, {0, 1, 1}, {0, 1, 0}, {0, 0, 0}, {-1, 0, 0}}, new byte[][]{{1, 0, 0}, {1, 1, 0}, {1, 1, 1}, {1, 0, 1}, {1, 0, 0}}};
    private static final LinkedList<CGRect> clipBounds = new LinkedList();

    public static void call(Runnable task) {
        if (RenderSystem.isOnRenderThread()) {
            task.run();
        } else {
            RenderSystem.recordRenderCall(task::run);
        }
    }

    public static int getPixelColor(float x, float y) {
        MainWindow window = Minecraft.func_71410_x().func_228018_at_();
        double guiScale = window.func_198100_s();
        int sx = (int)((double)x * guiScale);
        int sy = (int)((double)((float)window.func_198087_p() - y) * guiScale);
        BUFFER.rewind();
        GL11.glReadPixels((int)sx, (int)sy, (int)1, (int)1, (int)6407, (int)5126, (FloatBuffer)BUFFER);
        GL11.glFinish();
        int r = Math.round(BUFFER.get() * 255.0f);
        int g = Math.round(BUFFER.get() * 255.0f);
        int b = Math.round(BUFFER.get() * 255.0f);
        return 0xFF000000 | r << 16 | g << 8 | b;
    }

    public static void addClipRect(int x, int y, int width, int height) {
        RenderSystem.addClipRect(new CGRect(x, y, width, height));
    }

    public static void addClipRect(CGRect rect) {
        if (!clipBounds.isEmpty()) {
            CGRect rect1 = clipBounds.getLast();
            rect = rect.intersection(rect1);
        }
        clipBounds.add(rect);
        RenderSystem.applyScissor(rect);
    }

    public static void removeClipRect() {
        if (clipBounds.isEmpty()) {
            return;
        }
        clipBounds.removeLast();
        if (!clipBounds.isEmpty()) {
            RenderSystem.applyScissor(clipBounds.getLast());
        } else {
            RenderSystem.disableScissor();
        }
    }

    public static void applyScissor(CGRect rect) {
        MainWindow window = Minecraft.func_71410_x().func_228018_at_();
        double scale = window.func_198100_s();
        double sx = (double)rect.getX() * scale;
        double sy = (double)window.func_198091_l() - (double)rect.getMaxY() * scale;
        double sw = (double)rect.getWidth() * scale;
        double sh = (double)rect.getHeight() * scale;
        RenderSystem.enableScissor((int)((int)sx), (int)((int)sy), (int)((int)sw), (int)((int)sh));
    }

    public static boolean inScissorRect(CGRect rect1) {
        if (!clipBounds.isEmpty()) {
            CGRect rect = clipBounds.getLast();
            return rect.intersects(rect1);
        }
        return true;
    }

    public static boolean inScissorRect(int x, int y, int width, int height) {
        if (!clipBounds.isEmpty()) {
            CGRect rect = clipBounds.getLast();
            return rect.intersects(x, y, width, height);
        }
        return true;
    }

    public static void drawLine(MatrixStack poseStack, float x0, float y0, float z0, float x1, float y1, float z1, UIColor color, IRenderTypeBuffer buffers) {
        MatrixStack.Entry pose = poseStack.func_227866_c_();
        IVertexBuilder builder = buffers.getBuffer(SkinRenderType.lines());
        RenderSystem.drawLine(pose, x0, y0, z0, x1, y1, z1, color, builder);
    }

    private static void drawLine(MatrixStack.Entry pose, float x0, float y0, float z0, float x1, float y1, float z1, UIColor color, IVertexBuilder builder) {
        float nx = 0.0f;
        float ny = 0.0f;
        float nz = 0.0f;
        if (x0 != x1) {
            nx = 1.0f;
        }
        if (y0 != y1) {
            ny = 1.0f;
        }
        if (z0 != z1) {
            nz = 1.0f;
        }
        builder.func_227888_a_(pose.func_227870_a_(), x0, y0, z0).func_225586_a_(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).func_227887_a_(pose.func_227872_b_(), nx, ny, nz).func_181675_d();
        builder.func_227888_a_(pose.func_227870_a_(), x1, y1, z1).func_225586_a_(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).func_227887_a_(pose.func_227872_b_(), nx, ny, nz).func_181675_d();
    }

    public static void drawBoundingBox(MatrixStack poseStack, float x0, float y0, float z0, float x1, float y1, float z1, UIColor color, IVertexBuilder builder) {
        MatrixStack.Entry pose = poseStack.func_227866_c_();
        RenderSystem.drawLine(pose, x1, y0, z1, x0, y0, z1, color, builder);
        RenderSystem.drawLine(pose, x1, y0, z1, x1, y1, z1, color, builder);
        RenderSystem.drawLine(pose, x1, y0, z1, x1, y0, z0, color, builder);
        RenderSystem.drawLine(pose, x1, y1, z0, x0, y1, z0, color, builder);
        RenderSystem.drawLine(pose, x1, y1, z0, x1, y0, z0, color, builder);
        RenderSystem.drawLine(pose, x1, y1, z0, x1, y1, z1, color, builder);
        RenderSystem.drawLine(pose, x0, y1, z1, x1, y1, z1, color, builder);
        RenderSystem.drawLine(pose, x0, y1, z1, x0, y0, z1, color, builder);
        RenderSystem.drawLine(pose, x0, y1, z1, x0, y1, z0, color, builder);
        RenderSystem.drawLine(pose, x0, y0, z0, x1, y0, z0, color, builder);
        RenderSystem.drawLine(pose, x0, y0, z0, x0, y1, z0, color, builder);
        RenderSystem.drawLine(pose, x0, y0, z0, x0, y0, z1, color, builder);
    }

    public static void drawPoint(MatrixStack poseStack, @Nullable IRenderTypeBuffer renderTypeBuffer) {
        RenderSystem.drawPoint(poseStack, null, 2.0f, renderTypeBuffer);
    }

    public static void drawPoint(MatrixStack poseStack, @Nullable Vector3f point, float size, @Nullable IRenderTypeBuffer renderTypeBuffer) {
        RenderSystem.drawPoint(poseStack, point, size, size, size, renderTypeBuffer);
    }

    public static void drawPoint(MatrixStack poseStack, @Nullable Vector3f point, float width, float height, float depth, @Nullable IRenderTypeBuffer renderTypeBuffer) {
        if (renderTypeBuffer == null) {
            renderTypeBuffer = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
        }
        IVertexBuilder builder = renderTypeBuffer.getBuffer(SkinRenderType.lines());
        float x0 = 0.0f;
        float y0 = 0.0f;
        float z0 = 0.0f;
        if (point != null) {
            x0 = point.getX();
            y0 = point.getY();
            z0 = point.getZ();
        }
        MatrixStack.Entry pose = poseStack.func_227866_c_();
        RenderSystem.drawLine(pose, x0 - width, y0, z0, x0 + width, y0, z0, UIColor.RED, builder);
        RenderSystem.drawLine(pose, x0, y0 - height, z0, x0, y0 + height, z0, UIColor.GREEN, builder);
        RenderSystem.drawLine(pose, x0, y0, z0 - depth, x0, y0, z0 + depth, UIColor.BLUE, builder);
    }

    public static void drawTargetBox(MatrixStack poseStack, float width, float height, float depth, IRenderTypeBuffer buffers) {
        if (ModDebugger.targetBounds) {
            RenderSystem.drawBoundingBox(poseStack, -width / 2.0f, -height / 2.0f, -depth / 2.0f, width / 2.0f, height / 2.0f, depth / 2.0f, UIColor.ORANGE, buffers);
            RenderSystem.drawPoint(poseStack, null, width, height, depth, buffers);
        }
    }

    public static void drawBoundingBox(MatrixStack poseStack, float x0, float y0, float z0, float x1, float y1, float z1, UIColor color, IRenderTypeBuffer buffers) {
        IVertexBuilder builder = buffers.getBuffer(SkinRenderType.lines());
        RenderSystem.drawBoundingBox(poseStack, x0, y0, z0, x1, y1, z1, color, builder);
    }

    public static void drawBoundingBox(MatrixStack poseStack, CGRect rect, UIColor color) {
        IRenderTypeBuffer.Impl buffers = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
        RenderSystem.drawBoundingBox(poseStack, rect.x, rect.y, 0.0f, rect.x + rect.width, rect.y + rect.height, 0.0f, color, (IRenderTypeBuffer)buffers);
        buffers.func_228461_a_();
    }

    public static void drawBoundingBox(MatrixStack poseStack, Rectangle3f rec, UIColor color, IRenderTypeBuffer renderTypeBuffer) {
        float x0 = rec.getMinX();
        float y0 = rec.getMinY();
        float z0 = rec.getMinZ();
        float x1 = rec.getMaxX();
        float y1 = rec.getMaxY();
        float z1 = rec.getMaxZ();
        RenderSystem.drawBoundingBox(poseStack, x0, y0, z0, x1, y1, z1, color, renderTypeBuffer);
    }

    public static void drawBoundingBox(MatrixStack poseStack, Rectangle3i rec, UIColor color, IRenderTypeBuffer renderTypeBuffer) {
        int x0 = rec.getMinX();
        int y0 = rec.getMinY();
        int z0 = rec.getMinZ();
        int x1 = rec.getMaxX();
        int y1 = rec.getMaxY();
        int z1 = rec.getMaxZ();
        RenderSystem.drawBoundingBox(poseStack, (float)x0, (float)y0, (float)z0, (float)x1, (float)y1, (float)z1, color, renderTypeBuffer);
    }

    public static void drawBoundingBox(MatrixStack poseStack, AxisAlignedBB rec, UIColor color, IRenderTypeBuffer renderTypeBuffer) {
        float x0 = (float)rec.field_72340_a;
        float y0 = (float)rec.field_72338_b;
        float z0 = (float)rec.field_72339_c;
        float x1 = (float)rec.field_72336_d;
        float y1 = (float)rec.field_72337_e;
        float z1 = (float)rec.field_72334_f;
        RenderSystem.drawBoundingBox(poseStack, x0, y0, z0, x1, y1, z1, color, renderTypeBuffer);
    }

    public static void drawCube(MatrixStack poseStack, IRectangle3i rect, float r, float g, float b, float a, IRenderTypeBuffer buffers) {
        float x = rect.getMinX();
        float y = rect.getMinY();
        float z = rect.getMinZ();
        float w = rect.getWidth();
        float h = rect.getHeight();
        float d = rect.getDepth();
        RenderSystem.drawCube(poseStack, x, y, z, w, h, d, r, g, b, a, buffers);
    }

    public static void drawCube(MatrixStack poseStack, IRectangle3f rect, float r, float g, float b, float a, IRenderTypeBuffer buffers) {
        float x = rect.getMinX();
        float y = rect.getMinY();
        float z = rect.getMinZ();
        float w = rect.getWidth();
        float h = rect.getHeight();
        float d = rect.getDepth();
        RenderSystem.drawCube(poseStack, x, y, z, w, h, d, r, g, b, a, buffers);
    }

    public static void drawCube(MatrixStack poseStack, float x, float y, float z, float w, float h, float d, float r, float g, float b, float a, IRenderTypeBuffer buffers) {
        if (w == 0.0f || h == 0.0f || d == 0.0f) {
            return;
        }
        MatrixStack.Entry pose = poseStack.func_227866_c_();
        SkinVertexBufferBuilder builder1 = SkinVertexBufferBuilder.getBuffer(buffers);
        IVertexBuilder builder = builder1.getBuffer(SkinRenderType.IMAGE_GUIDE);
        for (Direction dir : Direction.values()) {
            RenderSystem.drawFace(pose, dir, x, y, z, w, h, d, 0.0f, 0.0f, r, g, b, a, builder);
        }
    }

    public static void drawFace(MatrixStack.Entry pose, Direction dir, float x, float y, float z, float w, float h, float d, float u, float v, float r, float g, float b, float a, IVertexBuilder builder) {
        byte[][] vertexes = FACE_MARK_VERTEXES[dir.func_176745_a()];
        byte[][] textures = FACE_MARK_TEXTURES[dir.func_176745_a()];
        float[] values = new float[]{0.0f, w, h, d};
        for (int i = 0; i < 4; ++i) {
            builder.func_227888_a_(pose.func_227870_a_(), x + (float)vertexes[i][0] * w, y + (float)vertexes[i][1] * h, z + (float)vertexes[i][2] * d).func_227885_a_(r, g, b, a).func_225583_a_(u + values[textures[i][0]], v + values[textures[i][1]]).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(0xF000F0).func_181675_d();
        }
    }

    public static void setShaderColor(UIColor color) {
        Fix16.setShaderColor(RenderSystem.class, (float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, (float)color.getAlpha() / 255.0f);
    }

    public static void setShaderColor(PaintColor color) {
        Fix16.setShaderColor(RenderSystem.class, (float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, 1.0f);
    }

    public static void setShaderColor(float f, float g, float h) {
        Fix16.setShaderColor(RenderSystem.class, f, g, h, 1.0f);
    }

    public static OpenMatrix3f getExtendedNormalMatrix() {
        return extendedNormalMatrix.get();
    }

    public static void setExtendedNormalMatrix(OpenMatrix3f value) {
        extendedNormalMatrix.set(value);
    }

    public static OpenMatrix4f getExtendedTextureMatrix() {
        return extendedTextureMatrix.get();
    }

    public static void setExtendedTextureMatrix(OpenMatrix4f value) {
        extendedTextureMatrix.set(value);
    }

    public static OpenMatrix4f getExtendedLightmapTextureMatrix() {
        return extendedLightmapTextureMatrix.get();
    }

    public static void setExtendedLightmapTextureMatrix(OpenMatrix4f value) {
        extendedLightmapTextureMatrix.set(value);
    }

    public static OpenMatrix4f getExtendedModelViewMatrix() {
        return extendedModelViewMatrix.get();
    }

    public static void setExtendedModelViewMatrix(OpenMatrix4f value) {
        extendedModelViewMatrix.set(value);
    }

    public static void setExtendedMatrixFlags(int options) {
        extendedMatrixFlags.set(options);
    }

    public static int getExtendedMatrixFlags() {
        return extendedMatrixFlags.get();
    }

    public static void setExtendedTintColor(PaintColor tintColor) {
        extendedTintColor.set(tintColor);
    }

    public static PaintColor getExtendedTintColor() {
        return extendedTintColor.get();
    }

    public static void backupExtendedMatrix() {
        extendedTextureMatrix.save();
        extendedNormalMatrix.save();
        extendedLightmapTextureMatrix.save();
        extendedModelViewMatrix.save();
        extendedTintColor.save();
    }

    public static void restoreExtendedMatrix() {
        extendedTextureMatrix.load();
        extendedNormalMatrix.load();
        extendedLightmapTextureMatrix.load();
        extendedModelViewMatrix.load();
        extendedTintColor.load();
    }

    public static class Storage<T> {
        private T value;
        private T backup;

        public Storage(T value) {
            this.value = value;
            this.backup = value;
        }

        public void save() {
            this.backup = this.value;
        }

        public void load() {
            this.value = this.backup;
        }

        public void set(T value) {
            if (!com.mojang.blaze3d.systems.RenderSystem.isOnRenderThread()) {
                com.mojang.blaze3d.systems.RenderSystem.recordRenderCall(() -> {
                    this.value = value;
                });
            } else {
                this.value = value;
            }
        }

        public T get() {
            Fix16.assertOnRenderThread(Storage.class);
            return this.value;
        }
    }
}

