/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.utils;

import extensions.net.minecraft.network.chat.Component.TranslatableProvider;
import extensions.net.minecraft.world.entity.player.Player.SystemMessageProvider;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.util.ArrayList;
import moe.plushie.armourers_workshop.api.skin.ISkinFileHeader;
import moe.plushie.armourers_workshop.core.skin.Skin;
import moe.plushie.armourers_workshop.core.skin.data.serialize.SkinSerializer;
import moe.plushie.armourers_workshop.core.skin.exception.InvalidCubeTypeException;
import moe.plushie.armourers_workshop.core.skin.exception.NewerFileVersionException;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperties;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperty;
import moe.plushie.armourers_workshop.init.ModLog;
import moe.plushie.armourers_workshop.init.platform.EnvironmentManager;
import moe.plushie.armourers_workshop.utils.SkinFileUtils;
import moe.plushie.armourers_workshop.utils.StreamUtils;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.ITextComponent;
import org.apache.logging.log4j.util.Strings;
import org.jetbrains.annotations.Nullable;

public final class SkinIOUtils {
    public static boolean saveSkinToFile(File file, Skin skin) {
        ModLog.debug("save skin into '{}'", file);
        try {
            SkinFileUtils.forceMkdirParent(file);
            if (file.exists()) {
                SkinFileUtils.deleteQuietly(file);
            }
            FileOutputStream fos = new FileOutputStream(file);
            SkinIOUtils.saveSkinToStream(fos, skin);
            fos.close();
        }
        catch (FileNotFoundException e) {
            ModLog.warn("skin file not found.", new Object[0]);
            e.printStackTrace();
            return false;
        }
        catch (IOException e) {
            ModLog.error("skin file save failed.", new Object[0]);
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static boolean saveSkinToStream(OutputStream outputStream, Skin skin) {
        try (BufferedOutputStream bos = new BufferedOutputStream(outputStream);
             DataOutputStream dos = new DataOutputStream(bos);){
            SkinSerializer.writeToStream(skin, dos);
            dos.flush();
            bos.flush();
        }
        catch (IOException e) {
            ModLog.error("Skin file save failed.", new Object[0]);
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static Skin loadSkinFromFile(File file) {
        Skin skin = null;
        try (FileInputStream fis = new FileInputStream(file);){
            skin = SkinIOUtils.loadSkinFromStream(fis);
        }
        catch (FileNotFoundException e) {
            ModLog.warn("Skin file not found. {}", file);
        }
        catch (IOException e) {
            ModLog.error("Skin file load failed.", new Object[0]);
            e.printStackTrace();
        }
        catch (Exception e) {
            ModLog.error("Unable to load skin. Unknown error.", new Object[0]);
            e.printStackTrace();
        }
        return skin;
    }

    public static Skin loadSkinFromStream(InputStream inputStream) {
        Skin skin = null;
        try {
            skin = SkinIOUtils.loadSkinFromStream2(inputStream);
        }
        catch (IOException e) {
            ModLog.error("Skin file load failed.", new Object[0]);
            e.printStackTrace();
        }
        catch (NewerFileVersionException e) {
            ModLog.error("Can not load skin file it was saved in newer version.", new Object[0]);
            e.printStackTrace();
        }
        catch (InvalidCubeTypeException e) {
            ModLog.error("Unable to load skin. Unknown cube types found.", new Object[0]);
            e.printStackTrace();
        }
        catch (Exception e) {
            ModLog.error("Unable to load skin. Unknown error.", new Object[0]);
            e.printStackTrace();
        }
        return skin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Skin loadSkinFromStream2(InputStream inputStream) throws Exception {
        if (inputStream == null) {
            return null;
        }
        Skin skin = null;
        BufferedInputStream bis = new BufferedInputStream(inputStream);
        DataInputStream dis = new DataInputStream(bis);
        try {
            skin = SkinSerializer.readSkinFromStream(dis);
        }
        catch (Throwable throwable) {
            StreamUtils.closeQuietly(dis, bis);
            throw throwable;
        }
        StreamUtils.closeQuietly(dis, bis);
        return skin;
    }

    private static Skin loadSkinRecovery(File file) {
        Skin skin = null;
        try {
            byte[] fileBytes = Files.readAllBytes(file.toPath());
            ArrayList<Integer> indexes = new ArrayList<Integer>();
            for (int i = 0; i < fileBytes.length; ++i) {
                if (fileBytes[i] != 10 || fileBytes[i - 1] == 0) continue;
                indexes.add(i - 1);
            }
            byte[] newFile = new byte[fileBytes.length - indexes.size()];
            int newFileIndex = 0;
            for (int i = 0; i < fileBytes.length; ++i) {
                if (SkinIOUtils.isInArrayList(i, indexes)) continue;
                newFile[newFileIndex] = fileBytes[i];
                ++newFileIndex;
            }
            ByteArrayInputStream bais = new ByteArrayInputStream(newFile);
            skin = SkinIOUtils.loadSkinFromStream(bais);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return skin;
    }

    private static boolean isInArrayList(int index, ArrayList<Integer> list) {
        for (int j = 0; j < list.size(); ++j) {
            if (index != list.get(j)) continue;
            return true;
        }
        return false;
    }

    /*
     * Exception decompiling
     */
    @Nullable
    public static ISkinFileHeader readHeaderFromFile(File file) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static boolean createDirectory(File file) {
        if (!file.exists()) {
            return file.mkdirs();
        }
        return true;
    }

    public static void recoverSkins(PlayerEntity player) {
        SystemMessageProvider.sendSystemMessage(player, (ITextComponent)TranslatableProvider.literal(ITextComponent.class, "Starting skin recovery."));
        File skinDir = EnvironmentManager.getSkinDatabaseDirectory();
        if (skinDir.exists() & skinDir.isDirectory()) {
            File recoverDir = new File(System.getProperty("user.dir"), "recovered-skins");
            if (!recoverDir.exists()) {
                recoverDir.mkdirs();
            }
            File[] skinFiles = skinDir.listFiles();
            SystemMessageProvider.sendSystemMessage(player, (ITextComponent)TranslatableProvider.literal(ITextComponent.class, String.format("Found %d skins to be recovered.", skinFiles.length)));
            SystemMessageProvider.sendSystemMessage(player, (ITextComponent)TranslatableProvider.literal(ITextComponent.class, "Working..."));
            int unnamedSkinCount = 0;
            int successCount = 0;
            int failCount = 0;
            for (int i = 0; i < skinFiles.length; ++i) {
                File skinFile = skinFiles[i];
                Skin skin = SkinIOUtils.loadSkinFromFile(skinFile);
                if (skin != null) {
                    int nameCount;
                    File newSkinFile;
                    SkinProperties properties = skin.getProperties();
                    String fileName = (String)properties.get(null);
                    String customName = properties.get(SkinProperty.ALL_CUSTOM_NAME);
                    if (Strings.isNotEmpty((CharSequence)fileName)) {
                        newSkinFile = new File(recoverDir, (fileName = SkinIOUtils.makeFileNameValid(fileName)) + ".armour");
                        if (newSkinFile.exists()) {
                            nameCount = 0;
                            while ((newSkinFile = new File(recoverDir, fileName + "-" + ++nameCount + ".armour")).exists()) {
                            }
                        }
                        SkinIOUtils.saveSkinToFile(newSkinFile, skin);
                        ++successCount;
                        continue;
                    }
                    if (Strings.isNotEmpty((CharSequence)customName)) {
                        newSkinFile = new File(recoverDir, (customName = SkinIOUtils.makeFileNameValid(customName)) + ".armour");
                        if (newSkinFile.exists()) {
                            nameCount = 0;
                            while ((newSkinFile = new File(recoverDir, customName + "-" + ++nameCount + ".armour")).exists()) {
                            }
                        }
                        SkinIOUtils.saveSkinToFile(newSkinFile, skin);
                        ++successCount;
                        continue;
                    }
                    SkinIOUtils.saveSkinToFile(new File(recoverDir, "unnamed-skin-" + ++unnamedSkinCount + ".armour"), skin);
                    ++successCount;
                    continue;
                }
                ++failCount;
            }
            SystemMessageProvider.sendSystemMessage(player, (ITextComponent)TranslatableProvider.literal(ITextComponent.class, "Finished skin recovery."));
            SystemMessageProvider.sendSystemMessage(player, (ITextComponent)TranslatableProvider.literal(ITextComponent.class, String.format("%d skins were recovered and %d fail recovery.", successCount, failCount)));
        } else {
            SystemMessageProvider.sendSystemMessage(player, (ITextComponent)TranslatableProvider.literal(ITextComponent.class, "No skins found to recover."));
        }
    }

    public static void updateSkins(PlayerEntity player) {
        File updateDir = new File(System.getProperty("user.dir"), "skin-update");
        if (!updateDir.exists() & updateDir.isDirectory()) {
            SystemMessageProvider.sendSystemMessage(player, (ITextComponent)TranslatableProvider.literal(ITextComponent.class, "Directory skin-update not found."));
            return;
        }
        File outputDir = new File(updateDir, "updated");
        if (!outputDir.exists()) {
            outputDir.mkdir();
        }
        File[] skinFiles = updateDir.listFiles();
        SystemMessageProvider.sendSystemMessage(player, (ITextComponent)TranslatableProvider.literal(ITextComponent.class, String.format("Found %d skins to be updated.", skinFiles.length)));
        SystemMessageProvider.sendSystemMessage(player, (ITextComponent)TranslatableProvider.literal(ITextComponent.class, "Working..."));
        int successCount = 0;
        int failCount = 0;
        for (File skinFile : skinFiles) {
            if (!skinFile.isFile()) continue;
            Skin skin = SkinIOUtils.loadSkinFromFile(skinFile);
            if (skin != null) {
                if (SkinIOUtils.saveSkinToFile(new File(outputDir, skinFile.getName()), skin)) {
                    ++successCount;
                    continue;
                }
                ModLog.error("Failed to update skin " + skinFile.getName(), new Object[0]);
                ++failCount;
                continue;
            }
            ModLog.error("Failed to update skin " + skinFile.getName(), new Object[0]);
            ++failCount;
        }
        SystemMessageProvider.sendSystemMessage(player, (ITextComponent)TranslatableProvider.literal(ITextComponent.class, "Finished skin update."));
        SystemMessageProvider.sendSystemMessage(player, (ITextComponent)TranslatableProvider.literal(ITextComponent.class, String.format("%d skins were updated and %d failed.", successCount, failCount)));
    }

    public static boolean isInSubDirectory(File dir, File file) {
        if (file == null) {
            return false;
        }
        if (file.isDirectory()) {
            // empty if block
        }
        if (file.getParentFile().equals(dir)) {
            return true;
        }
        return SkinIOUtils.isInSubDirectory(dir, file.getParentFile());
    }

    public static String makeFileNameValid(String fileName) {
        fileName = fileName.replaceAll("[<>:\"/\\\\|?*]", "_");
        return fileName;
    }

    public static String makeFilePathValid(String filePath) {
        filePath = filePath.replace("\\", "/");
        filePath = filePath.replace("../", "_");
        filePath = filePath.replaceAll("[<>:\"|?*]", "_");
        return filePath;
    }
}

