/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.utils;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.stream.JsonReader;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import moe.plushie.armourers_workshop.api.data.IDataPackObject;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.Nullable;

public final class StreamUtils {
    private static final Gson GSON = new Gson();

    private StreamUtils() {
    }

    public static String readString(DataInputStream stream, Charset charset) throws IOException {
        int size = StreamUtils.readUnsignedShort(stream);
        byte[] bytes = new byte[size];
        stream.readFully(bytes, 0, size);
        return new String(bytes, charset);
    }

    public static int readBuffer(InputStream stream, byte[] buffer, int offset, int length) throws IOException {
        int index;
        for (index = 0; index < length; index += length) {
            int readSize = stream.read(buffer, offset + index, length - index);
            if (readSize > 0) continue;
            throw new EOFException();
        }
        return index;
    }

    @Nullable
    public static <T> T fromJson(InputStream inputStream, Class<T> class_) {
        try {
            JsonReader jsonReader = new JsonReader((Reader)new InputStreamReader(inputStream, StandardCharsets.UTF_8));
            jsonReader.setLenient(false);
            return (T)GSON.getAdapter(class_).read(jsonReader);
        }
        catch (Exception exception) {
            throw new JsonParseException((Throwable)exception);
        }
    }

    @Nullable
    public static IDataPackObject fromPackObject(InputStream inputStream) {
        JsonObject object = StreamUtils.fromJson(inputStream, JsonObject.class);
        if (object != null) {
            return IDataPackObject.of((JsonElement)object);
        }
        return null;
    }

    public static byte[] toByteArray(InputStream input) throws IOException {
        return IOUtils.toByteArray((InputStream)input);
    }

    public static String toString(InputStream input, Charset encoding) throws IOException {
        return IOUtils.toString((InputStream)input, (Charset)encoding);
    }

    public static void closeQuietly(Closeable ... closeables) {
        if (closeables == null) {
            return;
        }
        for (Closeable closeable : closeables) {
            try {
                if (closeable == null) continue;
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static int readUnsignedShort(DataInputStream stream) throws IOException {
        return stream.readShort() & 0xFFFF;
    }
}

