/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.utils.math;

import moe.plushie.armourers_workshop.api.math.IMatrix4f;
import moe.plushie.armourers_workshop.utils.math.OpenRay;
import moe.plushie.armourers_workshop.utils.math.Rectangle3f;
import moe.plushie.armourers_workshop.utils.math.Vector3f;

public class OpenAABB {
    public static final OpenAABB ZERO = new OpenAABB(Vector3f.ZERO, Vector3f.ZERO);
    private Vector3f min;
    private Vector3f max;

    public OpenAABB(Vector3f min, Vector3f max) {
        this.min = min;
        this.max = max;
    }

    public OpenAABB(Rectangle3f rect) {
        this.min = new Vector3f(rect.getMinX(), rect.getMinY(), rect.getMinZ());
        this.max = new Vector3f(rect.getMaxX(), rect.getMaxY(), rect.getMaxZ());
    }

    public void transform(IMatrix4f matrix) {
        this.min = this.min.transforming(matrix);
        this.max = this.max.transforming(matrix);
    }

    public boolean intersects(OpenRay ray) {
        return ray.intersects(this.min.getX(), this.min.getY(), this.min.getZ(), this.max.getX(), this.max.getY(), this.max.getZ());
    }

    public OpenAABB transforming(IMatrix4f matrix) {
        OpenAABB ret = this.copy();
        ret.transform(matrix);
        return ret;
    }

    public OpenAABB copy() {
        return new OpenAABB(this.min, this.max);
    }
}

