/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.utils.math;

import java.util.Iterator;
import java.util.Objects;
import moe.plushie.armourers_workshop.api.math.IRectangle3f;
import moe.plushie.armourers_workshop.api.math.IRectangle3i;
import moe.plushie.armourers_workshop.utils.math.Vector3i;

public class Rectangle3i
implements IRectangle3i {
    public static final Rectangle3i ZERO = new Rectangle3i(0, 0, 0, 0, 0, 0);
    private int x;
    private int y;
    private int z;
    private int width;
    private int height;
    private int depth;

    public Rectangle3i(int x, int y, int z, int width, int height, int depth) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.width = width;
        this.height = height;
        this.depth = depth;
    }

    public Rectangle3i(IRectangle3i rect) {
        this(rect.getX(), rect.getY(), rect.getZ(), rect.getWidth(), rect.getHeight(), rect.getDepth());
    }

    public Rectangle3i(IRectangle3f rect) {
        this((int)rect.getX(), (int)rect.getY(), (int)rect.getZ(), (int)rect.getWidth(), (int)rect.getHeight(), (int)rect.getDepth());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Rectangle3i that = (Rectangle3i)o;
        return this.x == that.x && this.y == that.y && this.z == that.z && this.width == that.width && this.height == that.height && this.depth == that.depth;
    }

    public int hashCode() {
        return Objects.hash(this.x, this.y, this.z, this.width, this.height, this.depth);
    }

    @Override
    public int getX() {
        return this.x;
    }

    public void setX(int x) {
        this.x = x;
    }

    @Override
    public int getY() {
        return this.y;
    }

    public void setY(int y) {
        this.y = y;
    }

    @Override
    public int getZ() {
        return this.z;
    }

    public void setZ(int z) {
        this.z = z;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    @Override
    public int getDepth() {
        return this.depth;
    }

    public void setDepth(int depth) {
        this.depth = depth;
    }

    @Override
    public int getMinX() {
        return this.x;
    }

    @Override
    public int getMinY() {
        return this.y;
    }

    @Override
    public int getMinZ() {
        return this.z;
    }

    @Override
    public int getMidX() {
        return this.x + this.width / 2;
    }

    @Override
    public int getMidY() {
        return this.y + this.height / 2;
    }

    @Override
    public int getMidZ() {
        return this.z + this.depth / 2;
    }

    @Override
    public int getMaxX() {
        return this.x + this.width;
    }

    @Override
    public int getMaxY() {
        return this.y + this.height;
    }

    @Override
    public int getMaxZ() {
        return this.z + this.depth;
    }

    public Vector3i getOrigin() {
        return new Vector3i(this.x, this.y, this.z);
    }

    public void union(Rectangle3i rect) {
        int x1 = Math.min(this.getMinX(), rect.getMinX());
        int y1 = Math.min(this.getMinY(), rect.getMinY());
        int z1 = Math.min(this.getMinZ(), rect.getMinZ());
        int x2 = Math.max(this.getMaxX(), rect.getMaxX());
        int y2 = Math.max(this.getMaxY(), rect.getMaxY());
        int z2 = Math.max(this.getMaxZ(), rect.getMaxZ());
        this.x = x1;
        this.y = y1;
        this.z = z1;
        this.width = x2 - x1;
        this.height = y2 - y1;
        this.depth = z2 - z1;
    }

    public boolean contains(Vector3i point) {
        int x = point.getX();
        int y = point.getY();
        int z = point.getZ();
        return this.getMinX() <= x && x <= this.getMaxX() && this.getMinY() <= y && y <= this.getMaxY() && this.getMinZ() <= z && z <= this.getMaxZ();
    }

    public Rectangle3i offset(Vector3i point) {
        return this.offset(point.getX(), point.getY(), point.getZ());
    }

    public Rectangle3i offset(int tx, int ty, int tz) {
        return new Rectangle3i(this.x + tx, this.y + ty, this.z + tz, this.width, this.height, this.depth);
    }

    public Iterable<Vector3i> enumerateZYX() {
        return () -> new Iterator<Vector3i>(){
            int ix = 0;
            int iy = 0;
            int iz = 0;

            @Override
            public boolean hasNext() {
                return this.ix < Rectangle3i.this.width && this.iy < Rectangle3i.this.height && this.iz < Rectangle3i.this.depth;
            }

            @Override
            public Vector3i next() {
                int dx = this.ix + Rectangle3i.this.x;
                int dy = this.iy + Rectangle3i.this.y;
                int dz = this.iz + Rectangle3i.this.z;
                ++this.iz;
                if (this.iz >= Rectangle3i.this.depth) {
                    this.iz = 0;
                    ++this.iy;
                }
                if (this.iy >= Rectangle3i.this.height) {
                    this.iy = 0;
                    ++this.ix;
                }
                return new Vector3i(dx, dy, dz);
            }
        };
    }

    public String toString() {
        return String.format("(%d %d %d; %d %d %d)", this.x, this.y, this.z, this.width, this.height, this.depth);
    }
}

