#version 150

in vec3 Position;
in vec4 Color;
in ivec2 UV2;

uniform sampler2D Sampler2;

uniform mat4 ModelViewMat;
uniform mat4 ProjMat;
uniform vec4 ColorModulator;

out float vertexDistance;
flat out vec4 vertexColor;

void main() {
    //Fix by DartCat25
    gl_Position = ProjMat * ModelViewMat * vec4(Position, 1.0);

    vertexDistance = length((ModelViewMat * vec4(Position, 1.0)).xyz);

    vertexColor = Color * ColorModulator * texelFetch(Sampler2, UV2 / 16, 0) * float((gl_VertexID) % 100 > 1);
}
