/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.common.permission;

import java.util.ArrayList;
import moe.plushie.armourers_workshop.common.init.blocks.ModBlocks;
import moe.plushie.armourers_workshop.common.init.items.ModItems;
import moe.plushie.armourers_workshop.common.permission.IPermissionHolder;
import moe.plushie.armourers_workshop.common.permission.Permission;
import moe.plushie.armourers_workshop.utils.ModLogger;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraftforge.server.permission.DefaultPermissionLevel;
import net.minecraftforge.server.permission.PermissionAPI;

public final class PermissionManager {
    public static ArrayList<Permission> getPermissions() {
        ArrayList<Permission> permissions = new ArrayList<Permission>();
        for (Block block : ModBlocks.BLOCK_LIST) {
            if (!(block instanceof IPermissionHolder)) continue;
            ((IPermissionHolder)block).getPermissions(permissions);
        }
        for (Item item : ModItems.ITEM_LIST) {
            if (!(item instanceof IPermissionHolder)) continue;
            ((IPermissionHolder)item).getPermissions(permissions);
        }
        ArrayList<Permission> permissionsDedup = new ArrayList<Permission>();
        for (Permission permission : permissions) {
            if (permissionsDedup.contains(permission)) continue;
            permissionsDedup.add(permission);
        }
        return permissionsDedup;
    }

    public static void registerPermissions() {
        ArrayList<Permission> permissions = PermissionManager.getPermissions();
        for (Permission permission : permissions) {
            ModLogger.log("Registering permission: " + permission.node);
            PermissionAPI.registerNode((String)permission.node, (DefaultPermissionLevel)permission.level, (String)permission.description);
        }
    }
}

