/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.common.world;

import moe.plushie.armourers_workshop.common.world.AsyncWorldUpdate;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public final class AsyncWorldUpdateBlock
extends AsyncWorldUpdate {
    private final IBlockState state;
    private boolean onlyReplaceable;
    private TileEntity tileEntity;

    public AsyncWorldUpdateBlock(IBlockState state, BlockPos pos, World world) {
        this(state, pos, world.field_73011_w.getDimension());
    }

    public AsyncWorldUpdateBlock(IBlockState state, BlockPos pos, int dimensionId) {
        super(pos, dimensionId);
        this.state = state;
        this.onlyReplaceable = false;
    }

    public AsyncWorldUpdateBlock setTileEntity(TileEntity tileEntity) {
        this.tileEntity = tileEntity;
        return this;
    }

    public AsyncWorldUpdateBlock setOnlyReplaceable(boolean onlyReplaceable) {
        this.onlyReplaceable = onlyReplaceable;
        return this;
    }

    public IBlockState getState() {
        return this.state;
    }

    @Override
    public void doUpdate(World world) {
        boolean canPlace = true;
        if (this.onlyReplaceable) {
            IBlockState target = world.func_180495_p(this.pos);
            if (!target.func_177230_c().func_176200_f((IBlockAccess)world, this.pos)) {
                canPlace = false;
            }
            if (target.func_177230_c() == this.state.func_177230_c()) {
                canPlace = true;
            }
        }
        if (canPlace) {
            world.func_180501_a(this.pos, this.state, 2);
            if (this.tileEntity != null) {
                world.func_175690_a(this.getPos(), this.tileEntity);
            }
        }
    }

    public String toString() {
        return "AsyncWorldUpdateBlock [state=" + this.state + ", onlyReplaceable=" + this.onlyReplaceable + ", tileEntity=" + this.tileEntity + ", pos=" + this.pos + ", dimensionId=" + this.dimensionId + ", delay=" + this.delay + "]";
    }
}

