/*
 * Decompiled with CFR 0.152.
 */
package lumien.chunkanimator.handler;

import java.util.WeakHashMap;
import lumien.chunkanimator.ChunkAnimator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.chunk.RenderChunk;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import penner.easing.Back;
import penner.easing.Bounce;
import penner.easing.Circ;
import penner.easing.Cubic;
import penner.easing.Elastic;
import penner.easing.Expo;
import penner.easing.Linear;
import penner.easing.Quad;
import penner.easing.Quart;
import penner.easing.Quint;
import penner.easing.Sine;

public class AnimationHandler {
    WeakHashMap<RenderChunk, AnimationData> timeStamps = new WeakHashMap();

    public void preRender(RenderChunk renderChunk) {
        if (this.timeStamps.containsKey(renderChunk)) {
            int animationDuration;
            long timeDif;
            AnimationData animationData = this.timeStamps.get(renderChunk);
            long time = animationData.timeStamp;
            int mode = ChunkAnimator.INSTANCE.config.getMode();
            if (time == -1L) {
                animationData.timeStamp = time = System.currentTimeMillis();
                if (mode == 4) {
                    int difZ;
                    BlockPos zeroedCenteredChunkPos;
                    BlockPos zeroedPlayerPosition = Minecraft.func_71410_x().field_71439_g.func_180425_c();
                    BlockPos dif = (zeroedPlayerPosition = zeroedPlayerPosition.func_177982_a(0, -zeroedPlayerPosition.func_177956_o(), 0)).func_177973_b((Vec3i)(zeroedCenteredChunkPos = renderChunk.func_178568_j().func_177982_a(8, -renderChunk.func_178568_j().func_177956_o(), 8)));
                    int difX = Math.abs(dif.func_177958_n());
                    EnumFacing chunkFacing = difX > (difZ = Math.abs(dif.func_177952_p())) ? (dif.func_177958_n() > 0 ? EnumFacing.EAST : EnumFacing.WEST) : (dif.func_177952_p() > 0 ? EnumFacing.SOUTH : EnumFacing.NORTH);
                    animationData.chunkFacing = chunkFacing;
                }
            }
            if ((timeDif = System.currentTimeMillis() - time) < (long)(animationDuration = ChunkAnimator.INSTANCE.config.getAnimationDuration())) {
                int chunkY = renderChunk.func_178568_j().func_177956_o();
                if (mode == 2) {
                    mode = (double)chunkY < Minecraft.func_71410_x().field_71441_e.field_73011_w.getHorizon() ? 0 : 1;
                }
                if (mode == 4) {
                    mode = 3;
                }
                switch (mode) {
                    case 0: {
                        GlStateManager.func_179109_b((float)0.0f, (float)((float)(-chunkY) + this.getFunctionValue(timeDif, 0.0f, chunkY, animationDuration)), (float)0.0f);
                        break;
                    }
                    case 1: {
                        GlStateManager.func_179109_b((float)0.0f, (float)((float)(256 - chunkY) - this.getFunctionValue(timeDif, 0.0f, 256 - chunkY, animationDuration)), (float)0.0f);
                        break;
                    }
                    case 3: {
                        EnumFacing chunkFacing = animationData.chunkFacing;
                        if (chunkFacing == null) break;
                        Vec3i vec = chunkFacing.func_176730_m();
                        double mod = -(200.0 - 200.0 / (double)animationDuration * (double)timeDif);
                        mod = -(200.0f - this.getFunctionValue(timeDif, 0.0f, 200.0f, animationDuration));
                        GlStateManager.func_179137_b((double)((double)vec.func_177958_n() * mod), (double)0.0, (double)((double)vec.func_177952_p() * mod));
                    }
                }
            } else {
                this.timeStamps.remove(renderChunk);
            }
        }
    }

    private float getFunctionValue(float t, float b, float c, float d) {
        switch (ChunkAnimator.INSTANCE.config.getEasingFunction()) {
            case 0: {
                return Linear.easeOut(t, b, c, d);
            }
            case 1: {
                return Quad.easeOut(t, b, c, d);
            }
            case 2: {
                return Cubic.easeOut(t, b, c, d);
            }
            case 3: {
                return Quart.easeOut(t, b, c, d);
            }
            case 4: {
                return Quint.easeOut(t, b, c, d);
            }
            case 5: {
                return Expo.easeOut(t, b, c, d);
            }
            case 6: {
                return Sine.easeOut(t, b, c, d);
            }
            case 7: {
                return Circ.easeOut(t, b, c, d);
            }
            case 8: {
                return Back.easeOut(t, b, c, d);
            }
            case 9: {
                return Bounce.easeOut(t, b, c, d);
            }
            case 10: {
                return Elastic.easeOut(t, b, c, d);
            }
        }
        return Sine.easeOut(t, b, c, d);
    }

    public void setOrigin(RenderChunk renderChunk, BlockPos position) {
        if (Minecraft.func_71410_x().field_71439_g != null) {
            boolean flag = true;
            BlockPos zeroedPlayerPosition = Minecraft.func_71410_x().field_71439_g.func_180425_c();
            zeroedPlayerPosition = zeroedPlayerPosition.func_177982_a(0, -zeroedPlayerPosition.func_177956_o(), 0);
            BlockPos zeroedCenteredChunkPos = position.func_177982_a(8, -position.func_177956_o(), 8);
            if (ChunkAnimator.INSTANCE.config.disableAroundPlayer()) {
                boolean bl = flag = zeroedPlayerPosition.func_177951_i((Vec3i)zeroedCenteredChunkPos) > 4096.0;
            }
            if (flag) {
                EnumFacing chunkFacing = null;
                if (ChunkAnimator.INSTANCE.config.getMode() == 3) {
                    int difZ;
                    BlockPos dif = zeroedPlayerPosition.func_177973_b((Vec3i)zeroedCenteredChunkPos);
                    int difX = Math.abs(dif.func_177958_n());
                    chunkFacing = difX > (difZ = Math.abs(dif.func_177952_p())) ? (dif.func_177958_n() > 0 ? EnumFacing.EAST : EnumFacing.WEST) : (dif.func_177952_p() > 0 ? EnumFacing.SOUTH : EnumFacing.NORTH);
                }
                AnimationData animationData = new AnimationData(-1L, chunkFacing);
                this.timeStamps.put(renderChunk, animationData);
            } else if (this.timeStamps.containsKey(renderChunk)) {
                this.timeStamps.remove(renderChunk);
            }
        }
    }

    private class AnimationData {
        public long timeStamp;
        public EnumFacing chunkFacing;

        public AnimationData(long timeStamp, EnumFacing chunkFacing) {
            this.timeStamp = timeStamp;
            this.chunkFacing = chunkFacing;
        }
    }
}

