/*
 * Decompiled with CFR 0.152.
 */
package net.teamfruit.lib.com.mojang.brigadier.arguments;

import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import net.teamfruit.lib.com.mojang.brigadier.StringReader;
import net.teamfruit.lib.com.mojang.brigadier.arguments.ArgumentType;
import net.teamfruit.lib.com.mojang.brigadier.context.CommandContext;
import net.teamfruit.lib.com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.teamfruit.lib.com.mojang.brigadier.suggestion.Suggestions;
import net.teamfruit.lib.com.mojang.brigadier.suggestion.SuggestionsBuilder;

public class BoolArgumentType
implements ArgumentType<Boolean> {
    private static final Collection<String> EXAMPLES = Arrays.asList("true", "false");

    private BoolArgumentType() {
    }

    public static BoolArgumentType bool() {
        return new BoolArgumentType();
    }

    public static boolean getBool(CommandContext<?> context, String name) {
        return context.getArgument(name, Boolean.class);
    }

    @Override
    public Boolean parse(StringReader reader) throws CommandSyntaxException {
        return reader.readBoolean();
    }

    @Override
    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        if ("true".startsWith(builder.getRemaining().toLowerCase())) {
            builder.suggest("true");
        }
        if ("false".startsWith(builder.getRemaining().toLowerCase())) {
            builder.suggest("false");
        }
        return builder.buildFuture();
    }

    @Override
    public Collection<String> getExamples() {
        return EXAMPLES;
    }
}

