/*
 * Decompiled with CFR 0.152.
 */
package kamkeel.command;

import foxz.utils.Utils;
import java.util.List;
import kamkeel.command.CommandKamkeelBase;
import net.minecraft.block.Block;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import noppes.npcs.controllers.ServerCloneController;
import noppes.npcs.entity.EntityNPCInterface;

public class CloneCommand
extends CommandKamkeelBase {
    public String func_71517_b() {
        return "clone";
    }

    @Override
    public String getDescription() {
        return "Clone operation (server side)";
    }

    @CommandKamkeelBase.SubCommand(desc="Add NPC(s) to clone storage", usage="<npc> <tab> [clonedname]", permission=4)
    public void add(ICommandSender sender, String[] args) {
        int tab = 0;
        try {
            tab = Integer.parseInt(args[1]);
            if (tab < 0 || tab > 15) {
                CloneCommand.sendError(sender, "Tab must be within 1-15", new Object[0]);
                return;
            }
        }
        catch (NumberFormatException ex) {
            CloneCommand.sendError(sender, String.format("Tab is not a number: %s", args[1]), new Object[0]);
            return;
        }
        int x = sender.func_82114_b().field_71574_a;
        int y = sender.func_82114_b().field_71572_b;
        int z = sender.func_82114_b().field_71573_c;
        List<EntityNPCInterface> list = this.getEntities(EntityNPCInterface.class, sender.func_130014_f_(), x, y, z, 80);
        for (EntityNPCInterface npc : list) {
            NBTTagCompound compound;
            if (!npc.display.getName().equalsIgnoreCase(args[0])) continue;
            String name = npc.display.getName();
            if (args.length > 2) {
                name = args[2];
            }
            if (!npc.func_70039_c(compound = new NBTTagCompound())) {
                return;
            }
            ServerCloneController.Instance.addClone(compound, name, tab);
            CloneCommand.sendResult(sender, String.format("Added NPC \u00a7e%s\u00a77 to Tab \u00a7b%d\u00a77", name, tab), new Object[0]);
        }
    }

    @CommandKamkeelBase.SubCommand(desc="List NPC from clone storage", usage="<tab>", permission=2)
    public void list(ICommandSender sender, String[] args) {
        CloneCommand.sendMessage(sender, "--- Stored NPCs --- (server side)", new Object[0]);
        int tab = 0;
        try {
            tab = Integer.parseInt(args[1]);
            if (tab < 0 || tab > 15) {
                CloneCommand.sendError(sender, "Tab must be within 1-15", new Object[0]);
                return;
            }
        }
        catch (NumberFormatException ex) {
            CloneCommand.sendError(sender, String.format("Tab is not a number: %s", args[1]), new Object[0]);
            return;
        }
        for (String name : ServerCloneController.Instance.getClones(tab)) {
            CloneCommand.sendMessage(sender, name, new Object[0]);
        }
        CloneCommand.sendMessage(sender, "------------------------------------", new Object[0]);
    }

    @CommandKamkeelBase.SubCommand(desc="Remove NPC from clone storage", usage="<name> <tab>", permission=4)
    public void del(ICommandSender sender, String[] args) throws CommandException {
        String nametodel = args[0];
        int tab = 0;
        try {
            tab = Integer.parseInt(args[1]);
            if (tab < 0 || tab > 15) {
                CloneCommand.sendError(sender, String.format("Tab must be within 1-15", new Object[0]), new Object[0]);
                return;
            }
        }
        catch (NumberFormatException ex) {
            CloneCommand.sendError(sender, String.format("Tab is not a number: %s", args[1]), new Object[0]);
            return;
        }
        boolean deleted = false;
        for (String name : ServerCloneController.Instance.getClones(tab)) {
            if (!nametodel.equalsIgnoreCase(name)) continue;
            ServerCloneController.Instance.removeClone(name, tab);
            deleted = true;
            break;
        }
        if (!ServerCloneController.Instance.removeClone(nametodel, tab)) {
            CloneCommand.sendError(sender, String.format("NPC '%s' was not found", nametodel), new Object[0]);
        } else {
            CloneCommand.sendResult(sender, String.format("Removed NPC \u00a7e%s\u00a77 from Tab \u00a7b%d\u00a77", nametodel, tab), new Object[0]);
        }
    }

    @CommandKamkeelBase.SubCommand(desc="Spawn cloned NPC", usage="<name> <tab> [[world:]x,y,z]] [newname]", permission=2)
    public void spawn(ICommandSender sender, String[] args) throws CommandException {
        String name = args[0].replaceAll("%", " ");
        int tab = 0;
        try {
            tab = Integer.parseInt(args[1]);
            if (tab < 0 || tab > 15) {
                CloneCommand.sendError(sender, String.format("Tab must be within 1-15", new Object[0]), new Object[0]);
                return;
            }
        }
        catch (NumberFormatException ex) {
            CloneCommand.sendError(sender, String.format("Tab is not a number: %s", args[1]), new Object[0]);
            return;
        }
        String newname = null;
        NBTTagCompound compound = ServerCloneController.Instance.getCloneData(sender, name, tab);
        if (compound == null) {
            CloneCommand.sendError(sender, "Unknown npc", new Object[0]);
            return;
        }
        World world = sender.func_130014_f_();
        double posX = sender.func_82114_b().field_71574_a;
        double posY = sender.func_82114_b().field_71572_b;
        double posZ = sender.func_82114_b().field_71573_c;
        if (args.length > 2) {
            String[] par;
            String location = args[2];
            if (location.contains(":")) {
                par = location.split(":");
                location = par[1];
                world = Utils.getWorld(par[0]);
                if (world == null) {
                    CloneCommand.sendError(sender, String.format("'%s' is an unknown world", par[0]), new Object[0]);
                    return;
                }
            }
            if (location.contains(",")) {
                par = location.split(",");
                if (par.length != 3) {
                    CloneCommand.sendError(sender, "Location need be x,y,z", new Object[0]);
                    return;
                }
                try {
                    posX = CommandBase.func_110666_a((ICommandSender)sender, (double)posX, (String)par[0]);
                    posY = CommandBase.func_110665_a((ICommandSender)sender, (double)posY, (String)par[1].trim(), (int)0, (int)0);
                    posZ = CommandBase.func_110666_a((ICommandSender)sender, (double)posZ, (String)par[2]);
                }
                catch (NumberFormatException ex) {
                    CloneCommand.sendError(sender, "Location should be in numbers", new Object[0]);
                    return;
                }
                if (args.length > 3) {
                    newname = args[3];
                }
            } else {
                newname = location;
            }
        }
        if (posX == 0.0 && posY == 0.0 && posZ == 0.0) {
            CloneCommand.sendError(sender, "Location needed", new Object[0]);
            return;
        }
        Entity entity = EntityList.func_75615_a((NBTTagCompound)compound, (World)world);
        entity.func_70107_b(posX + 0.5, posY + 1.0, posZ + 0.5);
        if (entity instanceof EntityNPCInterface) {
            EntityNPCInterface npc = (EntityNPCInterface)entity;
            npc.ai.startPos = new int[]{MathHelper.func_76128_c((double)posX), MathHelper.func_76128_c((double)posY), MathHelper.func_76128_c((double)posZ)};
            if (newname != null && !newname.isEmpty()) {
                npc.display.name = newname.replaceAll("%", " ");
            }
        }
        world.func_72838_d(entity);
    }

    @CommandKamkeelBase.SubCommand(desc="Spawn cloned NPC", usage="<name> <tab> [[world:]x,y,z]] [newname]", permission=2)
    public void grid(ICommandSender sender, String[] args) throws CommandException {
        int height;
        int width;
        String name = args[0].replaceAll("%", " ");
        int tab = 0;
        try {
            tab = Integer.parseInt(args[1]);
            if (tab < 0 || tab > 15) {
                CloneCommand.sendError(sender, String.format("Tab must be within 1-15", new Object[0]), new Object[0]);
                return;
            }
        }
        catch (NumberFormatException ex) {
            CloneCommand.sendError(sender, String.format("Tab is not a number: %s", args[1]), new Object[0]);
            return;
        }
        try {
            width = Integer.parseInt(args[2]);
            height = Integer.parseInt(args[3]);
        }
        catch (NumberFormatException ex) {
            CloneCommand.sendError(sender, "length or width was not a number", new Object[0]);
            return;
        }
        String newname = null;
        NBTTagCompound compound = ServerCloneController.Instance.getCloneData(sender, name, tab);
        if (compound == null) {
            CloneCommand.sendError(sender, "Unknown npc", new Object[0]);
            return;
        }
        World world = sender.func_130014_f_();
        double posX = sender.func_82114_b().field_71574_a;
        double posY = sender.func_82114_b().field_71572_b;
        double posZ = sender.func_82114_b().field_71573_c;
        if (args.length > 4) {
            String[] par;
            String location = args[4];
            if (location.contains(":")) {
                par = location.split(":");
                location = par[1];
                world = Utils.getWorld(par[0]);
                if (world == null) {
                    CloneCommand.sendError(sender, String.format("'%s' is an unknown world", par[0]), new Object[0]);
                }
            }
            if (location.contains(",")) {
                par = location.split(",");
                if (par.length != 3) {
                    CloneCommand.sendError(sender, "Location need be x,y,z", new Object[0]);
                    return;
                }
                try {
                    posX = CommandBase.func_110666_a((ICommandSender)sender, (double)posX, (String)par[0]);
                    posY = CommandBase.func_110665_a((ICommandSender)sender, (double)posY, (String)par[1].trim(), (int)0, (int)0);
                    posZ = CommandBase.func_110666_a((ICommandSender)sender, (double)posZ, (String)par[2]);
                }
                catch (NumberFormatException ex) {
                    CloneCommand.sendError(sender, "Location should be in numbers", new Object[0]);
                    return;
                }
                if (args.length > 5) {
                    newname = args[5];
                }
            } else {
                newname = location;
            }
        }
        if (posX == 0.0 && posY == 0.0 && posZ == 0.0) {
            CloneCommand.sendError(sender, "Location needed", new Object[0]);
            return;
        }
        for (int x = 0; x < width; ++x) {
            for (int z = 0; z < height; ++z) {
                Entity entity = EntityList.func_75615_a((NBTTagCompound)compound, (World)world);
                int xx = MathHelper.func_76128_c((double)posX) + x;
                int yy = Math.max(MathHelper.func_76128_c((double)posY) - 2, 1);
                int zz = MathHelper.func_76128_c((double)posZ) + z;
                for (int y = 0; y < 10; ++y) {
                    Block b = world.func_147439_a(xx, yy + y, zz);
                    Block b2 = world.func_147439_a(xx, yy + y + 1, zz);
                    if (b == null || b2 != null && b2.func_149668_a(world, xx, yy + y + 1, zz) != null) continue;
                    yy += y;
                    break;
                }
                entity.func_70107_b(posX + 0.5 + (double)x, (double)(yy + 1), posZ + 0.5 + (double)z);
                if (entity instanceof EntityNPCInterface) {
                    EntityNPCInterface npc = (EntityNPCInterface)entity;
                    npc.ai.startPos = new int[]{xx, yy, zz};
                    if (newname != null && !newname.isEmpty()) {
                        npc.display.name = newname.replaceAll("%", " ");
                    }
                }
                world.func_72838_d(entity);
            }
        }
    }

    public World getWorld(String t) {
        WorldServer[] ws;
        for (WorldServer w : ws = MinecraftServer.func_71276_C().field_71305_c) {
            if (w == null || !(w.field_73011_w.field_76574_g + "").equalsIgnoreCase(t)) continue;
            return w;
        }
        return null;
    }

    public <T extends Entity> List<T> getEntities(Class<? extends T> cls, World world, int x, int y, int z, int range) {
        AxisAlignedBB bb = AxisAlignedBB.func_72330_a((double)x, (double)y, (double)z, (double)(x + 1), (double)(y + 1), (double)(z + 1)).func_72314_b((double)range, (double)range, (double)range);
        List list = world.func_72872_a(cls, bb);
        return list;
    }
}

