/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.ChatAllowedCharacters;
import noppes.npcs.NoppesStringUtils;
import noppes.npcs.client.ClientProxy;
import noppes.npcs.client.gui.util.GuiCustomScroll;
import noppes.npcs.client.gui.util.GuiNpcTextField;
import noppes.npcs.client.gui.util.ITextChangeListener;
import noppes.npcs.client.gui.util.TextContainer;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class GuiScriptTextArea
extends GuiNpcTextField {
    public int id;
    public int x;
    public int y;
    public int field_146218_h;
    public int field_146219_i;
    private int cursorCounter;
    private ITextChangeListener listener;
    public String field_146216_j = null;
    private TextContainer container = null;
    public boolean active = false;
    public boolean enabled = true;
    public boolean field_146220_v = true;
    public boolean clicked = false;
    public boolean doubleClicked = false;
    public boolean clickScrolling = false;
    private int startSelection;
    private int endSelection;
    private int cursorPosition;
    private int scrolledLine = 0;
    private boolean enableCodeHighlighting = false;
    public List<UndoData> undoList = new ArrayList<UndoData>();
    public List<UndoData> redoList = new ArrayList<UndoData>();
    public boolean undoing = false;
    private long lastClicked = 0L;

    public GuiScriptTextArea(GuiScreen guiScreen, int id, int x, int y, int width, int height, String text) {
        super(id, guiScreen, x, y, width, height, null);
        this.id = id;
        this.x = x;
        this.y = y;
        this.field_146218_h = width;
        this.field_146219_i = height;
        this.undoing = true;
        this.func_146180_a(text);
        this.undoing = false;
    }

    @Override
    public void drawTextBox(int xMouse, int yMouse) {
        if (!this.field_146220_v) {
            return;
        }
        GuiScriptTextArea.func_73734_a((int)(this.x - 1), (int)(this.y - 1), (int)(this.x + this.field_146218_h + 1), (int)(this.y + this.field_146219_i + 1), (int)-6250336);
        GuiScriptTextArea.func_73734_a((int)this.x, (int)this.y, (int)(this.x + this.field_146218_h), (int)(this.y + this.field_146219_i), (int)-16777216);
        this.container.visibleLines = this.field_146219_i / this.container.lineHeight;
        if (this.clicked) {
            this.clicked = Mouse.isButtonDown((int)0);
            int i = this.getSelectionPos(xMouse, yMouse);
            if (i != this.cursorPosition) {
                if (this.doubleClicked) {
                    this.startSelection = this.endSelection = this.cursorPosition;
                    this.doubleClicked = false;
                }
                this.setCursor(i, true);
            }
        } else if (this.doubleClicked) {
            this.doubleClicked = false;
        }
        if (this.clickScrolling) {
            this.clickScrolling = Mouse.isButtonDown((int)0);
            int diff = this.container.linesCount - this.container.visibleLines;
            this.scrolledLine = Math.min(Math.max((int)(1.0f * (float)diff * (float)(yMouse - this.y) / (float)this.field_146219_i), 0), diff);
        }
        int startBracket = 0;
        int endBracket = 0;
        if (this.endSelection - this.startSelection == 1 || this.startSelection == this.endSelection && this.startSelection < this.field_146216_j.length()) {
            char c = this.field_146216_j.charAt(this.startSelection);
            int found = 0;
            if (c == '{') {
                found = this.findClosingBracket(this.field_146216_j.substring(this.startSelection), '{', '}');
            } else if (c == '[') {
                found = this.findClosingBracket(this.field_146216_j.substring(this.startSelection), '[', ']');
            } else if (c == '(') {
                found = this.findClosingBracket(this.field_146216_j.substring(this.startSelection), '(', ')');
            } else if (c == '}') {
                found = this.findOpeningBracket(this.field_146216_j.substring(0, this.startSelection + 1), '{', '}');
            } else if (c == ']') {
                found = this.findOpeningBracket(this.field_146216_j.substring(0, this.startSelection + 1), '[', ']');
            } else if (c == ')') {
                found = this.findOpeningBracket(this.field_146216_j.substring(0, this.startSelection + 1), '(', ')');
            }
            if (found != 0) {
                startBracket = this.startSelection;
                endBracket = this.startSelection + found;
            }
        }
        ArrayList<TextContainer.LineData> list = new ArrayList<TextContainer.LineData>(this.container.lines);
        String wordHightLight = null;
        if (this.startSelection != this.endSelection) {
            Matcher m = this.container.regexWord.matcher(this.field_146216_j);
            while (m.find()) {
                if (m.start() != this.startSelection || m.end() != this.endSelection) continue;
                wordHightLight = this.field_146216_j.substring(this.startSelection, this.endSelection);
            }
        }
        for (int i = 0; i < list.size(); ++i) {
            int posY;
            int e;
            TextContainer.LineData data = (TextContainer.LineData)list.get(i);
            String line = data.text;
            int w = line.length();
            if (startBracket != endBracket) {
                int s;
                if (startBracket >= data.start && startBracket < data.end) {
                    s = ClientProxy.Font.width(line.substring(0, startBracket - data.start));
                    e = ClientProxy.Font.width(line.substring(0, startBracket - data.start + 1)) + 1;
                    posY = this.y + 1 + (i - this.scrolledLine) * this.container.lineHeight;
                    GuiScriptTextArea.func_73734_a((int)(this.x + 1 + s), (int)posY, (int)(this.x + 1 + e), (int)(posY + this.container.lineHeight + 1), (int)-1728001024);
                }
                if (endBracket >= data.start && endBracket < data.end) {
                    s = ClientProxy.Font.width(line.substring(0, endBracket - data.start));
                    e = ClientProxy.Font.width(line.substring(0, endBracket - data.start + 1)) + 1;
                    posY = this.y + 1 + (i - this.scrolledLine) * this.container.lineHeight;
                    GuiScriptTextArea.func_73734_a((int)(this.x + 1 + s), (int)posY, (int)(this.x + 1 + e), (int)(posY + this.container.lineHeight + 1), (int)-1728001024);
                }
            }
            if (i < this.scrolledLine || i >= this.scrolledLine + this.container.visibleLines) continue;
            if (wordHightLight != null) {
                Matcher m = this.container.regexWord.matcher(line);
                while (m.find()) {
                    if (!line.substring(m.start(), m.end()).equals(wordHightLight)) continue;
                    int s = ClientProxy.Font.width(line.substring(0, m.start()));
                    int e2 = ClientProxy.Font.width(line.substring(0, m.end())) + 1;
                    int posY2 = this.y + 1 + (i - this.scrolledLine) * this.container.lineHeight;
                    GuiScriptTextArea.func_73734_a((int)(this.x + 1 + s), (int)posY2, (int)(this.x + 1 + e2), (int)(posY2 + this.container.lineHeight + 1), (int)-1728033792);
                }
            }
            if (this.startSelection != this.endSelection && this.endSelection > data.start && this.startSelection <= data.end && this.startSelection < data.end) {
                int s = ClientProxy.Font.width(line.substring(0, Math.max(this.startSelection - data.start, 0)));
                e = ClientProxy.Font.width(line.substring(0, Math.min(this.endSelection - data.start, w))) + 1;
                posY = this.y + 1 + (i - this.scrolledLine) * this.container.lineHeight;
                GuiScriptTextArea.func_73734_a((int)(this.x + 1 + s), (int)posY, (int)(this.x + 1 + e), (int)(posY + this.container.lineHeight + 1), (int)-1728052993);
            }
            int yPos = this.y + (i - this.scrolledLine) * this.container.lineHeight + 1;
            data.drawString(this.x + 1, yPos, -2039584);
            if (!this.active || !this.isEnabled() || this.cursorCounter / 6 % 2 != 0 || this.cursorPosition < data.start || this.cursorPosition >= data.end) continue;
            int posX = this.x + ClientProxy.Font.width(line.substring(0, this.cursorPosition - data.start));
            GuiScriptTextArea.func_73734_a((int)(posX + 1), (int)yPos, (int)(posX + 2), (int)(yPos + 1 + this.container.lineHeight), (int)-3092272);
        }
        if (this.hasVerticalScrollbar()) {
            Minecraft.func_71410_x().field_71446_o.func_110577_a(GuiCustomScroll.resource);
            int sbSize = Math.max((int)(1.0f * (float)this.container.visibleLines / (float)this.container.linesCount * (float)this.field_146219_i), 2);
            int posX = this.x + this.field_146218_h - 6;
            int posY = (int)((float)this.y + 1.0f * (float)this.scrolledLine / (float)this.container.linesCount * (float)(this.field_146219_i - 4)) + 1;
            GuiScriptTextArea.func_73734_a((int)posX, (int)posY, (int)(posX + 5), (int)(posY + sbSize), (int)-2039584);
        }
    }

    private int findClosingBracket(String str, char s, char e) {
        int found = 0;
        char[] chars = str.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (c == s) {
                ++found;
                continue;
            }
            if (c != e || --found != 0) continue;
            return i;
        }
        return 0;
    }

    private int findOpeningBracket(String str, char s, char e) {
        int found = 0;
        char[] chars = str.toCharArray();
        for (int i = chars.length - 1; i >= 0; --i) {
            char c = chars[i];
            if (c == e) {
                ++found;
                continue;
            }
            if (c != s || --found != 0) continue;
            return i - chars.length + 1;
        }
        return 0;
    }

    private int getSelectionPos(int xMouse, int yMouse) {
        xMouse -= this.x + 1;
        yMouse -= this.y + 1;
        ArrayList<TextContainer.LineData> list = new ArrayList<TextContainer.LineData>(this.container.lines);
        for (int i = 0; i < list.size(); ++i) {
            int yPos;
            TextContainer.LineData data = list.get(i);
            if (i < this.scrolledLine || i >= this.scrolledLine + this.container.visibleLines || yMouse < (yPos = (i - this.scrolledLine) * this.container.lineHeight) || yMouse >= yPos + this.container.lineHeight) continue;
            int lineWidth = 0;
            char[] chars = data.text.toCharArray();
            for (int j = 1; j <= chars.length; ++j) {
                int w = ClientProxy.Font.width(data.text.substring(0, j));
                if (xMouse < lineWidth + (w - lineWidth) / 2) {
                    return data.start + j - 1;
                }
                lineWidth = w;
            }
            return data.end - 1;
        }
        return this.container.text.length();
    }

    @Override
    public boolean func_146201_a(char c, int i) {
        if (!this.active) {
            return false;
        }
        if (this.isKeyComboCtrlA(i)) {
            this.cursorPosition = 0;
            this.startSelection = 0;
            this.endSelection = this.field_146216_j.length();
            return true;
        }
        if (!this.isEnabled()) {
            return false;
        }
        String original = this.field_146216_j;
        if (i == 203) {
            int j = 1;
            if (GuiScreen.func_146271_m()) {
                Matcher m = this.container.regexWord.matcher(this.field_146216_j.substring(0, this.cursorPosition));
                while (m.find()) {
                    if (m.start() == m.end()) continue;
                    j = this.cursorPosition - m.start();
                }
            }
            this.setCursor(this.cursorPosition - j, GuiScreen.func_146272_n());
            return true;
        }
        if (i == 205) {
            Matcher m;
            int j = 1;
            if (GuiScreen.func_146271_m() && ((m = this.container.regexWord.matcher(this.field_146216_j.substring(this.cursorPosition))).find() && m.start() > 0 || m.find())) {
                j = m.start();
            }
            this.setCursor(this.cursorPosition + j, GuiScreen.func_146272_n());
            return true;
        }
        if (i == 200) {
            this.setCursor(this.cursorUp(), GuiScreen.func_146272_n());
            return true;
        }
        if (i == 208) {
            this.setCursor(this.cursorDown(), GuiScreen.func_146272_n());
            return true;
        }
        if (i == 211) {
            String s = this.getSelectionAfterText();
            if (!s.isEmpty() && this.startSelection == this.endSelection) {
                s = s.substring(1);
            }
            this.func_146180_a(this.getSelectionBeforeText() + s);
            this.endSelection = this.cursorPosition = this.startSelection;
            return true;
        }
        if (this.isKeyComboCtrlBackspace(i)) {
            String s = this.getSelectionBeforeText();
            if (this.startSelection > 0 && this.startSelection == this.endSelection) {
                int nearestCondition = this.cursorPosition;
                boolean cursorInWhitespace = Character.isWhitespace(s.charAt(this.cursorPosition - 1));
                if (cursorInWhitespace) {
                    for (int g = this.cursorPosition - 1; g >= 0; --g) {
                        char currentChar = s.charAt(g);
                        if (!Character.isWhitespace(currentChar)) {
                            nearestCondition = g;
                            break;
                        }
                        if (g != 0) continue;
                        nearestCondition = 0;
                    }
                } else {
                    for (int g = this.cursorPosition - 1; g >= 0; --g) {
                        char currentChar = s.charAt(g);
                        if (Character.isWhitespace(currentChar) || currentChar == '\n') {
                            nearestCondition = g;
                            break;
                        }
                        if (g != 0) continue;
                        nearestCondition = 0;
                    }
                }
                s = s.substring(0, nearestCondition);
                this.startSelection -= this.cursorPosition - nearestCondition;
            }
            this.func_146180_a(s + this.getSelectionAfterText());
            this.endSelection = this.cursorPosition = this.startSelection;
            return true;
        }
        if (i == 14) {
            String s = this.getSelectionBeforeText();
            if (this.startSelection > 0 && this.startSelection == this.endSelection) {
                s = s.substring(0, s.length() - 1);
                --this.startSelection;
            }
            this.func_146180_a(s + this.getSelectionAfterText());
            this.endSelection = this.cursorPosition = this.startSelection;
            return true;
        }
        if (this.isKeyComboCtrlX(i)) {
            if (this.startSelection != this.endSelection) {
                NoppesStringUtils.setClipboardContents(this.field_146216_j.substring(this.startSelection, this.endSelection));
                String s = this.getSelectionBeforeText();
                this.func_146180_a(s + this.getSelectionAfterText());
                this.startSelection = this.cursorPosition = s.length();
                this.endSelection = this.cursorPosition;
            }
            return true;
        }
        if (this.isKeyComboCtrlC(i)) {
            if (this.startSelection != this.endSelection) {
                NoppesStringUtils.setClipboardContents(this.field_146216_j.substring(this.startSelection, this.endSelection));
            }
            return true;
        }
        if (this.isKeyComboCtrlV(i)) {
            this.addText(NoppesStringUtils.getClipboardContents());
            return true;
        }
        if (i == 44 && GuiScreen.func_146271_m()) {
            if (this.undoList.isEmpty()) {
                return false;
            }
            this.undoing = true;
            this.redoList.add(new UndoData(this.field_146216_j, this.cursorPosition));
            UndoData data = this.undoList.remove(this.undoList.size() - 1);
            this.func_146180_a(data.text);
            this.startSelection = this.cursorPosition = data.cursorPosition;
            this.endSelection = this.cursorPosition;
            this.undoing = false;
            return true;
        }
        if (i == 21 && GuiScreen.func_146271_m()) {
            if (this.redoList.isEmpty()) {
                return false;
            }
            this.undoing = true;
            this.undoList.add(new UndoData(this.field_146216_j, this.cursorPosition));
            UndoData data = this.redoList.remove(this.redoList.size() - 1);
            this.func_146180_a(data.text);
            this.startSelection = this.cursorPosition = data.cursorPosition;
            this.endSelection = this.cursorPosition;
            this.undoing = false;
            return true;
        }
        if (i == 15) {
            this.addText("    ");
        }
        if (i == 28) {
            this.addText(Character.toString('\n') + this.getIndentCurrentLine());
        }
        if (ChatAllowedCharacters.func_71566_a((char)c)) {
            this.addText(Character.toString(c));
        }
        return true;
    }

    private boolean isShiftKeyDown() {
        return Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54);
    }

    private boolean isAltKeyDown() {
        return Keyboard.isKeyDown((int)56) || Keyboard.isKeyDown((int)184);
    }

    private boolean isKeyComboCtrlX(int keyID) {
        return keyID == 45 && GuiScreen.func_146271_m() && !this.isShiftKeyDown() && !this.isAltKeyDown();
    }

    private boolean isKeyComboCtrlBackspace(int keyID) {
        return keyID == 14 && GuiScreen.func_146271_m() && !this.isShiftKeyDown() && !this.isAltKeyDown();
    }

    private boolean isKeyComboCtrlV(int keyID) {
        return keyID == 47 && GuiScreen.func_146271_m() && !this.isShiftKeyDown() && !this.isAltKeyDown();
    }

    private boolean isKeyComboCtrlC(int keyID) {
        return keyID == 46 && GuiScreen.func_146271_m() && !this.isShiftKeyDown() && !this.isAltKeyDown();
    }

    private boolean isKeyComboCtrlA(int keyID) {
        return keyID == 30 && GuiScreen.func_146271_m() && !this.isShiftKeyDown() && !this.isAltKeyDown();
    }

    private String getIndentCurrentLine() {
        int i;
        TextContainer.LineData data;
        Iterator<TextContainer.LineData> var1 = this.container.lines.iterator();
        do {
            if (!var1.hasNext()) {
                return "";
            }
            data = var1.next();
        } while (this.cursorPosition <= data.start || this.cursorPosition > data.end);
        for (i = 0; i < data.text.length() && data.text.charAt(i) == ' '; ++i) {
        }
        return data.text.substring(0, i);
    }

    private void setCursor(int i, boolean select) {
        if ((i = Math.min(Math.max(i, 0), this.field_146216_j.length())) != this.cursorPosition) {
            if (!select) {
                this.startSelection = this.cursorPosition = i;
                this.endSelection = this.cursorPosition;
            } else {
                int diff = this.cursorPosition - i;
                if (this.cursorPosition == this.startSelection) {
                    this.startSelection -= diff;
                } else if (this.cursorPosition == this.endSelection) {
                    this.endSelection -= diff;
                }
                if (this.startSelection > this.endSelection) {
                    int j = this.endSelection;
                    this.endSelection = this.startSelection;
                    this.startSelection = j;
                }
                this.cursorPosition = i;
            }
        }
    }

    private void addText(String s) {
        this.func_146180_a(this.getSelectionBeforeText() + s + this.getSelectionAfterText());
        this.startSelection = this.cursorPosition = this.startSelection + s.length();
        this.endSelection = this.cursorPosition;
    }

    private int cursorUp() {
        for (int i = 0; i < this.container.lines.size(); ++i) {
            TextContainer.LineData data = this.container.lines.get(i);
            if (this.cursorPosition < data.start || this.cursorPosition >= data.end) continue;
            if (i == 0) {
                return 0;
            }
            int var10000 = this.cursorPosition - data.start;
            return this.getSelectionPos(this.x + 1 + ClientProxy.Font.width(data.text.substring(0, this.cursorPosition - data.start)), this.y + 1 + (i - 1 - this.scrolledLine) * this.container.lineHeight);
        }
        return 0;
    }

    private int cursorDown() {
        for (int i = 0; i < this.container.lines.size(); ++i) {
            TextContainer.LineData data = this.container.lines.get(i);
            if (this.cursorPosition < data.start || this.cursorPosition >= data.end) continue;
            int var10000 = this.cursorPosition - data.start;
            return this.getSelectionPos(this.x + 1 + ClientProxy.Font.width(data.text.substring(0, this.cursorPosition - data.start)), this.y + 1 + (i + 1 - this.scrolledLine) * this.container.lineHeight);
        }
        return this.field_146216_j.length();
    }

    public String getSelectionBeforeText() {
        return this.startSelection == 0 ? "" : this.field_146216_j.substring(0, this.startSelection);
    }

    public String getSelectionAfterText() {
        return this.field_146216_j.substring(this.endSelection);
    }

    @Override
    public void func_146192_a(int xMouse, int yMouse, int mouseButton) {
        boolean bl = this.active = xMouse >= this.x && xMouse < this.x + this.field_146218_h && yMouse >= this.y && yMouse < this.y + this.field_146219_i;
        if (this.active) {
            this.endSelection = this.cursorPosition = this.getSelectionPos(xMouse, yMouse);
            this.startSelection = this.cursorPosition;
            this.clicked = mouseButton == 0;
            this.doubleClicked = false;
            long time = System.currentTimeMillis();
            if (this.clicked && this.container.linesCount * this.container.lineHeight > this.field_146219_i && xMouse > this.x + this.field_146218_h - 8) {
                this.clicked = false;
                this.clickScrolling = true;
            } else if (time - this.lastClicked < 500L) {
                this.doubleClicked = true;
                Matcher m = this.container.regexWord.matcher(this.field_146216_j);
                while (m.find()) {
                    if (this.cursorPosition <= m.start() || this.cursorPosition >= m.end()) continue;
                    this.startSelection = m.start();
                    this.endSelection = m.end();
                    break;
                }
            }
            this.lastClicked = time;
            activeTextfield = this;
        }
    }

    public void func_146178_a() {
        ++this.cursorCounter;
        int k2 = Mouse.getDWheel();
        if (k2 != 0) {
            this.scrolledLine += k2 > 0 ? -1 : 1;
            this.scrolledLine = Math.max(Math.min(this.scrolledLine, this.container.linesCount - this.field_146219_i / this.container.lineHeight), 0);
        }
    }

    public void func_146180_a(String text) {
        if (text == null) {
            return;
        }
        text = text.replace("\r", "");
        text = text.replace("\t", "    ");
        if (this.field_146216_j == null || !this.field_146216_j.equals(text)) {
            if (this.listener != null) {
                this.listener.textUpdate(text);
            }
            if (!this.undoing) {
                this.undoList.add(new UndoData(this.field_146216_j, this.cursorPosition));
                this.redoList.clear();
            }
            this.field_146216_j = text;
            this.container = new TextContainer(text);
            this.container.init(this.field_146218_h, this.field_146219_i);
            if (this.enableCodeHighlighting) {
                this.container.formatCodeText();
            }
            if (this.scrolledLine > this.container.linesCount - this.container.visibleLines) {
                this.scrolledLine = Math.max(0, this.container.linesCount - this.container.visibleLines);
            }
        }
    }

    public String func_146179_b() {
        return this.field_146216_j;
    }

    public boolean isEnabled() {
        return this.enabled && this.field_146220_v;
    }

    public boolean hasVerticalScrollbar() {
        return this.container.visibleLines < this.container.linesCount;
    }

    public void enableCodeHighlighting() {
        this.enableCodeHighlighting = true;
        this.container.formatCodeText();
    }

    public void setListener(ITextChangeListener listener) {
        this.listener = listener;
    }

    class UndoData {
        public String text;
        public int cursorPosition;

        public UndoData(String text, int cursorPosition) {
            this.text = text;
            this.cursorPosition = cursorPosition;
        }
    }
}

